/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.property;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.PropertyData;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.property.IPropertyTypeList;
import com.elixirtech.report2.raw.property.PropertyTypes;
import com.elixirtech.sax.BeanUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MasterPropertyList
implements IMasterPropertyList {
    private IPropertyTypeList m_TypeList;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MasterPropertyList.class);
    private Map<String, PropertyData> m_PropertyMap = new HashMap<String, PropertyData>(201);

    public MasterPropertyList(IPropertyTypeList iPropertyTypeList) {
        this.m_TypeList = iPropertyTypeList;
        this.initProperties();
    }

    @Override
    public Collection<PropertyData> getPropertyData() {
        return Collections.unmodifiableCollection(this.m_PropertyMap.values());
    }

    @Override
    public PropertyType getPropertyType(Name name) {
        PropertyData propertyData = this.m_PropertyMap.get(name.getName());
        if (propertyData != null) {
            return propertyData.type;
        }
        return null;
    }

    @Override
    public Object getDefaultValue(Name name) {
        PropertyData propertyData = this.m_PropertyMap.get(name.getName());
        if (propertyData != null) {
            return propertyData.defaultValue;
        }
        return null;
    }

    @Override
    public boolean contains(Name name) {
        return this.m_PropertyMap.containsKey(name.getName());
    }

    @Override
    public boolean isInherited(Name name) {
        PropertyData propertyData = this.m_PropertyMap.get(name.getName());
        if (propertyData != null) {
            return propertyData.inherited;
        }
        return false;
    }

    @Override
    public Object getValue(Name name, String string) {
        PropertyType propertyType = this.getPropertyType(name);
        if (propertyType == null) {
            m_Log.warn((Object)(name.getName() + " does not have a registered type"));
            return null;
        }
        return propertyType.toType(string);
    }

    @Override
    public void register(Name name, PropertyType propertyType, Object object, boolean bl, boolean bl2) {
        this.m_PropertyMap.put(name.getName(), new PropertyData(name, propertyType, object, bl, bl2));
    }

    private void register(String string, PropertyType propertyType, Object object, boolean bl) {
        this.register(BeanUtil.getName(string), propertyType, object, bl, false);
    }

    private void register(String string, PropertyType propertyType, Object object, boolean bl, boolean bl2) {
        this.register(BeanUtil.getName(string), propertyType, object, bl, bl2);
    }

    private void initProperties() {
        this.register("Common.ImageResolution", PropertyType.INTEGER, (Object)72, true, true);
        this.register("Common.KeepTogether", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Common.KeepWithNext", PropertyType.BOOLEAN, Boolean.FALSE, false);
        this.register("Common.ShowAsImage", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Common.Preview", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("Common.Weight", PropertyType.INTEGER, 100, true);
        this.register("Common.HorizontalAlignment", this.m_TypeList.getPropertyType("Choice.HorizontalAlignment"), "Left", true);
        this.register("Common.VerticalAlignment", this.m_TypeList.getPropertyType("Choice.VerticalAlignment"), "Top", true);
        this.register("Common.BackgroundColor", PropertyType.COLOUR, "", true);
        this.register("Common.Locale", PropertyTypes.LOCALE, null, true, true);
        this.register("Common.URL", PropertyType.STRING, "", true);
        this.register("Common.URLDescription", PropertyType.STRING, "", true);
        this.register("Common.URLTarget", this.m_TypeList.getPropertyType("Choice.URLTarget"), "", true);
        this.register("Common.Left", PropertyType.TWIP, 0, true);
        this.register("Common.Top", PropertyType.TWIP, 0, true);
        this.register("Common.Width", PropertyType.TWIP, 0, true);
        this.register("Common.Height", PropertyType.TWIP, 0, true);
        this.register("Barcode.Type", PropertyTypes.WIZARD, "Code128", false);
        this.register("Barcode.Category", PropertyTypes.WIZARD, "Code128-Category", false);
        this.register("Barcode.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("CallbackElement.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(), true);
        this.register("CallbackElement.Text", PropertyType.STRING, "", true);
        this.register("Chart.Type", PropertyType.STRING, "", false);
        this.register("Chart.URL", PropertyType.STRING, "", false);
        ControlSource controlSource = new ControlSource();
        controlSource.setType("URL");
        controlSource.setURL("resource:images/tick.gif");
        controlSource.setURLType("Image");
        ControlSource controlSource2 = new ControlSource();
        controlSource2.setType("URL");
        controlSource2.setURL("resource:images/box.gif");
        controlSource2.setURLType("Image");
        this.register("CheckBox.OnImage", PropertyTypes.CONTROL_SOURCE, controlSource, true);
        this.register("CheckBox.OffImage", PropertyTypes.CONTROL_SOURCE, controlSource2, true);
        this.register("CheckBox.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("Chunk.OnLayout", PropertyTypes.SCRIPT, new Script(), true);
        this.register("CubeHeader.BackgroundTopLeft", PropertyType.COLOUR, "", true);
        this.register("CubeHeader.BackgroundBottomRight", PropertyType.COLOUR, "", true);
        this.register("CubeHeader.Title", PropertyType.STRING, (Object)"All", true, true);
        this.register("CubeMeasure.ShowText", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeMeasure.ShowIcon", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeMeasure.TextAlignment", this.m_TypeList.getPropertyType("Choice.HorizontalAlignment"), "Right", true);
        this.register("CubeMeasure.IconAlignment", this.m_TypeList.getPropertyType("Choice.LeftRightAlignment"), "Right", true);
        this.register("CubeMeasure.WidthOverrideType", this.m_TypeList.getPropertyType("Choice.WidthOverride"), "BestFit", true);
        this.register("CubeMeasure.WidthOverride", PropertyType.TWIP, 0, true);
        this.register("CubeRow.WidthOverrideType", this.m_TypeList.getPropertyType("Choice.WidthOverride"), "BestFit", true);
        this.register("CubeRow.WidthOverride", PropertyType.TWIP, 0, true);
        this.register("CubeTable.Cache", PropertyType.STRING, "", true);
        this.register("CubeTable.DataRange", this.m_TypeList.getPropertyType("Choice.DataRange"), "All", false);
        this.register("CubeTable.CollapseColumns", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeTable.CollapseRows", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeTable.KeepColumnTotals", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeTable.KeepRowTotals", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("CubeTable.WidthGrowable", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.WidthShrinkable", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.GrowHPageCount", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.MergeHeaderBorders", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("CubeTable.ShowColumnHeaders", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.ShowRowHeaders", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.ShowColumnTotalsAfterDetails", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.ShowRowTotalsAfterDetails", PropertyType.BOOLEAN, (Object)Boolean.TRUE, true, true);
        this.register("CubeTable.RowTotalsTitle", PropertyType.STRING, "", false);
        this.register("CubeTable.RowTotals", PropertyType.STRING, "", false);
        this.register("CubeTable.ColumnTotalsTitle", PropertyType.STRING, "", false);
        this.register("CubeTable.ShowRowHeaderLabels", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("DataSource.Name", PropertyType.STRING, "", false);
        this.register("DataSource.DataSourceName", this.m_TypeList.getPropertyType("Choice.DataSource"), "", false);
        this.register("DataSource.TestMode", PropertyType.BOOLEAN, Boolean.FALSE, false);
        this.register("Field.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("Field.HideDuplicates", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Field.Format", PropertyTypes.FORMAT, new Format(), false);
        this.register("Field.Orientation", PropertyType.INTEGER, 0, true);
        this.register("Field.LineHeight", PropertyType.STRING, "normal", true);
        this.register("Field.AutoWrap", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("Graph.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("Graph.SizeMode", this.m_TypeList.getPropertyType("Choice.RectangleSize"), (Object)"Clip", true, true);
        this.register("Graph.GraphLayout", this.m_TypeList.getPropertyType("Choice.GraphLayout"), (Object)"hierarchical", true, true);
        this.register("Grid.LineGridMode", PropertyType.STRING, (Object)"All", true, true);
        this.register("Grid.LineGridProgression", PropertyType.STRING, (Object)"Text-Height", true, true);
        this.register("Grid.AutoWrap", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Grid.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("Grid.WritingMode", this.m_TypeList.getPropertyType("Choice.WritingMode"), (Object)WritingMode.LR_TB.getName(), true, true);
        this.register("Grid.GlyphOrientation", this.m_TypeList.getPropertyType("Choice.Orientation"), (Object)"Auto", true, true);
        this.register("Grid.BoxBorderColor", PropertyType.COLOUR, (Object)"Black", true, true);
        this.register("Grid.BoxBorderSide", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Grid.BoxBorderTop", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Grid.BoxBorderBottom", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Grid.BoxBorderHeight", PropertyType.INTEGER, 100, true);
        this.register("Grid.CharacterOffsetX", PropertyType.TWIP, 0, true);
        this.register("Grid.CharacterOffsetY", PropertyType.TWIP, 0, true);
        this.register("Group.Field", this.m_TypeList.getPropertyType("Choice.DataField"), "", false);
        this.register("Group.SortOrder", this.m_TypeList.getPropertyType("Choice.Sort"), "None", false);
        this.register("Group.GroupHeaderVisible", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("Group.GroupFooterVisible", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("Group.GroupOn", this.m_TypeList.getPropertyType("Choice.GroupOn"), "None", false);
        this.register("Group.GroupData", PropertyType.STRING, "", false);
        this.register("GroupHeader.RepeatSection", PropertyType.BOOLEAN, Boolean.FALSE, false);
        ControlSource controlSource3 = new ControlSource();
        controlSource3.setType("URL");
        controlSource3.setURL("resource:images/image.gif");
        controlSource3.setURLType("Image");
        this.register("Image.ControlSource", PropertyTypes.CONTROL_SOURCE, controlSource3, true);
        this.register("Image.SizeMode", this.m_TypeList.getPropertyType("Choice.RectangleSize"), (Object)"Clip", true, true);
        this.register("Image.PictureAlignment", this.m_TypeList.getPropertyType("Choice.RectangleAlignment"), (Object)"Top Left", true, true);
        this.register("Line.X1", PropertyType.TWIP, 0, false);
        this.register("Line.Y1", PropertyType.TWIP, 0, false);
        this.register("Line.X2", PropertyType.TWIP, 40, false);
        this.register("Line.Y2", PropertyType.TWIP, 40, false);
        this.register("Line.LineWidth", PropertyType.TWIP, 20, true);
        this.register("Line.ArrowWidth1", PropertyType.TWIP, 200, true);
        this.register("Line.ArrowWidth2", PropertyType.TWIP, 200, true);
        this.register("Line.LineColor", PropertyType.COLOUR, (Object)"Black", true, true);
        this.register("Line.LineStyle", PropertyType.STRING, (Object)"Solid", true, true);
        this.register("Line.ArrowStyle1", PropertyType.STRING, (Object)"None", true, true);
        this.register("Line.ArrowStyle2", PropertyType.STRING, (Object)"None", true, true);
        this.register("Line.ArrowColor1", PropertyType.STRING, (Object)"Black", true, true);
        this.register("Line.ArrowColor2", PropertyType.STRING, (Object)"Black", true, true);
        this.register("MapElement.MapFile", PropertyTypes.WIZARD, "", false);
        this.register("MapElement.DataKey", PropertyTypes.WIZARD, (Object)"", false, false);
        this.register("MapElement.DataColumn", PropertyTypes.WIZARD, (Object)"", false, false);
        this.register("PageBreak.Position", PropertyType.TWIP, 0, false);
        this.register("PageBreak.ResetPageCount", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("PageSetup.Name", PropertyType.STRING, "", false);
        this.register("Rectangle.BorderLeft", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("Rectangle.BorderRight", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("Rectangle.BorderTop", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("Rectangle.BorderBottom", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("Rectangle.BorderRadius", PropertyType.TWIP, 0, true);
        this.register("Section.KeepBlankPages", PropertyType.BOOLEAN, Boolean.FALSE, false);
        this.register("Section.Name", PropertyType.STRING, "", false);
        this.register("SectionInvocation.ReportName", PropertyType.STRING, "", false);
        this.register("SectionInvocation.SectionName", PropertyType.STRING, "", false);
        this.register("SectionInvocation.DataSourceName", PropertyType.STRING, "", false);
        this.register("SectionInvocation.Enabled", PropertyType.BOOLEAN, Boolean.TRUE, false);
        this.register("SubReport.ReportName", PropertyTypes.WIZARD, "", false);
        this.register("SubReport.SectionName", PropertyTypes.WIZARD, "", false);
        this.register("SubReport.DataSourceName", PropertyTypes.WIZARD, "", false);
        this.register("SVG.Dynamic", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("SVG.Location", PropertyType.STRING, "", false);
        this.register("Table.HeaderHeight", PropertyType.TWIP, 400, true);
        this.register("Table.FooterHeight", PropertyType.TWIP, 400, true);
        this.register("Table.ShowEmptyTable", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("Table.Cache", PropertyType.STRING, "", true);
        this.register("TextElement.FirstLineIndent", PropertyType.TWIP, (Object)0, true, true);
        this.register("TextElement.FontName", PropertyType.STRING, (Object)"Serif", true, true);
        this.register("TextElement.FontColor", PropertyType.COLOUR, (Object)"Black", true, true);
        this.register("TextElement.FontSize", PropertyType.POINT, (Object)240, true, true);
        this.register("TextElement.FontBold", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("TextElement.FontItalic", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("TextElement.FontUnderline", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("TextElement.FontStrikethrough", PropertyType.BOOLEAN, (Object)Boolean.FALSE, true, true);
        this.register("TextElement.TextAlign", this.m_TypeList.getPropertyType("Choice.TextAlignment"), (Object)"Left", true, true);
        this.register("RawElement.BorderStyle", this.m_TypeList.getPropertyType("Choice.BorderStyle"), "None", true);
        this.register("RawElement.BorderColor", PropertyType.COLOUR, "Black", true);
        this.register("RawElement.BorderWidth", PropertyType.TWIP, 20, true);
        this.register("RawElement.Name", PropertyType.STRING, "", false);
        this.register("RawElement.PaddingLeft", PropertyType.TWIP, 0, true);
        this.register("RawElement.PaddingTop", PropertyType.TWIP, 0, true);
        this.register("RawElement.PaddingRight", PropertyType.TWIP, 0, true);
        this.register("RawElement.PaddingBottom", PropertyType.TWIP, 0, true);
        this.register("RawElement.Growable", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("RawElement.Shrinkable", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("RawElement.Visible", PropertyType.BOOLEAN, Boolean.TRUE, true);
        this.register("RawElementHolder.Caption", PropertyType.STRING, "", false);
        this.register("RawElementHolder.ForceNewPage", this.m_TypeList.getPropertyType("Choice.ForcePageBreak"), "None", true);
        this.register("RawElementHolder.NewRowOrCol", PropertyType.STRING, "None", true);
        this.register("RawElementHolder.PaddingBottom", PropertyType.INTEGER, 0, true);
        this.register("RawElementHolder.VerticalAlign", PropertyType.STRING, "Top", true);
        this.register("RawModelElement.Fill", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("RawModelElement.LockHandles", PropertyType.BOOLEAN, Boolean.FALSE, true);
        this.register("RawModelElement.RenderIf", PropertyTypes.SCRIPT, new Script(), true);
        this.register("RawModelElement.OnRenderBegin", PropertyTypes.SCRIPT, new Script(), true);
        this.register("RawModelElement.OnRenderEnd", PropertyTypes.SCRIPT, new Script(), true);
        this.register("RTF.ControlSource", PropertyTypes.CONTROL_SOURCE, new ControlSource(""), false);
        this.register("StyledElement.StyleName", this.m_TypeList.getPropertyType("Choice.Style"), "", false);
        ControlSource controlSource4 = new ControlSource();
        controlSource4.setType("Literal");
        this.register("TOCElementHolder.ControlSource", PropertyTypes.CONTROL_SOURCE, controlSource4, false);
        this.register("TOCElementHolder.TableOfContents", PropertyType.BOOLEAN, Boolean.FALSE, false);
        this.register("Table.DataRange", this.m_TypeList.getPropertyType("Choice.DataRange"), "All", false);
    }
}

