/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.script;

import com.elixirtech.js.CompiledScript;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.script.JSEngine;

public class ScriptEngine {
    public static final String JAVASCRIPT = "javascript";
    public static final String JAVASCRIPT_PREFIX = "=javascript:";
    private JSEngine m_JSEngine;

    public ScriptEngine(JSEngine jSEngine) {
        this.m_JSEngine = jSEngine;
    }

    public void define(String string, String string2, Object object) {
        if (string.equals(JAVASCRIPT)) {
            this.m_JSEngine.declareBean(string2, object);
        }
    }

    public void undefine(String string, String string2) {
        if (string.equals(JAVASCRIPT)) {
            this.m_JSEngine.undeclareBean(string2);
        }
    }

    public Object evaluate(String string) {
        if ((string = string.trim()).startsWith(JAVASCRIPT_PREFIX)) {
            string = string.substring(JAVASCRIPT_PREFIX.length());
            return this.evaluate(JAVASCRIPT, "evaluate", string);
        }
        if (string.startsWith("=")) {
            string = string.substring(1);
            return this.evaluate(JAVASCRIPT, "evaluate", string);
        }
        return this.evaluate(JAVASCRIPT, "evaluate", string);
    }

    public Object evaluate(Script script) {
        String string = script.getLanguage();
        if (this.m_JSEngine.isDebug()) {
            return this.evaluate(string, script.getTagName(), script.getText());
        }
        if (JAVASCRIPT.equals(string)) {
            CompiledScript compiledScript = script.getCompiledScript();
            if (compiledScript == null) {
                compiledScript = this.m_JSEngine.compile("report script", script.getText());
                script.setCompiledScript(compiledScript);
            }
            return this.m_JSEngine.evaluate(compiledScript);
        }
        String string2 = script.getText();
        return this.evaluate(string, "report script", string2);
    }

    public Object evaluate(String string, String string2, String string3) {
        if (JAVASCRIPT.equals(string)) {
            return this.m_JSEngine.evaluate(string2, string3);
        }
        return null;
    }

    public void pushScope() {
        this.m_JSEngine.pushScope();
    }

    public void popScope() {
        this.m_JSEngine.popScope();
    }

    public void pushJSScope(Object object) {
        this.m_JSEngine.pushScope(object);
    }

    public void popJSScope() {
        this.m_JSEngine.popScope();
    }

    public void dumpScope() {
        this.m_JSEngine.dumpScope();
    }
}

