/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.util;

import java.io.IOException;
import java.io.OutputStream;

public class ByteCounterOutputStream
extends OutputStream {
    private OutputStream m_Output;
    private long m_Count;

    public ByteCounterOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null output stream");
        }
        this.m_Output = outputStream;
        this.m_Count = 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.m_Output != null) {
            super.close();
            this.m_Output.close();
            this.m_Output = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_Output.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.m_Output.write(byArray);
        this.m_Count += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.m_Output.write(byArray, n, n2);
        this.m_Count += (long)n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.m_Output.write(n);
        ++this.m_Count;
    }

    public long getByteCount() {
        return this.m_Count;
    }
}

