/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.util;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.report2.RenderContext;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLFileUtil;
import com.elixirtech.repository.RMLRepository;
import com.elixirtech.util.FileUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageLoader {
    private static String IML = "ImageLoader.";
    protected static String PREFIX = "<Pickup>";
    protected static Map<String, Image> m_ImageCache = new HashMap<String, Image>();
    protected static int m_ImageId = 0;
    protected static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageLoader.class);

    public static Image loadFromPath(RenderContext renderContext, String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        String string2 = ImageLoader.getKey(string);
        Image image = (Image)renderContext.getCache(string2);
        if (image != null) {
            return image;
        }
        Image image2 = ImageLoader.loadFromPath(string);
        if (image2 != null) {
            renderContext.setCache(string2, image2);
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image loadFromPath(String string) {
        BufferedImage bufferedImage;
        if (URLUtil.isURL(string)) {
            InputStream inputStream = null;
            BufferedImage bufferedImage2 = null;
            try {
                inputStream = URLLoader.getInputStream(string);
                bufferedImage2 = ImageIO.read(inputStream);
                return bufferedImage2;
            }
            finally {
                FileUtil.close(inputStream);
            }
        }
        string = string.replace('\\', '/');
        RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
        RMLFileObject rMLFileObject = rMLRepository.getFileJ(string);
        if (rMLFileObject == null) return ImageLoader.getImageResource("/" + string);
        InputStream inputStream = null;
        try {
            BufferedImage bufferedImage3;
            inputStream = rMLFileObject.getInputStream();
            bufferedImage = bufferedImage3 = ImageIO.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                FileUtil.close(inputStream);
                throw throwable;
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Unable to load image " + string + " from Repository"));
                return null;
            }
        }
        FileUtil.close(inputStream);
        return bufferedImage;
    }

    public static byte[] loadBytesFromPath(RenderContext renderContext, String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        try {
            if (URLUtil.isURL(string)) {
                return URLLoader.load(string);
            }
            string = string.replace('\\', '/');
            RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
            RMLFileObject rMLFileObject = rMLRepository.getFileJ(string);
            if (rMLFileObject != null) {
                return RMLFileUtil.getBytes(rMLFileObject);
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Unable to load bytes from path " + string));
        }
        return null;
    }

    private static Image getImageResource(String string) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource(string);
            BufferedImage bufferedImage = ImageIO.read(uRL);
            return bufferedImage;
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getImageResource(" + string + ") " + throwable));
            return null;
        }
    }

    public static Image extractImage(String string) {
        Image image = m_ImageCache.get(string);
        if (image != null) {
            m_ImageCache.remove(string);
        }
        return image;
    }

    public static synchronized String addImage(Image image) {
        String string = PREFIX + ++m_ImageId;
        m_ImageCache.put(string, image);
        if (m_ImageCache.size() > 5) {
            m_Log.warn((Object)("The image cache holds " + m_ImageCache.size() + " images"));
        }
        return string;
    }

    public static String getKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IML).append(string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(IResourceProvider iResourceProvider, String object) {
        Object object2;
        if (object == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            if (!URLUtil.isURL((String)object)) {
                RMLFileObject rMLFileObject;
                object2 = new File((String)object);
                if (((File)object2).exists()) {
                    object = FileUtil.asURL((File)object2);
                }
                object = (rMLFileObject = iResourceProvider.getFile((String)object)) != null ? "repository:" + rMLFileObject.getPath() : "resource:" + (String)object;
            }
            object2 = (inputStream = URLLoader.getInputStream((String)object)) != null ? ImageIO.read(inputStream) : null;
        }
        catch (IOException iOException) {
            Image image;
            try {
                image = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
            return image;
        }
        FileUtil.close(inputStream);
        return object2;
    }

    public static class Descriptor {
        public String name;
        public Image image;

        public Descriptor(String string, Image image) {
            assert (string != null || image != null);
            this.name = string;
            this.image = image;
        }
    }
}

