/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.util;

import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.repository.RMLFileObject;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LogicalImageLoader
extends ImageLoader {
    public static ImageLoader.Descriptor resolve(LogicalRenderContext logicalRenderContext, ControlSource controlSource) {
        String string;
        if ("Script".equals(controlSource.getType())) {
            Object object;
            ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
            String string2 = controlSource.getText();
            if (string2.startsWith("=")) {
                string2 = string2.substring(1);
            }
            if ((object = scriptEngine.evaluate(string2)) instanceof Image) {
                return new ImageLoader.Descriptor(null, (Image)object);
            }
            if (object instanceof String) {
                String string3 = (String)object;
                if (string3.startsWith(PREFIX)) {
                    Image image = LogicalImageLoader.extractImage(string3);
                    return new ImageLoader.Descriptor(null, image);
                }
                return new ImageLoader.Descriptor(string3, null);
            }
            m_Log.error((Object)("Image Script does not evaluate to an image or a string: " + string2));
            return null;
        }
        if ("URL".equals(controlSource.getType())) {
            Object object = controlSource.getURL();
            if (!URLUtil.isURL((String)object)) {
                RMLFileObject rMLFileObject = RenderStack.current().getFile((String)object);
                object = rMLFileObject != null ? "repository:" + rMLFileObject.getPath() : "resource:" + (String)object;
            } else if (((String)object).startsWith("repository:") && !((String)object).startsWith("repository:/")) {
                String string4 = ((String)object).substring("repository:".length());
                RMLFileObject rMLFileObject = RenderStack.current().getFile(string4);
                if (rMLFileObject != null) {
                    object = "repository:" + rMLFileObject.getPath();
                }
            }
            return new ImageLoader.Descriptor((String)object, null);
        }
        Image image = null;
        Object object = ControlSourceProcessor.getData(controlSource);
        if (object instanceof Image) {
            image = (Image)object;
        } else if (object instanceof byte[]) {
            try {
                image = ImageIO.read(new ByteArrayInputStream((byte[])object));
                if (image == null) {
                    m_Log.error((Object)"Java ImageIO can't determine or process this image format");
                }
            }
            catch (IOException iOException) {
                m_Log.warn((Object)("Can't convert bytes to image: " + iOException));
            }
        } else if (object instanceof String && URLUtil.isURL(string = (String)object)) {
            return new ImageLoader.Descriptor(string, null);
        }
        if (image != null) {
            return new ImageLoader.Descriptor(null, image);
        }
        m_Log.error((Object)"Can't read image");
        return null;
    }
}

