/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RTFImage
extends RTFChunk {
    private static final int ZOOM_CONSTANT = 134;
    private static final int WORD_2003_ZOOM_CONSTANT = 100;
    private BufferedImage m_Image;
    private String m_SizeMode;
    private int m_Alignment;
    private int m_X;
    private int m_Y;
    private int m_Width;
    private int m_Height;
    private boolean m_Word2003;

    public void setImage(BufferedImage bufferedImage) {
        this.m_Image = bufferedImage;
    }

    public void setSizeMode(String string) {
        this.m_SizeMode = string;
    }

    public void setAlignment(int n) {
        this.m_Alignment = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_X = n;
        this.m_Y = n2;
        this.m_Width = n3;
        this.m_Height = n4;
    }

    public void setWord2003(boolean bl) {
        this.m_Word2003 = bl;
    }

    @Override
    public void dispose() {
        this.m_Image.flush();
        this.m_Image = null;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        if (this.m_Image != null) {
            int n = this.m_Word2003 ? 100 : 134;
            int n2 = this.m_Image.getWidth();
            int n3 = this.m_Image.getHeight();
            byte[] byArray = this.getBytes();
            rTFWriter.push();
            rTFWriter.command("pard");
            rTFWriter.command("pvpg");
            rTFWriter.command("phpg");
            rTFWriter.command("posx" + this.m_X);
            rTFWriter.command("posy" + this.m_Y);
            rTFWriter.command("absw" + this.m_Width);
            rTFWriter.command("absh-" + this.m_Height);
            rTFWriter.push();
            rTFWriter.command("pict");
            rTFWriter.command("picw" + n2);
            rTFWriter.command("pich" + n3);
            rTFWriter.command("picwgoal" + (n2 *= 20));
            rTFWriter.command("pichgoal" + (n3 *= 20));
            if ("Clip".equals(this.m_SizeMode)) {
                int n4;
                rTFWriter.command("picscalex" + n);
                rTFWriter.command("picscaley" + n);
                int n5 = n2 - this.m_Width;
                int n6 = n3 - this.m_Height;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                if ((this.m_Alignment & 1) != 0) {
                    n7 = 0;
                    n9 = n5;
                } else if ((this.m_Alignment & 2) != 0) {
                    n7 = n4 = n5 / 2;
                    n9 = n5 - n4;
                } else if ((this.m_Alignment & 4) != 0) {
                    n7 = n5;
                    n9 = 0;
                }
                if ((this.m_Alignment & 8) != 0) {
                    n8 = 0;
                    n10 = n6;
                } else if ((this.m_Alignment & 0x10) != 0) {
                    n8 = n4 = n6 / 2;
                    n10 = n6 - n4;
                } else if ((this.m_Alignment & 0x20) != 0) {
                    n8 = n6;
                    n10 = 0;
                }
                rTFWriter.command("piccropl" + n7);
                rTFWriter.command("piccropt" + n8);
                rTFWriter.command("piccropr" + n9);
                rTFWriter.command("piccropb" + n10);
            } else if ("Stretch".equals(this.m_SizeMode)) {
                rTFWriter.command("picscalex" + this.m_Width * n / n2);
                rTFWriter.command("picscaley" + this.m_Height * n / n3);
            } else if ("Zoom".equals(this.m_SizeMode)) {
                int n11 = this.m_Width * n / n2;
                int n12 = this.m_Height * n / n3;
                int n13 = Math.min(n11, n12);
                rTFWriter.command("picscalex" + n13);
                rTFWriter.command("picscaley" + n13);
                int n14 = n2 * n13 / 100;
                int n15 = n3 * n13 / 100;
                if ((this.m_Alignment & 2) != 0) {
                    if (n11 != n13) {
                        rTFWriter.command("piccropl-" + (this.m_Width - n14) * 100 / (2 * n13));
                    }
                } else if ((this.m_Alignment & 4) != 0 && n11 != n13) {
                    rTFWriter.command("piccropl-" + (this.m_Width - n14) * 100 / n13);
                }
                if ((this.m_Alignment & 0x10) != 0) {
                    if (n12 != n13) {
                        rTFWriter.command("piccropt-" + (this.m_Height - n15) * 100 / (2 * n13));
                    }
                } else if ((this.m_Alignment & 0x20) != 0 && n12 != n13) {
                    rTFWriter.command("piccropt-" + (this.m_Height - n15) * 100 / n13);
                }
            }
            rTFWriter.command("pngblip");
            rTFWriter.bytes(byArray);
            rTFWriter.pop();
            rTFWriter.command("par");
            rTFWriter.pop();
        }
    }

    protected byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.m_Image, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

