/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFConstants;
import com.elixirtech.rtf.RTFWriter;
import java.awt.Color;
import java.io.IOException;

public class RTFPolyline
extends RTFChunk
implements RTFConstants {
    private String m_LineStyle;
    private int m_LineWidth;
    private Color m_LineColor;
    private Color m_FillColor;
    private int[] m_Xs;
    private int[] m_Ys;
    private boolean m_IsPolygon;

    public void setLineStyle(String string) {
        this.m_LineStyle = string;
    }

    public void setLineColor(Color color) {
        this.m_LineColor = color;
    }

    public void setLineWidth(int n) {
        this.m_LineWidth = n;
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        this.m_Xs = nArray;
        this.m_Ys = nArray2;
    }

    public void setPolygon(boolean bl) {
        this.m_IsPolygon = bl;
    }

    public void setFillColor(Color color) {
        this.m_FillColor = color;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        if (this.m_LineColor != null) {
            int n;
            String string = null;
            if ("Solid".equals(this.m_LineStyle)) {
                string = "dplinesolid";
            } else if ("Dashes".equals(this.m_LineStyle)) {
                string = "dplinedash";
            } else if ("Dots".equals(this.m_LineStyle)) {
                string = "dplinedot";
            }
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = Integer.MIN_VALUE;
            for (n = 0; n < this.m_Xs.length; ++n) {
                if (this.m_Xs[n] < n2) {
                    n2 = this.m_Xs[n];
                }
                if (this.m_Ys[n] < n3) {
                    n3 = this.m_Ys[n];
                }
                if (this.m_Xs[n] > n4) {
                    n4 = this.m_Xs[n];
                }
                if (this.m_Xs[n] <= n5) continue;
                n5 = this.m_Ys[n];
            }
            rTFWriter.push();
            rTFWriter.command("*\\do");
            rTFWriter.command("dobxpage");
            rTFWriter.command("dobypage");
            rTFWriter.command("dppolyline");
            rTFWriter.command("dppolycount" + this.m_Xs.length);
            for (n = 0; n < this.m_Xs.length; ++n) {
                rTFWriter.command("dpptx" + this.m_Xs[n]);
                rTFWriter.command("dppty" + this.m_Ys[n]);
            }
            rTFWriter.command("dpx" + n2);
            rTFWriter.command("dpy" + n3);
            rTFWriter.command("dpxsize" + (n4 - n2));
            rTFWriter.command("dpysize" + (n5 - n3));
            rTFWriter.command("dplinew" + this.m_LineWidth);
            rTFWriter.command("dplinecor" + this.m_LineColor.getRed());
            rTFWriter.command("dplinecog" + this.m_LineColor.getGreen());
            rTFWriter.command("dplinecob" + this.m_LineColor.getBlue());
            rTFWriter.command(string);
            if (this.m_IsPolygon && this.m_FillColor != null) {
                rTFWriter.command("dpfillbgcr" + this.m_FillColor.getRed());
                rTFWriter.command("dpfillbgcg" + this.m_FillColor.getGreen());
                rTFWriter.command("dpfillbgcb" + this.m_FillColor.getBlue());
                rTFWriter.command("dpfillpat1");
            }
            rTFWriter.pop();
        }
    }
}

