/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFWriter;
import java.awt.Color;
import java.io.IOException;

public class RTFRect
extends RTFChunk {
    private String m_LineStyle;
    private int m_LineWidth;
    private Color m_LineColor;
    private Color m_FillColor;
    private int m_X;
    private int m_Y;
    private int m_Width;
    private int m_Height;
    private int m_RoundingRadius;

    public void setLineStyle(String string) {
        this.m_LineStyle = string;
    }

    public void setLineColor(Color color) {
        this.m_LineColor = color;
    }

    public void setLineWidth(int n) {
        this.m_LineWidth = n;
    }

    public void setFillColor(Color color) {
        this.m_FillColor = color;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_X = n;
        this.m_Y = n2;
        this.m_Width = n3;
        this.m_Height = n4;
    }

    public void setRoundingRadius(int n) {
        this.m_RoundingRadius = n;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        if (this.m_LineColor != null || this.m_FillColor != null) {
            String string = null;
            if (this.m_LineColor == null) {
                string = "dplinehollow";
            }
            if ("Solid".equals(this.m_LineStyle)) {
                string = "dplinesolid";
            } else if ("Dashes".equals(this.m_LineStyle)) {
                string = "dplinedash";
            }
            rTFWriter.push();
            rTFWriter.command("*\\do");
            rTFWriter.command("dobxpage");
            rTFWriter.command("dobypage");
            rTFWriter.command("dprect");
            rTFWriter.command("dpx" + this.m_X);
            rTFWriter.command("dpy" + this.m_Y);
            rTFWriter.command("dpxsize" + this.m_Width);
            rTFWriter.command("dpysize" + this.m_Height);
            if (this.m_RoundingRadius != 0) {
                rTFWriter.command("dproundr" + this.m_RoundingRadius);
            }
            rTFWriter.command("dpptx" + this.m_X);
            rTFWriter.command("dppty" + this.m_Y);
            rTFWriter.command("dpptx" + (this.m_X + this.m_Width));
            rTFWriter.command("dppty" + (this.m_Y + this.m_Height));
            rTFWriter.command("dplinew" + this.m_LineWidth);
            if (this.m_LineColor != null) {
                rTFWriter.command("dplinecor" + this.m_LineColor.getRed());
                rTFWriter.command("dplinecog" + this.m_LineColor.getGreen());
                rTFWriter.command("dplinecob" + this.m_LineColor.getBlue());
            } else {
                rTFWriter.command("dplinecor" + this.m_FillColor.getRed());
                rTFWriter.command("dplinecog" + this.m_FillColor.getGreen());
                rTFWriter.command("dplinecob" + this.m_FillColor.getBlue());
            }
            if (this.m_FillColor != null) {
                rTFWriter.command("dpfillbgcr" + this.m_FillColor.getRed());
                rTFWriter.command("dpfillbgcg" + this.m_FillColor.getGreen());
                rTFWriter.command("dpfillbgcb" + this.m_FillColor.getBlue());
                rTFWriter.command("dpfillpat1");
            }
            rTFWriter.command(string);
            rTFWriter.pop();
        }
    }
}

