/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import java.io.IOException;
import java.io.Writer;

public class RTFWriter {
    protected Writer m_Writer;
    protected int m_Depth;

    public RTFWriter(Writer writer) throws IOException {
        this.m_Writer = writer;
        this.push();
        this.command("rtf1");
        this.command("ansi");
        this.command("deff0");
        this.newline();
    }

    public void command(String string) throws IOException {
        this.m_Writer.write("\\" + string + " ");
    }

    public void bytes(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (i % 80 == 0) {
                this.newline();
            }
            if ((n = byArray[i]) < 0) {
                n += 256;
            }
            this.m_Writer.write(this.hex8(n));
        }
    }

    public void newline() throws IOException {
        this.m_Writer.write("\r\n");
    }

    public void newPage() throws IOException {
        this.push();
        this.command("pard");
        this.command("page");
        this.command("par");
        this.pop();
    }

    public void close() throws IOException {
        while (this.m_Depth > 0) {
            this.pop();
        }
        this.m_Writer.flush();
    }

    public void push() throws IOException {
        this.m_Writer.write("{");
        ++this.m_Depth;
    }

    public void pop() throws IOException {
        this.m_Writer.write("}");
        --this.m_Depth;
    }

    public void text(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.ch(string.charAt(i));
        }
    }

    public void passThrough(String string) throws IOException {
        this.m_Writer.write(string);
    }

    public void ch(char c) throws IOException {
        if (c >= ' ' && c <= '~' && c != '{' && c != '}' && c != '\\') {
            this.m_Writer.write(c);
        } else if (c <= '\u00ff') {
            this.m_Writer.write("\\'" + this.hex8(c));
        } else if (c <= '\u8000') {
            this.m_Writer.write("\\uc1\\u" + c + "*");
        } else {
            this.m_Writer.write("\\uc1\\u" + (c - 65536) + "*");
        }
    }

    private String hex8(int n) {
        if (n < 0 || n >= 256) {
            throw new IllegalArgumentException("Bad hex8 digit:" + n);
        }
        char[] cArray = new char[]{this.hex4((n & 0xF0) >> 4), this.hex4(n & 0xF)};
        return new String(cArray);
    }

    private char hex4(int n) {
        if (n < 0 || n >= 16) {
            throw new IllegalArgumentException("Bad hex4 digit:" + n);
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }
}

