/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.rtf.ACI;
import com.elixirtech.rtf.ACS;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfNode;
import com.elixirtech.rtf.RtfToken;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class RtfWalker
implements RtfNode.IVisitor {
    protected ACS m_ACS = new ACS();
    protected Map<String, Object> m_Attributes;
    protected Stack<Map<String, Object>> m_AttributeStack = new Stack();
    protected Map<String, String> m_Fonts = new HashMap<String, String>();
    protected List<Color> m_Colors = new ArrayList<Color>();
    protected float m_X;
    protected float m_Y;
    protected float m_Bottom;
    protected int m_LineHeight;
    protected int m_LastLineHeight;
    private boolean m_SkipToCloseGroup;
    private int m_SkipDepth;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RtfWalker.class);

    public RtfWalker() {
        this.initAttributes();
    }

    public float getBottom() {
        return this.m_Bottom;
    }

    @Override
    public boolean pushScope(RtfGroup rtfGroup) {
        if (this.m_SkipToCloseGroup) {
            ++this.m_SkipDepth;
        }
        this.m_AttributeStack.push(this.m_Attributes);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.m_Attributes);
        this.m_Attributes = hashMap;
        return true;
    }

    @Override
    public boolean visit(RtfNode rtfNode) {
        if (this.m_SkipToCloseGroup) {
            return true;
        }
        RtfToken rtfToken = rtfNode.getToken();
        int n = rtfToken.getType();
        if (8 == n) {
            this.m_SkipToCloseGroup = true;
        } else if (2 == n) {
            String string = rtfToken.getName();
            if ("generator".equals(rtfToken.getName())) {
                this.m_SkipToCloseGroup = true;
            } else if ("listtable".equals(rtfToken.getName())) {
                this.m_SkipToCloseGroup = true;
            } else if ("listoverridetable".equals(rtfToken.getName())) {
                this.m_SkipToCloseGroup = true;
            } else if ("info".equals(rtfToken.getName())) {
                this.m_SkipToCloseGroup = true;
            } else if ("pnseclv".equals(rtfToken.getName())) {
                this.m_SkipToCloseGroup = true;
            } else if ("fonttbl".equals(rtfToken.getName())) {
                RtfGroup rtfGroup = rtfNode.getParent();
                int n2 = rtfGroup.getChildCount();
                if (n2 > 1) {
                    RtfNode rtfNode2 = rtfGroup.getChild(1);
                    if (rtfNode2 instanceof RtfGroup) {
                        for (int i = 1; i < n2; ++i) {
                            RtfNode rtfNode3 = rtfGroup.getChild(i);
                            if (!(rtfNode3 instanceof RtfGroup)) continue;
                            this.addFont((RtfGroup)rtfNode3);
                        }
                        this.m_SkipToCloseGroup = true;
                    } else {
                        for (int i = 1; i < n2; ++i) {
                            RtfToken rtfToken2 = rtfGroup.getChild(i).getToken();
                            String string2 = rtfToken2.getData();
                            if (string2 == null || !string2.endsWith(";")) continue;
                            string2 = string2.substring(0, string2.length() - 1);
                            String string3 = String.valueOf(this.m_Fonts.size());
                            this.m_Fonts.put(string3, string2);
                        }
                        this.m_SkipToCloseGroup = true;
                    }
                }
            } else if ("colortbl".equals(rtfToken.getName())) {
                this.m_Colors.clear();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                RtfGroup rtfGroup = rtfNode.getParent();
                int n6 = rtfGroup.getChildCount();
                for (int i = 1; i < n6; ++i) {
                    RtfToken rtfToken3 = rtfGroup.getChild(i).getToken();
                    if ("red".equals(rtfToken3.getName())) {
                        n3 = Integer.parseInt(rtfToken3.getData());
                        continue;
                    }
                    if ("green".equals(rtfToken3.getName())) {
                        n4 = Integer.parseInt(rtfToken3.getData());
                        continue;
                    }
                    if ("blue".equals(rtfToken3.getName())) {
                        n5 = Integer.parseInt(rtfToken3.getData());
                        continue;
                    }
                    if (!";".equals(rtfToken3.getData())) continue;
                    this.addColor(n3, n4, n5);
                }
                this.m_SkipToCloseGroup = true;
            } else if ("pard".equals(string)) {
                this.m_Attributes.put("par", Boolean.TRUE);
                this.m_Attributes.put("q", "l");
                this.m_Attributes.remove("fi");
            } else if ("par".equals(string)) {
                this.renderACS();
                this.m_Attributes.put("b", Boolean.FALSE);
            } else if ("f".equals(string)) {
                this.m_Attributes.put("f", rtfToken.getData());
            } else if ("b".equals(string)) {
                this.m_Attributes.put("b", !"0".equals(rtfToken.getData()));
            } else if ("i".equals(string)) {
                this.m_Attributes.put("i", !"0".equals(rtfToken.getData()));
            } else if ("ul".equals(string)) {
                this.m_Attributes.put("ul", !"0".equals(rtfToken.getData()));
            } else if ("ulnone".equals(string)) {
                this.m_Attributes.put("ul", Boolean.FALSE);
            } else if ("strike".equals(string)) {
                this.m_Attributes.put("strike", !"0".equals(rtfToken.getData()));
            } else if ("ql".equals(string)) {
                this.m_Attributes.put("q", "l");
            } else if ("qc".equals(string)) {
                this.m_Attributes.put("q", "c");
            } else if ("qr".equals(string)) {
                this.m_Attributes.put("q", "r");
            } else if ("qj".equals(string)) {
                this.m_Attributes.put("q", "j");
            } else if ("qd".equals(string)) {
                this.m_Attributes.put("q", "d");
            } else if ("sl".equals(string)) {
                this.m_Attributes.put("sl", rtfToken.getData());
            } else if ("fi".equals(string)) {
                this.m_Attributes.put("fi", rtfToken.getData());
            } else if ("tab".equals(string)) {
                this.m_ACS.add("\t", this.convertMap());
            } else if ("pn".equals(string)) {
                this.m_SkipToCloseGroup = true;
            } else if ("stylesheet".equals(string)) {
                this.m_SkipToCloseGroup = true;
            } else if ("super".equals(string)) {
                this.m_Attributes.put("base", "super");
            } else if ("sub".equals(string)) {
                this.m_Attributes.put("base", "sub");
            } else if (!"deflang".equals(string) && !"lang".equals(string)) {
                if (rtfToken.getData() != null) {
                    this.m_Attributes.put(string, rtfToken.getData());
                } else {
                    m_Log.warn((Object)("Don't know how to handle: " + rtfToken.getName()));
                }
            }
        } else if (7 == n && Boolean.TRUE == this.m_Attributes.get("par")) {
            String string = rtfToken.getData();
            this.m_ACS.add(string, this.convertMap());
        }
        return true;
    }

    @Override
    public boolean popScope(RtfGroup rtfGroup) {
        this.m_Attributes = this.m_AttributeStack.pop();
        if (this.m_SkipDepth == 0) {
            this.m_SkipToCloseGroup = false;
        } else {
            --this.m_SkipDepth;
        }
        return true;
    }

    protected void initAttributes() {
        this.m_Attributes = new HashMap<String, Object>();
        this.m_Attributes.put("par", Boolean.TRUE);
        this.m_Attributes.put("b", Boolean.FALSE);
        this.m_Attributes.put("i", Boolean.FALSE);
        this.m_Attributes.put("strike", Boolean.FALSE);
        this.m_Attributes.put("fs", "24");
        this.m_Attributes.put("f", "0");
        this.m_Attributes.put("q", "l");
        this.m_Attributes.put("base", "normal");
        this.addColor(0, 0, 0);
    }

    protected abstract void renderACS();

    protected void addFont(RtfGroup rtfGroup) {
        RtfToken rtfToken;
        Object object;
        int n = rtfGroup.getChildCount();
        String string = String.valueOf(this.m_Fonts.size());
        for (int i = 0; i < n; ++i) {
            object = rtfGroup.getChild(i).getToken();
            if (!"f".equals(((RtfToken)object).getName())) continue;
            string = ((RtfToken)object).getData();
            break;
        }
        if (((String)(object = (rtfToken = rtfGroup.getChild(n - 1).getToken()).getData())).endsWith(";")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        this.m_Fonts.put(string, (String)object);
    }

    protected void addColor(int n, int n2, int n3) {
        this.m_Colors.add(new Color(n, n2, n3));
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> convertMap() {
        String string;
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        String string2 = "0";
        try {
            string2 = (String)this.m_Attributes.get("f");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = this.m_Fonts.get(string2);
        if (string3 == null) {
            string3 = "Serif";
        }
        int n = Integer.parseInt((String)this.m_Attributes.get("fs"));
        int n2 = 0;
        if (Boolean.TRUE.equals(this.m_Attributes.get("b"))) {
            n2 |= 1;
        }
        if (Boolean.TRUE.equals(this.m_Attributes.get("i"))) {
            n2 |= 2;
        }
        Font font = new Font(string3, n2, n / 2).deriveFont((float)n / 2.0f);
        boolean bl = Boolean.TRUE.equals(this.m_Attributes.get("ul"));
        boolean bl2 = Boolean.TRUE.equals(this.m_Attributes.get("strike"));
        hashMap.put(TextAttribute.FONT, font);
        if (bl) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (bl2) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if ("sub".equals(string = (String)this.m_Attributes.get("base"))) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        } else if ("super".equals(string)) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        int n3 = 0;
        string3 = (String)this.m_Attributes.get("cf");
        if (string3 != null) {
            n3 = Integer.parseInt((String)this.m_Attributes.get("cf"));
        }
        Color color = this.m_Colors.get(n3);
        hashMap.put(TextAttribute.FOREGROUND, color);
        String string4 = (String)this.m_Attributes.get("q");
        if (string4.equals("l")) {
            hashMap.put(ACI.ALIGNMENT, "Left");
        } else if (string4.equals("c")) {
            hashMap.put(ACI.ALIGNMENT, "Center");
        } else if (string4.equals("r")) {
            hashMap.put(ACI.ALIGNMENT, "Right");
        } else if (string4.equals("j") || string4.equals("d")) {
            hashMap.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        string4 = (String)this.m_Attributes.get("sl");
        try {
            int n4 = Integer.parseInt(string4);
            hashMap.put(ACI.LINE_SPACING, n4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string4 = (String)this.m_Attributes.get("fi");
        try {
            int n5 = Integer.parseInt(string4);
            hashMap.put(ACI.FIRST_LINE_INDENT, n5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return hashMap;
    }
}

