/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.sax.IBaseSAXOut;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.ISAXOut;
import com.elixirtech.sax.util.EntityResolver;
import com.elixirtech.sax.util.LocalEntityResolver;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSAXOut
implements ISAXOut {
    private static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    private final ContentHandler m_ContentHandler;
    private final Namespace m_Namespace;
    private final String m_URI;
    private final String m_Prefix;
    private final String m_Indent = "  ";
    private final boolean m_IsIndenting;
    private final LocalEntityResolver m_EntityResolver;
    private int m_Depth;
    private boolean m_Preserve;
    private int m_PreserveDepth;
    private static final String NL = System.getProperty("line.separator");

    public AbstractSAXOut(ContentHandler contentHandler, Object object, boolean bl, Namespace namespace) {
        this.m_IsIndenting = bl;
        this.m_Namespace = namespace;
        if (this.m_Namespace != null) {
            this.m_URI = this.m_Namespace.getURI();
            this.m_Prefix = this.m_Namespace.getPrefix() + ":";
        } else {
            this.m_URI = "";
            this.m_Prefix = "";
        }
        this.m_EntityResolver = new LocalEntityResolver();
        this.m_ContentHandler = contentHandler;
        try {
            this.m_ContentHandler.startDocument();
            if (this.m_Namespace != null) {
                this.startPrefixMapping(this.m_Namespace);
            }
            this.output(object);
            if (this.m_Namespace != null) {
                this.endPrefixMapping(this.m_Namespace);
            }
            this.m_ContentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            this.processError("Main", sAXException);
        }
    }

    public void startPrefixMapping(Namespace namespace) throws SAXException {
        this.m_ContentHandler.startPrefixMapping(namespace.getPrefix(), namespace.getURI());
    }

    public void endPrefixMapping(Namespace namespace) throws SAXException {
        this.m_ContentHandler.endPrefixMapping(namespace.getPrefix());
    }

    @Override
    public void startElement(String string, Attributes attributes) {
        try {
            String string2 = attributes.getValue(XML_URI, "space");
            if (string2 != null && string2.equals("preserve")) {
                this.m_Preserve = true;
            }
            if (this.m_IsIndenting) {
                this.start();
            }
            this.m_ContentHandler.startElement(this.m_URI, string, this.m_Prefix + string, attributes);
        }
        catch (SAXException sAXException) {
            this.processError("startElement(" + string + ")", sAXException);
        }
    }

    @Override
    public void characters(String string) {
        try {
            this.m_ContentHandler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            this.processError("characters", sAXException);
        }
    }

    @Override
    public void endElement(String string) {
        try {
            if (this.m_IsIndenting) {
                this.end();
            }
            this.m_ContentHandler.endElement(this.m_URI, string, this.m_Prefix + string);
        }
        catch (SAXException sAXException) {
            this.processError("endElement(" + string + ")", sAXException);
        }
    }

    @Override
    public void output(Object object) {
        if (object != null) {
            if (object instanceof IBean) {
                IBean iBean = (IBean)object;
                IBeanSAXOut iBeanSAXOut = this.lookupBeanOutputter(iBean);
                if (iBeanSAXOut != null) {
                    iBeanSAXOut.output(this, iBean);
                }
            } else {
                IBaseSAXOut iBaseSAXOut = this.lookupBaseOutputter(object);
                if (iBaseSAXOut != null) {
                    iBaseSAXOut.output(this, object);
                }
            }
        }
    }

    @Override
    public void output(Object object, String string) {
        if (object != null) {
            if (object instanceof IBean) {
                IBean iBean = (IBean)object;
                IBeanSAXOut iBeanSAXOut = this.lookupBeanOutputter(iBean);
                if (iBeanSAXOut != null) {
                    iBeanSAXOut.output(this, iBean, string);
                }
            } else {
                IBaseSAXOut iBaseSAXOut = this.lookupBaseOutputter(object);
                if (iBaseSAXOut != null) {
                    iBaseSAXOut.output(this, object, string);
                }
            }
        }
    }

    @Override
    public void output(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            this.output(iterator.next());
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.m_EntityResolver;
    }

    @Override
    public void setObject(String string, Object object) {
        this.m_EntityResolver.setObject(string, object);
    }

    @Override
    public String getKey(String string) {
        return this.m_EntityResolver.getKey(string);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.m_ContentHandler;
    }

    @Override
    public abstract ElxLoggerJ getLog();

    protected abstract IBeanSAXOut lookupBeanOutputter(IBean var1);

    protected abstract IBaseSAXOut lookupBaseOutputter(Object var1);

    private void start() throws SAXException {
        if (this.m_Preserve) {
            ++this.m_PreserveDepth;
        } else {
            if (this.m_Depth > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(NL);
                for (int i = 0; i < this.m_Depth; ++i) {
                    stringBuffer.append("  ");
                }
                String string = stringBuffer.toString();
                this.m_ContentHandler.ignorableWhitespace(string.toCharArray(), 0, string.length());
            }
            ++this.m_Depth;
        }
    }

    private void end() throws SAXException {
        if (this.m_Preserve) {
            --this.m_PreserveDepth;
            if (this.m_PreserveDepth == 0) {
                this.m_Preserve = false;
            }
        } else {
            --this.m_Depth;
            if (this.m_Depth > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(NL);
                for (int i = 0; i < this.m_Depth; ++i) {
                    stringBuffer.append("  ");
                }
                String string = stringBuffer.toString();
                this.m_ContentHandler.ignorableWhitespace(string.toCharArray(), 0, string.length());
            }
        }
    }

    private void processError(String string, Throwable throwable) {
        this.getLog().error((Object)(string + " " + throwable.toString()));
    }
}

