/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.scm.Procedure;
import com.elixirtech.scm.Scheme;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaMethod
extends Procedure {
    Class[] argClasses;
    Method method;
    boolean isStatic;

    public JavaMethod(String string, Object object, Object object2) {
        this.name = object + "." + string;
        try {
            this.argClasses = this.classArray(object2);
            this.method = JavaMethod.toClass(object).getMethod(string, this.argClasses);
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
        }
        catch (ClassNotFoundException classNotFoundException) {
            JavaMethod.error("Bad class, can't get method " + this.name);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            JavaMethod.error("Can't get method " + this.name);
        }
    }

    @Override
    public void applyJS(Scheme scheme, Object object, StringBuffer stringBuffer) {
    }

    @Override
    public Object apply(Scheme scheme, Object object) {
        String string = null;
        Object[] objectArray = null;
        objectArray = this.isStatic ? this.toArray(object) : this.toArray(JavaMethod.rest(object));
        try {
            Object object2 = this.isStatic ? this.method.invoke(null, objectArray) : this.method.invoke(JavaMethod.first(object), objectArray);
            if (object2 instanceof String) {
                object2 = ((String)object2).toCharArray();
            }
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            string = "IllegalAccessException";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Illegal Argument Exception");
            if (this.isStatic) {
                System.out.println("$" + this.name);
            } else {
                System.out.println(JavaMethod.first(object).getClass().getName() + "." + this.name);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                System.out.println("\t" + i + ") " + objectArray[i].toString() + " (" + objectArray[i].getClass().getName() + ")");
            }
            string = illegalArgumentException.toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            string = "InvocationTargetException";
        }
        catch (NullPointerException nullPointerException) {
            string = "NullPointerException";
        }
        return JavaMethod.error(string + ": " + this + JavaMethod.stringify(object) + ", ");
    }

    public static Class toClass(Object object) throws ClassNotFoundException {
        if (object instanceof Class) {
            return (Class)object;
        }
        if ((object = JavaMethod.stringify(object, false)).equals("void")) {
            return Void.TYPE;
        }
        if (object.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (object.equals("char")) {
            return Character.TYPE;
        }
        if (object.equals("byte")) {
            return Byte.TYPE;
        }
        if (object.equals("short")) {
            return Short.TYPE;
        }
        if (object.equals("int")) {
            return Integer.TYPE;
        }
        if (object.equals("long")) {
            return Long.TYPE;
        }
        if (object.equals("float")) {
            return Float.TYPE;
        }
        if (object.equals("double")) {
            return Double.TYPE;
        }
        return Class.forName((String)object);
    }

    public Object[] toArray(Object object) {
        int n = JavaMethod.length(object);
        int n2 = n - this.argClasses.length;
        if (n2 != 0) {
            JavaMethod.error(Math.abs(n2) + " too " + (n2 > 0 ? "many" : "few") + " args to " + this.name);
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n && i < this.argClasses.length; ++i) {
            Object object2;
            objectArray[i] = this.argClasses[i] == Integer.TYPE ? new Integer((int)JavaMethod.num(JavaMethod.first(object))) : (this.argClasses[i] == String.class ? ((object2 = JavaMethod.first(object)) instanceof String ? object2 : (object2 instanceof char[] ? new String((char[])object2) : (object2 == null ? "" : object2.toString()))) : JavaMethod.first(object));
            object = JavaMethod.rest(object);
        }
        return objectArray;
    }

    public Class[] classArray(Object object) throws ClassNotFoundException {
        int n = JavaMethod.length(object);
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = JavaMethod.toClass(JavaMethod.first(object));
            object = JavaMethod.rest(object);
        }
        return classArray;
    }
}

