/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.scm.Closure;
import com.elixirtech.scm.Environment;
import com.elixirtech.scm.InputPort;
import com.elixirtech.scm.Macro;
import com.elixirtech.scm.Pair;
import com.elixirtech.scm.Primitive;
import com.elixirtech.scm.Procedure;
import com.elixirtech.scm.SchemeUtils;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class Scheme
extends SchemeUtils {
    private Environment rootEnvironment = new Environment();
    Environment globalEnvironment;
    InputPort input;
    PrintWriter output;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Scheme.class);

    public static void main(String[] stringArray) {
        System.out.println(Scheme.convert("='\"Sample\""));
    }

    public static String convert(String string) {
        if (string.startsWith("=")) {
            try {
                String string2 = Scheme.removeSquareBrackets(string.substring(1));
                InputPort inputPort = new InputPort(new StringReader(string2));
                Object object = inputPort.read();
                Scheme scheme = new Scheme();
                StringBuffer stringBuffer = new StringBuffer();
                scheme.evalJS(object, stringBuffer);
                return "=" + stringBuffer.toString();
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Can't convert scheme: " + string));
            }
        }
        return string;
    }

    private static String removeSquareBrackets(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(91);
        while (n >= 0) {
            stringBuffer.append(string.substring(0, n));
            string = string.substring(n + 1);
            int n2 = string.indexOf(93);
            String string2 = string.substring(0, n2);
            stringBuffer.append("(elxsqbr \"");
            stringBuffer.append(string2);
            stringBuffer.append("\")");
            string = string.substring(n2 + 1);
            n = string.indexOf(91);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public Scheme() {
        Primitive.installPrimitives(this.rootEnvironment);
        this.loadRoot(new InputPort(new StringReader("(define call/cc    call-with-current-continuation)\n(define first \t   car)\n(define second     cadr)\n(define third      caddr)\n(define rest \t   cdr)\n(define set-first! set-car!)\n(define set-rest!  set-cdr!)\n(define or\n(macro args\n(if (null? args)\n#f\n(cons 'cond (map list args)))))\n(define and\n(macro args\n(cond ((null? args) #t)\n((null? (rest args)) (first args))\n(else (list 'if (first args) (cons 'and (rest args)) #f)))))\n(define quasiquote\n(macro (x)\n(define (constant? exp)\n(if (pair? exp) (eq? (car exp) 'quote) (not (symbol? exp))))\n(define (combine-skeletons left right exp)\n(cond\n((and (constant? left) (constant? right))\n(if (and (eqv? (eval left) (car exp))\n(eqv? (eval right) (cdr exp)))\n(list 'quote exp)\n(list 'quote (cons (eval left) (eval right)))))\n((null? right) (list 'list left))\n((and (pair? right) (eq? (car right) 'list))\n(cons 'list (cons left (cdr right))))\n(else (list 'cons left right))))\n(define (expand-quasiquote exp nesting)\n(cond\n((vector? exp)\n(list 'apply 'vector (expand-quasiquote (vector->list exp) nesting)))\n((not (pair? exp))\n(if (constant? exp) exp (list 'quote exp)))\n((and (eq? (car exp) 'unquote) (= (length exp) 2))\n(if (= nesting 0)\n(second exp)\n(combine-skeletons ''unquote\n(expand-quasiquote (cdr exp) (- nesting 1))\nexp)))\n((and (eq? (car exp) 'quasiquote) (= (length exp) 2))\n(combine-skeletons ''quasiquote\n(expand-quasiquote (cdr exp) (+ nesting 1))\nexp))\n((and (pair? (car exp))\n(eq? (caar exp) 'unquote-splicing)\n(= (length (car exp)) 2))\n(if (= nesting 0)\n(list 'append (second (first exp))\n(expand-quasiquote (cdr exp) nesting))\n(combine-skeletons (expand-quasiquote (car exp) (- nesting 1))\n(expand-quasiquote (cdr exp) nesting)\nexp)))\n(else (combine-skeletons (expand-quasiquote (car exp) nesting)\n(expand-quasiquote (cdr exp) nesting)\nexp))))\n(expand-quasiquote x 0)))\n\n(define let\n(macro (bindings . body)\n(define (named-let name bindings body)\n`(let ((,name #f))\n(set! ,name (lambda ,(map first bindings) . ,body))\n(,name . ,(map second bindings))))\n(if (symbol? bindings)\n(named-let bindings (first body) (rest body))\n`((lambda ,(map first bindings) . ,body) . ,(map second bindings)))))\n(define let*\n(macro (bindings . body)\n(if (null? bindings) `((lambda () . ,body))\n`(let (,(first bindings))\n(let* ,(rest bindings) . ,body)))))\n(define letrec\n(macro (bindings . body)\n(let ((vars (map first bindings))\n(vals (map second bindings)))\n`(let ,(map (lambda (var) `(,var #f)) vars)\n,@(map (lambda (var val) `(set! ,var ,val)) vars vals)\n. ,body))))\n(define case\n(macro (exp . cases)\n(define (do-case case)\n(cond ((not (pair? case)) (error \"bad syntax in case\" case))\n((eq? (first case) 'else) case)\n(else `((member __exp__ ',(first case)) . ,(rest case)))))\n`(let ((__exp__ ,exp)) (cond . ,(map do-case cases)))))\n(define do\n(macro (bindings test-and-result . body)\n(let ((variables (map first bindings))\n(inits (map second bindings))\n(steps (map (lambda (clause)\n(if (null? (cddr clause))\n(first clause)\n(third clause)))\nbindings))\n(test (first test-and-result))\n(result (rest test-and-result)))\n`(letrec ((__loop__\n(lambda ,variables\n(if ,test\n(begin . ,result)\n(begin\n,@body\n(__loop__ . ,steps))))))\n(__loop__ . ,inits)))))\n(define delay\n(macro (exp)\n(define (make-promise proc)\n(let ((result-ready? #f)\n(result #f))\n(lambda ()\n(if result-ready?\nresult\n(let ((x (proc)))\n(if result-ready?\nresult\n(begin (set! result-ready? #t)\n(set! result x)\nresult)))))))\n`(,make-promise (lambda () ,exp))))\n(define time\n(macro (exp . rest) `(time-call (lambda () ,exp) . ,rest)))\n")));
        this.globalEnvironment = new Environment(new Object[0], new Object[0], this.rootEnvironment);
    }

    public String evaluate(String string) {
        this.input = new InputPort(new StringReader(string));
        StringWriter stringWriter = new StringWriter();
        this.output = new PrintWriter((Writer)stringWriter, true);
        try {
            Object object = this.input.read();
            Scheme.write(this.eval(object), this.output, true);
            this.output.println();
        }
        catch (RuntimeException runtimeException) {
            this.output.println("<Logged Error>");
            m_Log.error((Object)("Error evaluating \"" + string + "\": " + runtimeException));
            runtimeException.printStackTrace();
        }
        this.output.flush();
        return stringWriter.toString();
    }

    public Object load(InputPort inputPort) {
        Object object = null;
        while (!InputPort.isEOF(object = inputPort.read())) {
            try {
                this.eval(object);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                continue;
            }
            break;
        }
        return TRUE;
    }

    private Object loadRoot(InputPort inputPort) {
        Object object = null;
        while (!InputPort.isEOF(object = inputPort.read())) {
            try {
                this.eval(object, this.rootEnvironment);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                continue;
            }
            break;
        }
        return TRUE;
    }

    public void evalJS(Object object, StringBuffer stringBuffer) {
        if (object instanceof String) {
            stringBuffer.append(object);
        } else if (object instanceof char[]) {
            stringBuffer.append('\"');
            stringBuffer.append(new String((char[])object));
            stringBuffer.append('\"');
        } else if (!(object instanceof Pair)) {
            stringBuffer.append(object);
        } else {
            Object object2 = Scheme.first(object);
            Object object3 = Scheme.rest(object);
            if (object2 == "quote") {
                this.evalJS(Scheme.first(object3), stringBuffer);
            } else if (object2 == "begin") {
                stringBuffer.append('{');
                while (Scheme.rest(object3) != null) {
                    this.evalJS(Scheme.first(object3), stringBuffer);
                    object3 = Scheme.rest(object3);
                }
                stringBuffer.append('}');
                object = Scheme.first(object3);
            } else if (object2 == "define") {
                if (Scheme.first(object3) instanceof Pair) {
                    stringBuffer.append("var ");
                    stringBuffer.append(Scheme.first(Scheme.first(object3)));
                    stringBuffer.append("=");
                    this.evalJS(Scheme.cons("lambda", Scheme.cons(Scheme.rest(Scheme.first(object3)), Scheme.rest(object3))), stringBuffer);
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append("var ");
                    stringBuffer.append(Scheme.first(object3));
                    stringBuffer.append("=");
                    this.evalJS(Scheme.second(object3), stringBuffer);
                    stringBuffer.append(";");
                }
            } else if (object2 == "set!") {
                stringBuffer.append(Scheme.first(object3));
                stringBuffer.append("=");
                this.evalJS(Scheme.second(object3), stringBuffer);
                stringBuffer.append(";");
            } else if (object2 == "if") {
                stringBuffer.append("(");
                this.evalJS(Scheme.first(object3), stringBuffer);
                stringBuffer.append(")");
                stringBuffer.append(" ? (");
                this.evalJS(Scheme.second(object3), stringBuffer);
                stringBuffer.append(") : (");
                this.evalJS(Scheme.third(object3), stringBuffer);
                stringBuffer.append(")");
            } else if (object2 == "cond") {
                this.processCond(object3, stringBuffer);
            } else {
                if (object2 == "lambda") {
                    throw new RuntimeException("lambda not implemented");
                }
                if (object2 == "macro") {
                    throw new RuntimeException("macro not implemented");
                }
                if (object2 instanceof String) {
                    object2 = this.globalEnvironment.lookup((String)object2);
                }
                Procedure.proc(object2).applyJS(this, object3, stringBuffer);
            }
        }
    }

    public void processCond(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("null");
        } else {
            Object object2 = Scheme.first(object);
            object = Scheme.rest(object);
            stringBuffer.append("((");
            this.evalJS(Scheme.first(object2), stringBuffer);
            stringBuffer.append(") ? (");
            this.evalJS(Scheme.first(Scheme.rest(object2)), stringBuffer);
            stringBuffer.append(")");
            stringBuffer.append(" : ");
            this.processCond(object, stringBuffer);
            stringBuffer.append(")");
        }
    }

    public Object eval(Object object, Environment environment) {
        Object object2;
        Object object3;
        while (true) {
            if (object instanceof String) {
                return environment.lookup((String)object);
            }
            if (!(object instanceof Pair)) {
                return object;
            }
            object3 = Scheme.first(object);
            object2 = Scheme.rest(object);
            if (object3 == "quote") {
                return Scheme.first(object2);
            }
            if (object3 == "begin") {
                while (Scheme.rest(object2) != null) {
                    this.eval(Scheme.first(object2), environment);
                    object2 = Scheme.rest(object2);
                }
                object = Scheme.first(object2);
                continue;
            }
            if (object3 == "define") {
                if (Scheme.first(object2) instanceof Pair) {
                    return environment.define(Scheme.first(Scheme.first(object2)), this.eval(Scheme.cons("lambda", Scheme.cons(Scheme.rest(Scheme.first(object2)), Scheme.rest(object2))), environment));
                }
                return environment.define(Scheme.first(object2), this.eval(Scheme.second(object2), environment));
            }
            if (object3 == "set!") {
                return environment.set(Scheme.first(object2), this.eval(Scheme.second(object2), environment));
            }
            if (object3 == "if") {
                object = Scheme.truth(this.eval(Scheme.first(object2), environment)) ? Scheme.second(object2) : Scheme.third(object2);
                continue;
            }
            if (object3 == "cond") {
                object = this.reduceCond(object2, environment);
                continue;
            }
            if (object3 == "lambda") {
                return new Closure(Scheme.first(object2), Scheme.rest(object2), environment);
            }
            if (object3 == "macro") {
                return new Macro(Scheme.first(object2), Scheme.rest(object2), environment);
            }
            if ((object3 = this.eval(object3, environment)) instanceof Macro) {
                object = ((Macro)object3).expand(this, (Pair)object, object2);
                continue;
            }
            if (!(object3 instanceof Closure)) break;
            Closure closure = (Closure)object3;
            object = closure.body;
            environment = new Environment(closure.parms, this.evalList(object2, environment), closure.env);
        }
        return Procedure.proc(object3).apply(this, this.evalList(object2, environment));
    }

    public Object eval(Object object) {
        return this.eval(object, this.globalEnvironment);
    }

    Pair evalList(Object object, Environment environment) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Pair)) {
            Scheme.error("Illegal arg list: " + object);
            return null;
        }
        return Scheme.cons(this.eval(Scheme.first(object), environment), this.evalList(Scheme.rest(object), environment));
    }

    Object reduceCond(Object object, Environment environment) {
        Object object2;
        Object object3 = null;
        do {
            if (object == null) {
                return FALSE;
            }
            object2 = Scheme.first(object);
            object = Scheme.rest(object);
        } while (Scheme.first(object2) != "else" && !Scheme.truth(object3 = this.eval(Scheme.first(object2), environment)));
        if (Scheme.rest(object2) == null) {
            return Scheme.list("quote", object3);
        }
        if (Scheme.second(object2) == "=>") {
            return Scheme.list(Scheme.third(object2), Scheme.list("quote", object3));
        }
        return Scheme.cons("begin", Scheme.rest(object2));
    }
}

