/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.tree.CellStructure;
import com.elixirtech.tree.FlatTreeLayoutManager;
import com.elixirtech.tree.HierarchicalTreeLayoutManager;
import com.elixirtech.tree.TreeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class TreeLayoutManager
implements LayoutManager2 {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private boolean m_Dirty = true;
    protected int[] m_FixedWidths;
    protected int[] m_FixedHeights;
    protected int m_MinWidth;
    protected int m_MinHeight;
    protected CellStructure m_CellStructure;
    private final Map<JComponent, Dimension> m_SizeCache = new HashMap<JComponent, Dimension>();

    public static TreeLayoutManager newInstance(TreeModel treeModel, int n, boolean bl, boolean bl2) {
        if (bl) {
            return new HierarchicalTreeLayoutManager(treeModel, n, bl2);
        }
        return new FlatTreeLayoutManager(treeModel, n, bl2);
    }

    protected TreeLayoutManager() {
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.isDirty()) {
            container.removeAll();
            this.buildCellStructure(container);
            this.layoutCellStructure();
            this.setDirty(false);
        }
    }

    public CellStructure buildCellStructure() {
        this.buildCellStructure(null);
        this.layoutCellStructure();
        return this.m_CellStructure;
    }

    protected abstract void buildCellStructure(Container var1);

    protected void setupFixedWidths(Dimension dimension) {
        if (this.m_FixedWidths == null || this.m_FixedWidths.length != dimension.width) {
            this.m_FixedWidths = new int[dimension.width];
        }
        if (this.m_FixedHeights == null || this.m_FixedHeights.length != dimension.height) {
            this.m_FixedHeights = new int[dimension.height];
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.layoutContainer(container);
        return this.m_CellStructure.getSize();
    }

    public int getColumnCount() {
        return this.m_CellStructure.getColumnCount();
    }

    public int getColumnWidth(int n) {
        return this.m_CellStructure.getColumnWidth(n);
    }

    public int getRowCount() {
        return this.m_CellStructure.getRowCount();
    }

    public boolean isDirty() {
        return this.m_Dirty;
    }

    public void setDirty(boolean bl) {
        this.m_Dirty = bl;
    }

    public void setMinimumWidth(int n) {
        this.m_MinWidth = n;
        this.setDirty(true);
    }

    public void setMinimumHeight(int n) {
        this.m_MinHeight = n;
        this.setDirty(true);
    }

    public void forceWidth(int n, int n2) {
        this.m_FixedWidths[n] = n2;
        this.setDirty(true);
    }

    public void forceHeight(int n, int n2) {
        this.m_FixedHeights[n] = n2;
        this.setDirty(true);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    protected Dimension getSize(JComponent jComponent) {
        Dimension dimension = this.m_SizeCache.get(jComponent);
        if (dimension == null) {
            dimension = jComponent.getPreferredSize();
            this.m_SizeCache.put(jComponent, dimension);
        }
        return dimension;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.m_SizeCache.clear();
        this.setDirty(true);
    }

    protected void layoutCellStructure() {
        this.m_CellStructure.determineSizes();
        this.m_CellStructure.applySizes();
    }

    protected static void swapAxes(Dimension dimension) {
        int n = dimension.width;
        dimension.width = dimension.height;
        dimension.height = n;
    }
}

