/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;

public class Icons {
    private static final Plus PLUS = new Plus();
    private static final Minus MINUS = new Minus();
    private static final Null NULL = new Null();
    static Map<Color, Icon> m_ColourIcons = new HashMap<Color, Icon>();

    public static Icon getPlus() {
        return PLUS;
    }

    public static Icon getMinus() {
        return MINUS;
    }

    public static Icon getNull() {
        return NULL;
    }

    public static Icon getColourIcon(Color color) {
        Icon icon = m_ColourIcons.get(color);
        if (icon == null) {
            icon = new ColourIcon(color);
        }
        return icon;
    }

    public static Icon getIndentIcon(int n) {
        return new IndentIcon(n);
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    private static class Plus
    implements Icon {
        private Plus() {
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n + 2, n2, n + 2, n2 + 4);
            graphics.drawLine(n, n2 + 2, n + 4, n2 + 2);
        }
    }

    private static class Minus
    implements Icon {
        private Minus() {
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2 + 2, n + 4, n2 + 2);
        }
    }

    private static class Null
    implements Icon {
        private Null() {
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class ColourIcon
    implements Icon {
        private Color m_Colour;

        public ColourIcon(Color color) {
            this.m_Colour = color;
            m_ColourIcons.put(color, this);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.m_Colour);
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 8, 8);
        }
    }

    private static class IndentIcon
    implements Icon {
        private int m_Width;

        public IndentIcon(int n) {
            this.m_Width = n;
        }

        @Override
        public int getIconWidth() {
            return this.m_Width;
        }

        @Override
        public int getIconHeight() {
            return 1;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

