/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import com.elixirtech.arch.ElxLoggerJ;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class CodeBlock
implements ActionListener,
ItemListener,
ListSelectionListener,
PropertyChangeListener,
ChangeListener,
DocumentListener,
TreeSelectionListener,
Runnable,
TableModelListener {
    private final Object m_Receiver;
    private Method m_Method;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CodeBlock.class);

    public CodeBlock(Object object, Method method) {
        this.m_Receiver = object;
        this.m_Method = method;
    }

    public CodeBlock(Object object, String string) {
        this.m_Receiver = object;
        try {
            this.m_Method = this.m_Receiver.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            m_Log.error((Object)("Method not found (obfuscation error?): " + this.m_Receiver.getClass().getName() + ":" + string), (Throwable)noSuchMethodException);
        }
    }

    @Override
    public void run() {
        if (this.m_Method == null) {
            return;
        }
        Object[] objectArray = new Object[]{};
        try {
            this.m_Method.setAccessible(true);
            this.m_Method.invoke(this.m_Receiver, objectArray);
        }
        catch (Throwable throwable) {
            String string = this.m_Receiver.getClass().getName();
            String string2 = this.m_Method.getName();
            m_Log.error((Object)("Error while invoking " + string + "." + string2 + ": " + throwable), throwable);
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                m_Log.error((Object)("Previous error caused by: " + throwable2), throwable2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.run();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.run();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.run();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.run();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.run();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.run();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.run();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.run();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.run();
    }
}

