/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.collections;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakList<T>
extends AbstractList<T> {
    private ArrayList<WeakReference<T>> refs = new ArrayList();

    private T deref(WeakReference<T> weakReference) {
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    @Override
    public T get(int n) {
        return this.deref(this.refs.get(n));
    }

    @Override
    public int size() {
        return this.refs.size();
    }

    @Override
    public T set(int n, T t) {
        return this.deref(this.refs.set(n, new WeakReference<T>(t)));
    }

    @Override
    public void add(int n, T t) {
        this.refs.add(n, new WeakReference<T>(t));
    }

    @Override
    public T remove(int n) {
        return this.deref(this.refs.remove(n));
    }

    public List<Object> hardList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            T t = this.get(i);
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public void trimToSize() {
        int n = this.size();
        while (n-- > 0) {
            if (this.get(n) != null) continue;
            this.remove(n);
        }
    }
}

