/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.EncodeT;

class RSSUtil {
    private static final int NUM_MODE = 1;
    private static final int ALNU_MODE = 2;
    private static final int ISO_MODE = 3;
    private static final int ALPH_MODE = 4;
    private static final int FINI_MODE = 5;
    public static char FNC1 = (char)35;
    public static int SYM_SEP = 94;
    public static int MAX_CCA2_SIZE = 6;
    public static int MAX_CCA3_SIZE = 4;
    public static int MAX_CCA4_SIZE = 4;
    public static int[] CC2Sizes = new int[]{59, 78, 88, 108, 118, 138, 167, 208, 256, 296, 336, 0};
    public static int[] CC3Sizes = new int[]{78, 98, 118, 138, 167, 208, 304, 416, 536, 648, 768, 0};
    public static int[] CC4Sizes = new int[]{78, 108, 138, 167, 197, 208, 264, 352, 496, 672, 840, 1016, 1184, 0};
    private static int IS_NUM = 1;
    private static int IS_FNC1 = 2;
    private static int IS_ALNU = 4;
    private static int IS_ISO = 8;
    private static int IS_FINI = 128;
    private static int AIx = 0;
    private static int AIdummy = 1;
    private static int AI21 = 2;
    private static int AI8004 = 3;
    private static int MAX_CW = 176;
    private static int MAX_BYTES = 148;
    private static int MAX_CCC_CW = 863;
    private static int MAX_CCC_ROWS = 90;
    private static int MAX_CCC_BYTES = 1033;
    public int[] CCSizes;
    public int rowWidth = 0;
    public int eccCnt = 0;
    public int colCnt = 0;
    public int rowCnt = 0;
    private int getUnusedBitCntResult = 0;
    private int[] iswhat = new int[]{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 15, 0, 8, 8, 8, 8, 8, 12, 8, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 8, 8, 8, 8, 8, 8, 0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 12, 8, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    RSSUtil() {
    }

    public int pack(String string, byte[] byArray, int n) {
        EncodeT encodeT = new EncodeT();
        encodeT.str = string.getBytes();
        encodeT.bitField = byArray;
        encodeT.iBit = 0;
        encodeT.iStr = 0;
        if (n == 1) {
            ++encodeT.iBit;
            encodeT.mode = this.doLinMethods(encodeT, n);
        } else {
            encodeT.mode = this.doMethods(encodeT, n);
        }
        block5: while (encodeT.mode != 5) {
            switch (encodeT.mode) {
                case 1: {
                    encodeT.mode = this.encodeNumeric(encodeT, n);
                    continue block5;
                }
                case 2: {
                    encodeT.mode = this.encodeAlphanumeric(encodeT, n);
                    continue block5;
                }
                case 3: {
                    encodeT.mode = this.encodeISO(encodeT, n);
                    continue block5;
                }
            }
            System.err.println("\nmode error");
            return -1;
        }
        if (n == -1) {
            if (this.insertPad(encodeT, n) == 0) {
                System.err.println("symbol too big\n");
                return -1;
            }
            return encodeT.iBit / 8;
        }
        return this.insertPad(encodeT, n);
    }

    public int check2DData(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.iswhat[string.charAt(i)] != 0) continue;
            return i;
        }
        return 0;
    }

    public int encodeNumeric(EncodeT encodeT, int n) {
        int n2;
        int n3 = 0;
        if (encodeT.iStr == encodeT.str.length) {
            this.getUnusedBitCntResult = n3;
            int n4 = this.getUnusedBitCnt(encodeT.iBit, n3, n);
            n3 = this.getUnusedBitCntResult;
            if (n4 > 4) {
                n4 = 4;
            }
            if (n4 > 0) {
                this.putBits(encodeT.bitField, encodeT.iBit, n4, 0, n);
                encodeT.iBit += n4;
            }
            return 5;
        }
        int n5 = encodeT.str[encodeT.iStr];
        int n6 = this.iswhat[n5];
        if ((n6 & IS_NUM) == 0) {
            this.putBits(encodeT.bitField, encodeT.iBit, 4, 0, n);
            encodeT.iBit += 4;
            return 2;
        }
        int n7 = 0;
        if (encodeT.iStr >= encodeT.str.length - 1) {
            n2 = IS_FINI;
        } else {
            n7 = encodeT.str[encodeT.iStr + 1];
            n2 = this.iswhat[n7];
        }
        if (n2 == IS_FINI && (n6 & IS_FNC1) == 0) {
            ++encodeT.iStr;
            this.getUnusedBitCntResult = n3;
            int n8 = this.getUnusedBitCnt(encodeT.iBit, n3, n);
            n3 = this.getUnusedBitCntResult;
            if (n8 >= 4 && n8 < 7) {
                this.putBits(encodeT.bitField, encodeT.iBit, 4, n5 + 1 - 48, n);
                if ((n8 -= 4) > 0) {
                    this.putBits(encodeT.bitField, encodeT.iBit + 4, n8, 0, n);
                }
                encodeT.iBit += 4 + n8;
            } else {
                this.putBits(encodeT.bitField, encodeT.iBit, 7, (n5 - 48) * 11 + 10 + 8, n);
                encodeT.iBit += 7;
                if ((n8 -= 7) > 4 || n8 < 0) {
                    n8 = 4;
                }
                if (n8 > 0) {
                    this.putBits(encodeT.bitField, encodeT.iBit, n8, 0, n);
                    encodeT.iBit += n8;
                }
            }
            return 5;
        }
        if ((n6 & n2 & IS_FNC1) != 0 || (n2 & IS_NUM) == 0) {
            this.putBits(encodeT.bitField, encodeT.iBit, 4, 0, n);
            encodeT.iBit += 4;
            return 2;
        }
        encodeT.iStr += 2;
        n5 = (n6 & IS_FNC1) != 0 ? 10 : (n5 -= 48);
        n7 = (n2 & IS_FNC1) != 0 ? 10 : (n7 -= 48);
        this.putBits(encodeT.bitField, encodeT.iBit, 7, n5 * 11 + n7 + 8, n);
        encodeT.iBit += 7;
        return 1;
    }

    public int encodeAlphanumeric(EncodeT encodeT, int n) {
        int n2 = 0;
        if (encodeT.iStr >= encodeT.str.length) {
            return 5;
        }
        int n3 = encodeT.str[encodeT.iStr];
        int n4 = this.iswhat[n3];
        if ((n4 & IS_ALNU) == 0) {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, 4, n);
            encodeT.iBit += 5;
            return 3;
        }
        int n5 = 0;
        if (encodeT.iStr + n2 < encodeT.str.length - 1) {
            n5 = this.iswhat[encodeT.str[encodeT.iStr + 1]];
        }
        if ((n4 & IS_NUM) != 0 && ((n4 | n5) & IS_FNC1) == 0) {
            for (n2 = 1; n2 < 6; ++n2) {
                int n6 = encodeT.iStr + n2 >= encodeT.str.length - 1 ? IS_FINI : this.iswhat[encodeT.str[encodeT.iStr + n2]];
                if (n6 == IS_FINI) {
                    if (n2 < 4) break;
                    this.putBits(encodeT.bitField, encodeT.iBit, 3, 0, n);
                    encodeT.iBit += 3;
                    return 1;
                }
                if ((n6 & IS_NUM) == 0) break;
            }
            if (n2 == 6) {
                this.putBits(encodeT.bitField, encodeT.iBit, 3, 0, n);
                encodeT.iBit += 3;
                return 1;
            }
        }
        ++encodeT.iStr;
        if ((n4 & IS_NUM) != 0) {
            if ((n4 & IS_FNC1) != 0) {
                n3 = 15;
                encodeT.mode = 1;
            } else {
                n3 = n3 - 48 + 5;
            }
            this.putBits(encodeT.bitField, encodeT.iBit, 5, n3, n);
            encodeT.iBit += 5;
        } else {
            if (n3 == SYM_SEP) {
                n3 = 31;
                encodeT.mode = 1;
            } else {
                n3 = n3 >= 65 ? (n3 -= 65) : (n3 >= 44 ? n3 - 44 + 27 : 26);
            }
            this.putBits(encodeT.bitField, encodeT.iBit, 6, n3 + 32, n);
            encodeT.iBit += 6;
        }
        return encodeT.mode;
    }

    public int encodeISO(EncodeT encodeT, int n) {
        if (encodeT.iStr >= encodeT.str.length) {
            return 5;
        }
        int n2 = encodeT.str[encodeT.iStr];
        int n3 = this.iswhat[n2];
        int n4 = 0;
        if ((n3 & IS_ALNU) != 0 && (n3 & IS_FNC1) == 0) {
            int n5;
            if ((n3 & IS_NUM) != 0) {
                n4 = 1;
            }
            for (n5 = 1; n5 < 10; ++n5) {
                int n6 = IS_FINI;
                if (encodeT.iStr + n5 < encodeT.str.length) {
                    n6 = this.iswhat[encodeT.str[encodeT.iStr + n5]];
                }
                if (n6 == IS_FINI) {
                    if (n4 >= 4 || n4 <= -4) {
                        this.putBits(encodeT.bitField, encodeT.iBit, 3, 0, n);
                        encodeT.iBit += 3;
                        return 1;
                    }
                    if (n5 < 5) break;
                    this.putBits(encodeT.bitField, encodeT.iBit, 5, 4, n);
                    encodeT.iBit += 5;
                    return 2;
                }
                if ((n6 & IS_NUM) != 0) {
                    if (n4 > 0) {
                        ++n4;
                    }
                } else if (n4 > 0) {
                    n4 = -n4;
                }
                if ((n6 & IS_ALNU) == 0) break;
            }
            if (n5 == 10) {
                if (n4 >= 4 || n4 <= -4) {
                    this.putBits(encodeT.bitField, encodeT.iBit, 3, 0, n);
                    encodeT.iBit += 3;
                    return 1;
                }
                this.putBits(encodeT.bitField, encodeT.iBit, 5, 4, n);
                encodeT.iBit += 5;
                return 2;
            }
        }
        ++encodeT.iStr;
        if ((n3 & IS_NUM) != 0) {
            if ((n3 & IS_FNC1) != 0) {
                n2 = 15;
                encodeT.mode = 1;
            } else {
                n2 = n2 - 48 + 5;
            }
            this.putBits(encodeT.bitField, encodeT.iBit, 5, n2, n);
            encodeT.iBit += 5;
        } else if (n2 >= 65 && n2 <= 90) {
            n2 = n2 - 65 + 64;
            this.putBits(encodeT.bitField, encodeT.iBit, 7, n2, n);
            encodeT.iBit += 7;
        } else if (n2 >= 97 && n2 <= 122) {
            n2 = n2 - 97 + 90;
            this.putBits(encodeT.bitField, encodeT.iBit, 7, n2, n);
            encodeT.iBit += 7;
        } else {
            if (n2 == 32) {
                n2 = 252;
            } else if (n2 == SYM_SEP) {
                n2 = 253;
                encodeT.mode = 1;
            } else {
                n2 = n2 == 95 ? 251 : (n2 >= 58 ? n2 - 58 + 245 : (n2 >= 37 ? n2 - 37 + 234 : n2 - 33 + 232));
            }
            this.putBits(encodeT.bitField, encodeT.iBit, 8, n2, n);
            encodeT.iBit += 8;
        }
        return encodeT.mode;
    }

    public int encodeAlpha(EncodeT encodeT, int n) {
        int n2 = 0;
        if (encodeT.str[encodeT.iStr] >= 65 && encodeT.str[encodeT.iStr] <= 90) {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, encodeT.str[encodeT.iStr] - 65, n);
            encodeT.iBit += 5;
            ++encodeT.iStr;
        } else if (this.isdigit(encodeT.str[encodeT.iStr])) {
            this.putBits(encodeT.bitField, encodeT.iBit, 6, encodeT.str[encodeT.iStr] + 4, n);
            encodeT.iBit += 6;
            ++encodeT.iStr;
        } else if (encodeT.str[encodeT.iStr] == FNC1) {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, 31, n);
            encodeT.iBit += 5;
            ++encodeT.iStr;
            encodeT.mode = 1;
        } else {
            if ((n2 = this.getUnusedBitCnt(encodeT.iBit, n2, n)) > 5) {
                n2 = 5;
            }
            this.putBits(encodeT.bitField, encodeT.iBit, n2, 31, n);
            encodeT.iBit += n2;
            encodeT.mode = 1;
        }
        return encodeT.mode;
    }

    public int insertPad(EncodeT encodeT, int n) {
        int n2;
        int n3 = 0;
        this.getUnusedBitCntResult = n2 = 0;
        int n4 = this.getUnusedBitCnt(encodeT.iBit, n2, n);
        n2 = this.getUnusedBitCntResult;
        if (n4 < 0) {
            return -1;
        }
        while (n4 >= 5) {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, 4, n);
            encodeT.iBit += 5;
            n4 -= 5;
        }
        if (n4 > 0) {
            n3 = 4 >> 5 - n4;
            this.putBits(encodeT.bitField, encodeT.iBit, n4, n3, n);
            encodeT.iBit += n4;
        }
        return n2;
    }

    public int doMethods(EncodeT encodeT, int n) {
        if (encodeT.str.length >= 8 && encodeT.str[0] == 49 && (encodeT.str[1] == 49 || encodeT.str[1] == 55)) {
            this.putBits(encodeT.bitField, 0, 2, 2, n);
            int n2 = ((encodeT.str[2] - 48) * 10 + (encodeT.str[3] - 48)) * 384;
            n2 += ((encodeT.str[4] - 48) * 10 + (encodeT.str[5] - 48) - 1) * 32;
            this.putBits(encodeT.bitField, 2, 16, n2 += (encodeT.str[6] - 48) * 10 + (encodeT.str[7] - 48), n);
            this.putBits(encodeT.bitField, 18, 1, encodeT.str[1] == 49 ? 0 : 1, n);
            int n3 = 32;
            if (encodeT.str.length > 10) {
                n3 = encodeT.str[10];
            }
            if (encodeT.str.length >= 10 && encodeT.str[8] == 49 && encodeT.str[9] == 48 && n3 != 35) {
                encodeT.iStr = 10;
                encodeT.iBit = 19;
            } else {
                encodeT.str[7] = 35;
                encodeT.iStr = 7;
                encodeT.iBit = 19;
            }
            return 1;
        }
        if (encodeT.str[0] == 57 && encodeT.str[1] == 48 && this.testAI90(encodeT)) {
            this.putBits(encodeT.bitField, encodeT.iBit, 2, 3, n);
            encodeT.iBit += 2;
            this.procAI90(encodeT, n);
        } else {
            this.putBits(encodeT.bitField, 0, 1, 0, n);
            encodeT.iBit = 1;
            encodeT.mode = 1;
            encodeT.iStr = 0;
        }
        return encodeT.mode;
    }

    public boolean testAI90(EncodeT encodeT) {
        encodeT.diNum = -1;
        if (this.isupper(encodeT.str[encodeT.iStr + 2])) {
            encodeT.diAlpha = encodeT.str[encodeT.iStr + 2];
            encodeT.diNum = 0;
            encodeT.iStr += 3;
        } else if (this.isdigit(encodeT.str[encodeT.iStr + 2]) && this.isupper(encodeT.str[encodeT.iStr + 3])) {
            encodeT.diAlpha = encodeT.str[encodeT.iStr + 3];
            encodeT.diNum = encodeT.str[encodeT.iStr + 2] - 48;
            encodeT.iStr += 4;
        } else if (this.isdigit(encodeT.str[encodeT.iStr + 2]) && this.isdigit(encodeT.str[encodeT.iStr + 3]) && this.isupper(encodeT.str[encodeT.iStr + 4])) {
            encodeT.diAlpha = encodeT.str[encodeT.iStr + 4];
            byte by = encodeT.str[encodeT.iStr + 4];
            encodeT.str[encodeT.iStr + 4] = 0;
            encodeT.diNum = this.atoi(encodeT.str, encodeT.iStr + 2);
            encodeT.str[encodeT.iStr + 4] = by;
            encodeT.iStr += 5;
        } else if (this.isdigit(encodeT.str[encodeT.iStr + 2]) && this.isdigit(encodeT.str[encodeT.iStr + 3]) && this.isdigit(encodeT.str[encodeT.iStr + 4]) && this.isupper(encodeT.str[encodeT.iStr + 5])) {
            encodeT.diAlpha = encodeT.str[encodeT.iStr + 5];
            byte by = encodeT.str[encodeT.iStr + 5];
            encodeT.str[encodeT.iStr + 5] = 0;
            encodeT.diNum = this.atoi(encodeT.str, encodeT.iStr + 2);
            encodeT.str[encodeT.iStr + 5] = by;
            encodeT.iStr += 6;
        }
        return encodeT.diNum >= 0;
    }

    public void procAI90(EncodeT encodeT, int n) {
        int n2;
        byte[] byArray = new byte[16];
        int n3 = 10000;
        int n4 = 0;
        for (n2 = encodeT.iStr; n2 < encodeT.str.length && encodeT.str[n2] != FNC1 && encodeT.str[n2] != SYM_SEP; ++n2) {
            if (n3 == 10000 && !this.isdigit(encodeT.str[n2])) {
                n3 = n2;
            }
            if (this.isdigit(encodeT.str[n2])) {
                --n4;
                continue;
            }
            if (this.isupper(encodeT.str[n2])) {
                ++n4;
                continue;
            }
            n4 = -10000;
        }
        int n5 = encodeT.diNum;
        int n6 = encodeT.diAlpha;
        if (n2 < encodeT.str.length && encodeT.str[n2] == FNC1) {
            int n7 = encodeT.iStr;
            encodeT.iStr = n2 + 1;
            this.nextAI(encodeT);
            encodeT.iStr = n7;
        } else {
            encodeT.typeAI = AIx;
        }
        if (n4 > 0) {
            this.putBits(encodeT.bitField, encodeT.iBit, 2, 3, n);
            encodeT.iBit += 2;
            encodeT.mode = 4;
        } else if (n2 > n3 && n3 - encodeT.iStr < 4) {
            this.putBits(encodeT.bitField, encodeT.iBit, 1, 0, n);
            ++encodeT.iBit;
            encodeT.mode = 2;
        } else {
            this.putBits(encodeT.bitField, encodeT.iBit, 2, 2, n);
            encodeT.iBit += 2;
            encodeT.mode = 1;
        }
        if (encodeT.typeAI == AIx) {
            this.putBits(encodeT.bitField, encodeT.iBit, 1, 0, n);
            ++encodeT.iBit;
        } else {
            this.putBits(encodeT.bitField, encodeT.iBit, 2, encodeT.typeAI, n);
            encodeT.iBit += 2;
        }
        for (n3 = 0; n3 < 16 && n6 != byArray[n3]; ++n3) {
        }
        if (n5 < 31 && n3 < 16) {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, n5, n);
            this.putBits(encodeT.bitField, encodeT.iBit + 5, 4, n3, n);
            encodeT.iBit += 9;
        } else {
            this.putBits(encodeT.bitField, encodeT.iBit, 5, 31, n);
            this.putBits(encodeT.bitField, encodeT.iBit + 5, 10, n5, n);
            this.putBits(encodeT.bitField, encodeT.iBit + 15, 5, n6 - 65, n);
            encodeT.iBit += 20;
        }
        this.encodeAI90(encodeT, n);
        if (encodeT.typeAI == AI21) {
            encodeT.iStr += 2;
        } else if (encodeT.typeAI == AI8004) {
            encodeT.iStr += 4;
        }
    }

    public void encodeAI90(EncodeT encodeT, int n) {
        block6: while (encodeT.str[encodeT.iStr - 1] != FNC1 && encodeT.str[encodeT.iStr - 2] != FNC1 && encodeT.str[encodeT.iStr - 1] != SYM_SEP && encodeT.mode != 5) {
            switch (encodeT.mode) {
                case 1: {
                    if (encodeT.str[encodeT.iStr] == FNC1) {
                        if (encodeT.typeAI == AI21) {
                            encodeT.str[encodeT.iStr + 1] = encodeT.str[encodeT.iStr + 3];
                        } else if (encodeT.typeAI == AI8004) {
                            encodeT.str[encodeT.iStr + 1] = encodeT.str[encodeT.iStr + 5];
                        }
                    }
                    encodeT.mode = this.encodeNumeric(encodeT, n);
                    continue block6;
                }
                case 2: {
                    encodeT.mode = this.encodeAlphanumeric(encodeT, n);
                    continue block6;
                }
                case 3: {
                    encodeT.mode = this.encodeISO(encodeT, n);
                    continue block6;
                }
                case 4: {
                    encodeT.mode = this.encodeAlpha(encodeT, n);
                    continue block6;
                }
            }
            System.out.println("\nmode error");
            return;
        }
    }

    public void nextAI(EncodeT encodeT) {
        if (encodeT.str[encodeT.iStr + 0] == 50 && encodeT.str[encodeT.iStr + 1] == 49) {
            encodeT.typeAI = AI21;
            encodeT.iStr += 2;
        } else if (encodeT.str[encodeT.iStr + 0] == 56 && encodeT.str[encodeT.iStr + 1] == 48 && encodeT.str[encodeT.iStr + 2] == 48 && encodeT.str[encodeT.iStr + 3] == 52) {
            encodeT.typeAI = AI8004;
            encodeT.iStr += 4;
        } else {
            encodeT.typeAI = AIx;
        }
    }

    public int doLinMethods(EncodeT encodeT, int n) {
        Object object = "";
        if (encodeT.str.length >= 26) {
            for (int i = 0; i < 6; ++i) {
                object = (String)object + (char)encodeT.str[20 + i];
            }
        }
        if (encodeT.str.length >= 16 && encodeT.str[0] == 48 && encodeT.str[1] == 49) {
            long l;
            if (encodeT.str[2] == 57 && encodeT.str.length == 26 && encodeT.str[16] == 51 && encodeT.str[17] == 49 && encodeT.str[18] == 48 && encodeT.str[19] == 51 && (l = (long)Integer.parseInt((String)object)) <= 32767L) {
                this.putBits(encodeT.bitField, encodeT.iBit, 4, 4, n);
                encodeT.iBit += 4;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 15, (int)l, n);
                encodeT.iBit += 15;
                encodeT.iStr += 11;
            } else if (encodeT.str[2] == 57 && encodeT.str.length == 26 && encodeT.str[16] == 51 && encodeT.str[17] == 50 && encodeT.str[18] == 48 && encodeT.str[19] == 50 && (l = (long)Integer.parseInt((String)object)) <= 9999L) {
                this.putBits(encodeT.bitField, encodeT.iBit, 4, 5, n);
                encodeT.iBit += 4;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 15, (int)l, n);
                encodeT.iBit += 15;
                encodeT.iStr += 11;
            } else if (encodeT.str[2] == 57 && encodeT.str.length == 26 && encodeT.str[16] == 51 && encodeT.str[17] == 50 && encodeT.str[18] == 48 && encodeT.str[19] == 51 && (l = (long)Integer.parseInt((String)object)) <= 22767L) {
                this.putBits(encodeT.bitField, encodeT.iBit, 4, 5, n);
                encodeT.iBit += 4;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 15, (int)l + 10000, n);
                encodeT.iBit += 15;
                encodeT.iStr += 11;
            } else if (encodeT.str[2] == 57 && encodeT.str.length >= 21 && encodeT.str[16] == 51 && encodeT.str[17] == 57 && encodeT.str[18] == 50 && encodeT.str[19] >= 48 && encodeT.str[19] <= 51) {
                this.putBits(encodeT.bitField, encodeT.iBit, 7, 48, n);
                encodeT.iBit += 7;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 2, encodeT.str[19] - 48, n);
                encodeT.iBit += 2;
                encodeT.iStr += 5;
            } else if (encodeT.str[2] == 57 && encodeT.str.length >= 24 && encodeT.str[16] == 51 && encodeT.str[17] == 57 && encodeT.str[18] == 51 && encodeT.str[19] >= 48 && encodeT.str[19] <= 51) {
                this.putBits(encodeT.bitField, encodeT.iBit, 7, 52, n);
                encodeT.iBit += 7;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 2, encodeT.str[19] - 48, n);
                encodeT.iBit += 2;
                encodeT.iStr += 5;
                object = "" + (char)encodeT.str[20] + (char)encodeT.str[21] + (char)encodeT.str[22];
                this.putBits(encodeT.bitField, encodeT.iBit, 10, Integer.parseInt((String)object), n);
                encodeT.iBit += 10;
                encodeT.iStr += 3;
            } else if (encodeT.str[2] == 57 && encodeT.str.length == 26 && encodeT.str[16] == 51 && (encodeT.str[17] == 49 || encodeT.str[17] == 50) && encodeT.str[18] == 48 && (l = (long)Integer.parseInt((String)object)) <= 99999L) {
                int n2 = 56 + (encodeT.str[17] - 49);
                this.putBits(encodeT.bitField, encodeT.iBit, 7, n2, n);
                encodeT.iBit += 7;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 4, (int)((l += (long)(encodeT.str[19] - 48) * 100000L) >> 16), n);
                this.putBits(encodeT.bitField, encodeT.iBit + 4, 16, (int)(l & 0xFFFFL), n);
                encodeT.iBit += 20;
                encodeT.iStr += 11;
                this.putBits(encodeT.bitField, encodeT.iBit, 16, 38400, n);
                encodeT.iBit += 16;
            } else if (!(encodeT.str[2] != 57 || encodeT.str.length != 34 || encodeT.str[16] != 51 || encodeT.str[17] != 49 && encodeT.str[17] != 50 || encodeT.str[18] != 48 || (l = (long)Integer.parseInt((String)object)) > 99999L || encodeT.str[26] != 49 || encodeT.str[27] != 49 && encodeT.str[27] != 51 && encodeT.str[27] != 53 && encodeT.str[27] != 55)) {
                int n3 = 56 + (encodeT.str[27] - 49) + (encodeT.str[17] - 49);
                this.putBits(encodeT.bitField, encodeT.iBit, 7, n3, n);
                encodeT.iBit += 7;
                encodeT.iStr += 3;
                this.cnv12(encodeT, n);
                this.putBits(encodeT.bitField, encodeT.iBit, 4, (int)((l += (long)(encodeT.str[19] - 48) * 100000L) >> 16), n);
                this.putBits(encodeT.bitField, encodeT.iBit + 4, 16, (int)(l & 0xFFFFL), n);
                encodeT.iBit += 20;
                encodeT.iStr += 11;
                this.putBits(encodeT.bitField, encodeT.iBit, 16, this.yymmdd(encodeT.str, encodeT.iStr + 2), n);
                encodeT.iBit += 16;
                encodeT.iStr += 8;
            } else {
                this.putBits(encodeT.bitField, encodeT.iBit, 3, 4, n);
                encodeT.iBit += 3;
                encodeT.iStr += 2;
                this.cnv13(encodeT, n);
                ++encodeT.iStr;
            }
        } else {
            this.putBits(encodeT.bitField, encodeT.iBit, 4, 0, n);
            encodeT.iBit += 4;
        }
        return 1;
    }

    public int yymmdd(byte[] byArray, int n) {
        int n2 = ((byArray[n + 0] - 48) * 10 + (byArray[n + 1] - 48)) * 384;
        n2 += ((byArray[n + 2] - 48) * 10 + (byArray[n + 3] - 48) - 1) * 32;
        return n2 += (byArray[n + 4] - 48) * 10 + (byArray[n + 5] - 48);
    }

    public void cnv13(EncodeT encodeT, int n) {
        this.putBits(encodeT.bitField, encodeT.iBit, 4, encodeT.str[encodeT.iStr] - 48, n);
        encodeT.iBit += 4;
        ++encodeT.iStr;
        for (int i = 0; i < 4; ++i) {
            this.putBits(encodeT.bitField, encodeT.iBit, 10, (encodeT.str[encodeT.iStr] - 48) * 100 + (encodeT.str[encodeT.iStr + 1] - 48) * 10 + encodeT.str[encodeT.iStr + 2] - 48, n);
            encodeT.iBit += 10;
            encodeT.iStr += 3;
        }
    }

    public void cnv12(EncodeT encodeT, int n) {
        for (int i = 0; i < 4; ++i) {
            this.putBits(encodeT.bitField, encodeT.iBit, 10, (encodeT.str[encodeT.iStr] - 48) * 100 + (encodeT.str[encodeT.iStr + 1] - 48) * 10 + encodeT.str[encodeT.iStr + 2] - 48, n);
            encodeT.iBit += 10;
            encodeT.iStr += 3;
        }
    }

    public int getUnusedBitCnt(int n, int n2, int n3) {
        this.getUnusedBitCntResult = n2;
        int[] nArray = new int[]{48, 176, 352, 927, 0};
        if (n3 == 1) {
            this.getUnusedBitCntResult = 0;
            if (n <= 252) {
                this.getUnusedBitCntResult = (n + 11) / 12;
                if (this.getUnusedBitCntResult < 3) {
                    this.getUnusedBitCntResult = 3;
                }
                if ((this.getUnusedBitCntResult + 1 + this.rowWidth) % this.rowWidth == 1) {
                    ++this.getUnusedBitCntResult;
                }
                return this.getUnusedBitCntResult * 12 - n;
            }
        } else if (n3 == 0) {
            int n4 = 0;
            while (this.CCSizes[n4] != 0) {
                if (n <= this.CCSizes[n4]) {
                    this.getUnusedBitCntResult = n4;
                    return this.CCSizes[n4] - n;
                }
                ++n4;
            }
        } else if (n3 == -1) {
            int n5 = (n + 7) / 8;
            int n6 = n5 / 6;
            int n7 = n5 / 6 * 5 + n5 % 6;
            n6 = 0;
            this.eccCnt = 8;
            while (this.eccCnt <= 64 && n7 + this.eccCnt > nArray[n6]) {
                ++n6;
                this.eccCnt *= 2;
            }
            if (this.eccCnt > 64) {
                return -1;
            }
            ++this.colCnt;
            do {
                --this.colCnt;
                this.rowCnt = this.max(3, (3 + n7 + this.eccCnt + this.colCnt - 1) / this.colCnt);
                if (this.rowCnt <= MAX_CCC_ROWS) continue;
                return -1;
            } while (this.colCnt + 4 > this.rowCnt * 4);
            if (this.rowCnt == 3) {
                this.colCnt = 0;
                this.max(4, (3 + n7 + this.eccCnt + 2) / 3);
            }
            n7 = this.colCnt * this.rowCnt - 1 - 2 - this.eccCnt;
            n5 = n7 / 5 * 6 + n7 % 5;
            this.getUnusedBitCntResult = -1;
            return n5 * 8 - n;
        }
        return -1;
    }

    public void putBits(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n4 == -1 ? MAX_CCC_BYTES : MAX_BYTES;
        if (n + n2 > n5 * 8 || n2 > 16) {
            return;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            if ((n3 & 1) != 0) {
                int n6 = (n + i) / 8;
                byArray[n6] = (byte)(byArray[n6] | 128 >> (n + i) % 8);
            } else {
                int n7 = (n + i) % 8;
                int n8 = 128 >> (n + i) % 8;
                int n9 = ~(128 >> (n + i) % 8);
                int n10 = byArray[(n + i) / 8];
                n10 &= n9;
                int n11 = (n + i) / 8;
                byArray[n11] = (byte)(byArray[n11] & ~(128 >> (n + i) % 8));
            }
            n3 >>= 1;
        }
    }

    public int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private boolean isupper(byte by) {
        return by >= 65 && by <= 90;
    }

    private boolean isdigit(byte by) {
        return by >= 48 && by <= 57;
    }

    private int atoi(byte[] byArray, int n) {
        Object object = "";
        for (int i = n; i < byArray.length && byArray[i] >= 48 && byArray[i] <= 57; ++i) {
            object = (String)object + (char)byArray[i];
        }
        return Integer.parseInt((String)object);
    }
}

