/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class BoggsProjection
extends PseudoCylindricalProjection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double FXC = 2.00276;
    private static final double FXC2 = 1.11072;
    private static final double FYC = 0.49931;
    private static final double FYC2 = 1.4142135623730951;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = d2;
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-7) {
            projCoordinate.x = 0.0;
        } else {
            double d4 = Math.sin(d3) * Math.PI;
            for (int i = 20; i > 0; --i) {
                double d5 = (d3 + Math.sin(d3) - d4) / (1.0 + Math.cos(d3));
                d3 -= d5;
                if (Math.abs(d5) < 1.0E-7) break;
            }
            projCoordinate.x = 2.00276 * d / (1.0 / Math.cos(d2) + 1.11072 / Math.cos(d3 *= 0.5));
        }
        projCoordinate.y = 0.49931 * (d2 + 1.4142135623730951 * Math.sin(d3));
        return projCoordinate;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return false;
    }

    @Override
    public String toString() {
        return "Boggs Eumorphic";
    }
}

