/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class McBrydeThomasFlatPolarSine2Projection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;
    private static final double C1 = 0.45503;
    private static final double C2 = 1.36509;
    private static final double C3 = 1.41546;
    private static final double C_x = 0.22248;
    private static final double C_y = 1.44492;
    private static final double C1_2 = 0.3333333333333333;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4 = 1.41546 * Math.sin(d2);
        for (int i = 10; i > 0; --i) {
            d3 = d2 / 1.36509;
            double d5 = (0.45503 * Math.sin(d3) + Math.sin(d2) - d4) / (0.3333333333333333 * Math.cos(d3) + Math.cos(d2));
            projCoordinate.y -= d5;
            if (Math.abs(d5) < 1.0E-7) break;
        }
        d3 = d2 / 1.36509;
        projCoordinate.x = 0.22248 * d * (1.0 + 3.0 * Math.cos(d2) / Math.cos(d3));
        projCoordinate.y = 1.44492 * Math.sin(d3);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = ProjectionMath.asin(d2 / 1.44492);
        projCoordinate.y = 1.36509 * d3;
        projCoordinate.x = d / (0.22248 * (1.0 + 3.0 * Math.cos(projCoordinate.y) / Math.cos(d3)));
        projCoordinate.y = ProjectionMath.asin((0.45503 * Math.sin(d3) + Math.sin(projCoordinate.y)) / 1.41546);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "McBryde-Thomas Flat-Pole Sine (No. 2)";
    }
}

