/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class RobinsonProjection
extends PseudoCylindricalProjection {
    private static final double[] X = new double[]{1.0, -5.67239E-12, -7.15511E-5, 3.11028E-6, 0.9986, -4.82241E-4, -2.4897E-5, -1.33094E-6, 0.9954, -8.31031E-4, -4.4861E-5, -9.86588E-7, 0.99, -0.00135363, -5.96598E-5, 3.67749E-6, 0.9822, -0.00167442, -4.4975E-6, -5.72394E-6, 0.973, -0.00214869, -9.03565E-5, 1.88767E-8, 0.96, -0.00305084, -9.00732E-5, 1.64869E-6, 0.9427, -0.00382792, -6.53428E-5, -2.61493E-6, 0.9216, -0.00467747, -1.04566E-4, 4.8122E-6, 0.8962, -0.00536222, -3.23834E-5, -5.43445E-6, 0.8679, -0.00609364, -1.139E-4, 3.32521E-6, 0.835, -0.00698325, -6.40219E-5, 9.34582E-7, 0.7986, -0.00755337, -5.00038E-5, 9.35532E-7, 0.7597, -0.00798325, -3.59716E-5, -2.27604E-6, 0.7186, -0.00851366, -7.0112E-5, -8.63072E-6, 0.6732, -0.00986209, -1.99572E-4, 1.91978E-5, 0.6213, -0.010418, 8.83948E-5, 6.24031E-6, 0.5722, -0.00906601, 1.81999E-4, 6.24033E-6, 0.5322, 0.0, 0.0, 0.0};
    private static final double[] Y = new double[]{0.0, 0.0124, 3.72529E-10, 1.15484E-9, 0.062, 0.0124001, 1.76951E-8, -5.92321E-9, 0.124, 0.0123998, -7.09668E-8, 2.25753E-8, 0.186, 0.0124008, 2.66917E-7, -8.44523E-8, 0.248, 0.0123971, -9.99682E-7, 3.15569E-7, 0.31, 0.0124108, 3.73349E-6, -1.1779E-6, 0.372, 0.0123598, -1.3935E-5, 4.39588E-6, 0.434, 0.0125501, 5.20034E-5, -1.00051E-5, 0.4958, 0.0123198, -9.80735E-5, 9.22397E-6, 0.5571, 0.0120308, 4.02857E-5, -5.2901E-6, 0.6176, 0.0120369, -3.90662E-5, 7.36117E-7, 0.6769, 0.0117015, -2.80246E-5, -8.54283E-7, 0.7346, 0.0113572, -4.08389E-5, -5.18524E-7, 0.7903, 0.0109099, -4.86169E-5, -1.0718E-6, 0.8435, 0.0103433, -6.46934E-5, 5.36384E-9, 0.8936, 0.00969679, -6.46129E-5, -8.54894E-6, 0.9394, 0.00840949, -1.92847E-4, -4.21023E-6, 0.9761, 0.00616525, -2.56001E-4, -4.21021E-6, 1.0, 0.0, 0.0, 0.0};
    private final int NODES = 18;
    private static final double FXC = 0.8487;
    private static final double FYC = 1.3523;
    private static final double C1 = 11.459155902616464;
    private static final double RC1 = 0.08726646259971647;
    private static final double ONEEPS = 1.000001;
    private static final double EPS = 1.0E-8;

    private double poly(double[] dArray, int n, double d) {
        return dArray[n] + d * (dArray[n + 1] + d * (dArray[n + 2] + d * dArray[n + 3]));
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.abs(d2);
        int n = (int)Math.floor(d3 * 11.459155902616464);
        if (n >= 18) {
            n = 17;
        }
        d3 = Math.toDegrees(d3 - 0.08726646259971647 * (double)n);
        projCoordinate.x = this.poly(X, n *= 4, d3) * 0.8487 * d;
        projCoordinate.y = this.poly(Y, n, d3) * 1.3523;
        if (d2 < 0.0) {
            projCoordinate.y = -projCoordinate.y;
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d / 0.8487;
        projCoordinate.y = Math.abs(d2 / 1.3523);
        if (projCoordinate.y >= 1.0) {
            if (projCoordinate.y > 1.000001) {
                throw new ProjectionException();
            }
            projCoordinate.y = d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            projCoordinate.x /= X[72];
        } else {
            double d3;
            int n = 4 * (int)Math.floor(projCoordinate.y * 18.0);
            while (true) {
                if (Y[n] > projCoordinate.y) {
                    n -= 4;
                    continue;
                }
                if (!(Y[n + 4] <= projCoordinate.y)) break;
                n += 4;
            }
            double d4 = 5.0 * (projCoordinate.y - Y[n]) / (Y[n + 4] - Y[n]);
            double d5 = Y[n];
            double d6 = Y[n + 1];
            double d7 = Y[n + 2];
            double d8 = Y[n + 3];
            d4 = 5.0 * (projCoordinate.y - d5) / (Y[n + 1] - d5);
            d5 -= projCoordinate.y;
            do {
                d3 = (d5 + d4 * (d6 + d4 * (d7 + d4 * d8))) / (d6 + d4 * (d7 + d7 + d4 * 3.0 * d8));
                d4 -= d3;
            } while (!(Math.abs(d3) < 1.0E-8));
            projCoordinate.y = Math.toRadians((double)(5 * n) + d4);
            if (d2 < 0.0) {
                projCoordinate.y = -projCoordinate.y;
            }
            projCoordinate.x /= this.poly(X, n, d4);
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Robinson";
    }
}

