/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.ConicProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class SimpleConicProjection
extends ConicProjection {
    private double n;
    private double rho_c;
    private double rho_0;
    private double sig;
    private double c1;
    private double c2;
    private int type;
    public static final int EULER = 0;
    public static final int MURD1 = 1;
    public static final int MURD2 = 2;
    public static final int MURD3 = 3;
    public static final int PCONIC = 4;
    public static final int TISSOT = 5;
    public static final int VITK1 = 6;
    private static final double EPS10 = 1.0E-10;
    private static final double EPS = 1.0E-10;

    public SimpleConicProjection() {
        this(0);
    }

    public SimpleConicProjection(int n) {
        this.type = n;
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
    }

    @Override
    public String toString() {
        return "Simple Conic";
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = switch (this.type) {
            case 2 -> this.rho_c + Math.tan(this.sig - d2);
            case 4 -> this.c2 * (this.c1 - Math.tan(d2 - this.sig));
            default -> this.rho_c - d2;
        };
        projCoordinate.x = d3 * Math.sin(d *= this.n);
        projCoordinate.y = this.rho_0 - d3 * Math.cos(d);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = this.rho_0 - d2;
        double d3 = ProjectionMath.distance(d, projCoordinate.y);
        if (this.n < 0.0) {
            d3 = -d3;
            projCoordinate.x = -d;
            projCoordinate.y = -d2;
        }
        projCoordinate.x = Math.atan2(d, d2) / this.n;
        switch (this.type) {
            case 4: {
                projCoordinate.y = Math.atan(this.c1 - d3 / this.c2) + this.sig;
                break;
            }
            case 2: {
                projCoordinate.y = this.sig - Math.atan(d3 - this.rho_c);
                break;
            }
            default: {
                projCoordinate.y = this.rho_c - d3;
            }
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        int n = 0;
        double d = Math.toRadians(30.0);
        double d2 = Math.toRadians(60.0);
        double d3 = 0.5 * (d2 - d);
        this.sig = 0.5 * (d2 + d);
        int n2 = n = Math.abs(d3) < 1.0E-10 || Math.abs(this.sig) < 1.0E-10 ? -42 : 0;
        if (n != 0) {
            throw new ProjectionException("Error " + n);
        }
        switch (this.type) {
            case 5: {
                this.n = Math.sin(this.sig);
                double d4 = Math.cos(d3);
                this.rho_c = this.n / d4 + d4 / this.n;
                this.rho_0 = Math.sqrt((this.rho_c - 2.0 * Math.sin(this.projectionLatitude)) / this.n);
                break;
            }
            case 1: {
                this.rho_c = Math.sin(d3) / (d3 * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                this.n = Math.sin(this.sig);
                break;
            }
            case 2: {
                double d5 = Math.sqrt(Math.cos(d3));
                this.rho_c = d5 / Math.tan(this.sig);
                this.rho_0 = this.rho_c + Math.tan(this.sig - this.projectionLatitude);
                this.n = Math.sin(this.sig) * d5;
                break;
            }
            case 3: {
                this.rho_c = d3 / (Math.tan(this.sig) * Math.tan(d3)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                this.n = Math.sin(this.sig) * Math.sin(d3) * Math.tan(d3) / (d3 * d3);
                break;
            }
            case 0: {
                this.n = Math.sin(this.sig) * Math.sin(d3) / d3;
                this.rho_c = (d3 *= 0.5) / (Math.tan(d3) * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                break;
            }
            case 4: {
                double d6;
                this.n = Math.sin(this.sig);
                this.c2 = Math.cos(d3);
                this.c1 = 1.0 / Math.tan(this.sig);
                d3 = this.projectionLatitude - this.sig;
                if (Math.abs(d6) - 1.0E-10 >= 1.5707963267948966) {
                    throw new ProjectionException("-43");
                }
                this.rho_0 = this.c2 * (this.c1 - Math.tan(d3));
                this.maxLatitude = Math.toRadians(60.0);
                break;
            }
            case 6: {
                double d7 = Math.tan(d3);
                this.n = d7 * Math.sin(this.sig) / d3;
                this.rho_c = d3 / (d7 * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
            }
        }
    }
}

