/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class TransverseMercatorProjection
extends CylindricalProjection {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private int utmZone = -1;
    private double esp;
    private double ml0;
    private double[] en;

    public TransverseMercatorProjection() {
        this.ellipsoid = Ellipsoid.GRS80;
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    public TransverseMercatorProjection(Ellipsoid ellipsoid, double d, double d2, double d3, double d4, double d5) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = d;
        this.projectionLatitude = d2;
        this.scaleFactor = d3;
        this.falseEasting = d4;
        this.falseNorthing = d5;
        this.initialize();
    }

    @Override
    public Object clone() {
        TransverseMercatorProjection transverseMercatorProjection = (TransverseMercatorProjection)super.clone();
        if (this.en != null) {
            transverseMercatorProjection.en = (double[])this.en.clone();
        }
        return transverseMercatorProjection;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.spherical) {
            this.esp = this.scaleFactor;
            this.ml0 = 0.5 * this.esp;
        } else {
            this.en = ProjectionMath.enfn(this.es);
            this.ml0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
            this.esp = this.es / (1.0 - this.es);
        }
    }

    public static int getRowFromNearestParallel(double d) {
        int n = (int)ProjectionMath.radToDeg(ProjectionMath.normalizeLatitude(d));
        if (n < -80 || n > 84) {
            return 0;
        }
        if (n > 80) {
            return 24;
        }
        return (n + 80) / 8 + 3;
    }

    public static int getZoneFromNearestMeridian(double d) {
        int n = (int)Math.floor((ProjectionMath.normalizeLongitude(d) + Math.PI) * 30.0 / Math.PI) + 1;
        if (n < 1) {
            n = 1;
        } else if (n > 60) {
            n = 60;
        }
        return n;
    }

    public void setUTMZone(int n) {
        this.utmZone = n--;
        this.projectionLongitude = ((double)n + 0.5) * Math.PI / 30.0 - Math.PI;
        this.projectionLatitude = 0.0;
        this.scaleFactor = 0.9996;
        this.falseEasting = 500000.0;
        this.falseNorthing = this.isSouth ? 1.0E7 : 0.0;
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = Math.cos(d2);
            double d4 = d3 * Math.sin(d);
            projCoordinate.x = this.ml0 * this.scaleFactor * Math.log((1.0 + d4) / (1.0 - d4));
            double d5 = d3 * Math.cos(d) / Math.sqrt(1.0 - d4 * d4);
            d5 = ProjectionMath.acos(d5);
            if (d2 < 0.0) {
                d5 = -d5;
            }
            projCoordinate.y = this.esp * (d5 - this.projectionLatitude);
        } else {
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = Math.abs(d7) > 1.0E-10 ? d6 / d7 : 0.0;
            d8 *= d8;
            double d9 = d7 * d;
            double d10 = d9 * d9;
            double d11 = this.esp * d7 * d7;
            projCoordinate.x = this.scaleFactor * (d9 /= Math.sqrt(1.0 - this.es * d6 * d6)) * (1.0 + 0.16666666666666666 * d10 * (1.0 - d8 + d11 + 0.05 * d10 * (5.0 + d8 * (d8 - 18.0) + d11 * (14.0 - 58.0 * d8) + 0.023809523809523808 * d10 * (61.0 + d8 * (d8 * (179.0 - d8) - 479.0)))));
            projCoordinate.y = this.scaleFactor * (ProjectionMath.mlfn(d2, d6, d7, this.en) - this.ml0 + d6 * d9 * d * 0.5 * (1.0 + 0.08333333333333333 * d10 * (5.0 - d8 + d11 * (9.0 + 4.0 * d11) + 0.03333333333333333 * d10 * (61.0 + d8 * (d8 - 58.0) + d11 * (270.0 - 330.0 * d8) + 0.017857142857142856 * d10 * (1385.0 + d8 * (d8 * (543.0 - d8) - 3111.0))))));
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = Math.exp(d / this.scaleFactor);
            double d4 = 0.5 * (d3 - 1.0 / d3);
            d3 = Math.cos(this.projectionLatitude + d2 / this.scaleFactor);
            projCoordinate.y = ProjectionMath.asin(Math.sqrt((1.0 - d3 * d3) / (1.0 + d4 * d4)));
            if (d2 < 0.0) {
                projCoordinate.y = -projCoordinate.y;
            }
            projCoordinate.x = Math.atan2(d4, d3);
        } else {
            projCoordinate.y = ProjectionMath.inv_mlfn(this.ml0 + d2 / this.scaleFactor, this.es, this.en);
            if (Math.abs(d2) >= 1.5707963267948966) {
                projCoordinate.y = d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                projCoordinate.x = 0.0;
            } else {
                double d5 = Math.sin(projCoordinate.y);
                double d6 = Math.cos(projCoordinate.y);
                double d7 = Math.abs(d6) > 1.0E-10 ? d5 / d6 : 0.0;
                double d8 = this.esp * d6 * d6;
                double d9 = 1.0 - this.es * d5 * d5;
                double d10 = d * Math.sqrt(d9) / this.scaleFactor;
                d9 *= d7;
                d7 *= d7;
                double d11 = d10 * d10;
                projCoordinate.y -= d9 * d11 / (1.0 - this.es) * 0.5 * (1.0 - d11 * 0.08333333333333333 * (5.0 + d7 * (3.0 - 9.0 * d8) + d8 * (1.0 - 4.0 * d8) - d11 * 0.03333333333333333 * (61.0 + d7 * (90.0 - 252.0 * d8 + 45.0 * d7) + 46.0 * d8 - d11 * 0.017857142857142856 * (1385.0 + d7 * (3633.0 + d7 * (4095.0 + 1574.0 * d7))))));
                projCoordinate.x = d10 * (1.0 - d11 * 0.16666666666666666 * (1.0 + 2.0 * d7 + d8 - d11 * 0.05 * (5.0 + d7 * (28.0 + 24.0 * d7 + 8.0 * d8) + 6.0 * d8 - d11 * 0.023809523809523808 * (61.0 + d7 * (662.0 + d7 * (1320.0 + 720.0 * d7)))))) / d6;
            }
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        if (this.utmZone >= 0) {
            return "Universal Tranverse Mercator";
        }
        return "Transverse Mercator";
    }
}

