/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.Builder;
import ambience.datasets.Builder$BuildError$;
import ambience.datasets.Builder$JsonResponse$;
import ambience.datasets.Builder$NotFound$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedHelper$;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.DatasetsModule$;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.ExcludeHiddenFields$;
import ambience.datasets.FilterManager$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.PipelinePreprocessor$;
import ambience.datasets.RowSecurity$;
import ambience.datasets.StepSequence;
import ambience.datasets.StepSequence$;
import ambience.datasets.UserLookup$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.JsonTransformer$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Aggregates$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BuildAggregate
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BuildAggregate.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;
    private final Scheduler scheduler;

    public BuildAggregate(DatasetsModule module) {
        this.module = module;
        this.scheduler = module.scheduler();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Task<Builder.Response> run(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, String datasetName, Json json, boolean strict) {
        this.log().info(() -> BuildAggregate.run$$anonfun$1(datasetName), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.run"));
        StepSequence stepSequence = StepSequence$.MODULE$.build(json);
        return this.module.fetchDataset(user, datasetName, (Option<String>)None$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.runMongo(user, filterFn, ds, stepSequence, strict);
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.runETL(user, filterFn, ds, stepSequence, strict);
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return this.runCached(user, filterFn, ds, stepSequence, strict);
                }
            }
            if (either instanceof Left) {
                Builder.Response response = (Builder.Response)((Left)either).value();
                return Task$.MODULE$.apply(() -> BuildAggregate.run$$anonfun$2$$anonfun$1(response));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Builder.Response> runETL(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ETLDataset ds, StepSequence stepSequence, boolean strict) {
        ETLHelper etlHelper = this.module.etlHelper();
        return etlHelper.getChainSet(user, ds.chainset()).flatMap((Function1 & Serializable)chainset -> etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain()), stepSequence.etlInjection()).flatMap((Function1 & Serializable)uuid -> Task$.MODULE$.apply(() -> this.runETL$$anonfun$1$$anonfun$1$$anonfun$1(ds, uuid)).flatMap((Function1 & Serializable)mds -> this.runMongo(user, filterFn, (MongoDBDataset)mds, stepSequence, strict).flatMap((Function1 & Serializable)result -> etlHelper.dropTemp(user, (String)uuid).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return result;
        })))));
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, MongoDBDataset ds, StepSequence stepSequence, boolean strict) {
        this.log().info(() -> BuildAggregate.runMongo$$anonfun$1(ds), Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
        this.log().debug(() -> BuildAggregate.runMongo$$anonfun$2(stepSequence), Line$.MODULE$.apply(62), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
        return ((Observable)filterFn.apply((Object)ds)).toListL().flatMap((Function1 & Serializable)userFilters -> {
            Option option = this.module.databaseMap().get((Object)ds.database());
            if (option instanceof Some) {
                MongoDatabase database = (MongoDatabase)((Some)option).value();
                return this.runMongo(user, filterFn, ds, stepSequence, (List<BsonDocument>)userFilters, database, strict);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> BuildAggregate.runMongo$$anonfun$3$$anonfun$1(ds), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
                return Task$.MODULE$.now((Object)Builder$NotFound$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, MongoDBDataset ds, StepSequence stepSequence, List<BsonDocument> userFilters, MongoDatabase database, boolean strict) {
        RichMongoCollection cltn = new RichMongoCollection(database.getCollection(ds.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return this.runMongo(user, filterFn, (Dataset)ds, stepSequence, userFilters, cltn, strict);
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, Dataset ds, StepSequence stepSequence, List<BsonDocument> userFilters, RichMongoCollection cltn, boolean strict) {
        long start = System.currentTimeMillis();
        ListBuffer pipeline = new ListBuffer();
        pipeline.$plus$plus$eq(userFilters);
        if (ds.filters().nonEmpty()) {
            pipeline.$plus$eq((Object)BsonUtils$.MODULE$.toDocument(Aggregates$.MODULE$.match(FilterManager$.MODULE$.buildFilter(ds.filters()))));
        }
        pipeline.$plus$plus$eq((IterableOnce)ds.aggregation().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        pipeline.$plus$plus$eq(RowSecurity$.MODULE$.apply(user, ds));
        pipeline.$plus$plus$eq((IterableOnce)stepSequence.steps().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        Map<String, Json> lookupMap = this.buildLookupMap(stepSequence.etlInjection());
        lookupMap.foreach((Function1 & Serializable)kv -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$elx-parameter");
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[2];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply((String)kv._1())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
            objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)JsonTransformer$.MODULE$.toBson((Json)kv._2())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return (ListBuffer)pipeline.$plus$eq((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        });
        ExcludeHiddenFields$.MODULE$.from(ds).foreach((Function1 & Serializable)_$1 -> (ListBuffer)pipeline.$plus$eq(_$1));
        this.log().debug(() -> BuildAggregate.runMongo$$anonfun$8(pipeline), Line$.MODULE$.apply(107), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
        List<BsonDocument> steps = PipelinePreprocessor$.MODULE$.bson((List<BsonValue>)pipeline.toList(), this.lookup(user));
        this.log().debug(() -> BuildAggregate.runMongo$$anonfun$9(steps), Line$.MODULE$.apply(109), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
        return cltn.aggregateO(steps).map((Function1 & Serializable)doc -> DatasetsModule$.MODULE$.bsonToJsonString(strict, (Document)doc)).toListL().map((Function1 & Serializable)reply -> {
            Builder.JsonResponse response = Builder$JsonResponse$.MODULE$.apply(reply.mkString("[", ",\n", "]"), ds.etag());
            long stop = System.currentTimeMillis();
            this.log().info(() -> BuildAggregate.runMongo$$anonfun$11$$anonfun$1(ds, reply, stop, start), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
            return response;
        }).onErrorRecover((PartialFunction)new Serializable(steps, this){
            private final List steps$2;
            private final /* synthetic */ BuildAggregate $outer;
            {
                this.steps$2 = steps$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> BuildAggregate.ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(121), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
                ((List)this.steps$2.map(BuildAggregate::ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$2).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String step = (String)tuple2._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        this.$outer.log().info(() -> BuildAggregate.ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(idx, step), Line$.MODULE$.apply(123), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runMongo"));
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Builder$BuildError$.MODULE$.apply("Aggregation Error: See server log for details");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable ), ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$2(org.bson.BsonDocument ), applyOrElse$$anonfun$3(scala.Tuple2 ), ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(int java.lang.String )}, serializedLambda);
            }
        });
    }

    public PartialFunction<String, Json> lookup(UserDB.User user) {
        return UserLookup$.MODULE$.apply(user).orElse(PipelinePreprocessor$.MODULE$.ConfiguredLookup());
    }

    public Map<String, Json> buildLookupMap(Json json) {
        return (Map)json.asObject().map((Function1 & Serializable)_$5 -> _$5.toMap()).getOrElse(BuildAggregate::buildLookupMap$$anonfun$2);
    }

    public Task<Builder.Response> runCached(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, CachedDataset ds, StepSequence stepSequence, boolean strict) {
        this.log().info(() -> BuildAggregate.runCached$$anonfun$1(ds), Line$.MODULE$.apply(144), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runCached"));
        this.log().debug(() -> BuildAggregate.runCached$$anonfun$2(stepSequence), Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.datasets.BuildAggregate.runCached"));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonObjectId$.MODULE$.apply(ds.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        List steps = CachedHelper$.MODULE$.BaseSteps().$colon$colon((Object)bsonDocument);
        return this.runMongo(user, filterFn, ds, stepSequence, (List<BsonDocument>)steps, Collections$.MODULE$.datasets(), strict);
    }

    private static final Object run$$anonfun$1(String datasetName$1) {
        return "buildAggregate(" + datasetName$1 + ") starting";
    }

    private static final Builder.Response run$$anonfun$2$$anonfun$1(Builder.Response response$1) {
        return response$1;
    }

    private final MongoDBDataset runETL$$anonfun$1$$anonfun$1$$anonfun$1(ETLDataset ds$3, String uuid$1) {
        return ds$3.toMongo(this.module.tempDatabaseName(), uuid$1);
    }

    private static final Object runMongo$$anonfun$1(MongoDBDataset ds$4) {
        return "buildAggregate(" + ds$4.name() + "," + ds$4.database() + "," + ds$4.collection() + ") starting";
    }

    private static final Object runMongo$$anonfun$2(StepSequence stepSequence$5) {
        return "stepSequence: " + stepSequence$5;
    }

    private static final Object runMongo$$anonfun$3$$anonfun$1(MongoDBDataset ds$6) {
        return "buildAggregate(" + ds$6.name() + ") database " + ds$6.database() + " not found";
    }

    private static final Object runMongo$$anonfun$8(ListBuffer pipeline$3) {
        return "built steps:\n" + ((IterableOnceOps)pipeline$3.map((Function1 & Serializable)_$2 -> _$2.toString())).mkString("\n");
    }

    private static final Object runMongo$$anonfun$9(List steps$1) {
        return "processed steps:\n" + steps$1.map((Function1 & Serializable)_$3 -> _$3.toString()).mkString("\n");
    }

    private static final Object runMongo$$anonfun$11$$anonfun$1(Dataset ds$8, List reply$1, long stop$1, long start$2) {
        return "buildAggregate(" + ds$8.name() + ") completed. " + reply$1.size() + " records. Elapsed time: " + (stop$1 - start$2) + "ms";
    }

    public static final Object ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "Aggregation error: " + ex$1;
    }

    public static final /* synthetic */ String ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$2(BsonDocument _$4) {
        return _$4.toJson();
    }

    public static final Object ambience$datasets$BuildAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(int idx$1, String step$1) {
        return "Step " + idx$1 + " " + step$1;
    }

    private static final Map buildLookupMap$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Object runCached$$anonfun$1(CachedDataset ds$9) {
        return "buildAggregate(" + ds$9.name() + ") starting";
    }

    private static final Object runCached$$anonfun$2(StepSequence stepSequence$7) {
        return "stepSequence: " + stepSequence$7;
    }
}

