/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.AllHelper$;
import ambience.datasets.Builder;
import ambience.datasets.Builder$JsonResponse$;
import ambience.datasets.Builder$NotFound$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedHelper$;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.DatasetsModule$;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.JsonParams$;
import ambience.datasets.MongoDBDataset;
import ambience.etl.ETLChainSet;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BuildAll
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BuildAll.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;

    public BuildAll(DatasetsModule module) {
        this.module = module;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Builder.Response> run(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, String datasetName, Option<String> optEtag, boolean strict) {
        this.log().info(() -> BuildAll.run$$anonfun$1(datasetName), Line$.MODULE$.apply(24), FullName$.MODULE$.apply("ambience.datasets.BuildAll.run"));
        return this.module.fetchDataset(user, datasetName, optEtag).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.runMongo(user, filterFn, ds, strict);
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.runETL(user, filterFn, ds, strict);
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return this.runCached(user, filterFn, ds, strict);
                }
            }
            if (either instanceof Left) {
                Builder.Response response = (Builder.Response)((Left)either).value();
                return Task$.MODULE$.apply(() -> BuildAll.run$$anonfun$2$$anonfun$1(response));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Builder.Response> runETL(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ETLDataset ds, boolean strict) {
        return ((Observable)filterFn.apply((Object)ds)).toListL().flatMap((Function1 & Serializable)userFilters -> {
            List<BsonDocument> steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)userFilters, JsonParams$.MODULE$.Empty());
            this.log().info(() -> BuildAll.runETL$$anonfun$1$$anonfun$1(steps), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runETL"));
            if (steps.isEmpty()) {
                return this.runETLChain(user, ds);
            }
            return this.runETLBatch(user, ds, steps, strict);
        });
    }

    public Task<Builder.Response> runETLChain(UserDB.User user, ETLDataset ds) {
        long start = System.currentTimeMillis();
        ETLHelper etlHelper = this.module.etlHelper();
        return etlHelper.getChainSet(user, ds.chainset()).flatMap((Function1 & Serializable)chainset -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runETLChain$$anonfun$1$$anonfun$1((ETLChainSet)chainset);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> BuildAll.runETLChain$$anonfun$1$$anonfun$2$$anonfun$1(chainset, ds)).flatMap((Function1 & Serializable)chainSpec -> etlHelper.chainAPI().runChain(user, (ChainRunner.ChainSpec)chainSpec, Observable$.MODULE$.now((Object)Document$.MODULE$.apply())).map((Function1 & Serializable)_$1 -> _$1.toJson()).toListL().map((Function1 & Serializable)list -> {
                long stop = System.currentTimeMillis();
                String json = list.mkString("[", ",\n", "]");
                this.log().info(() -> BuildAll.runETLChain$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(user, ds, stop, start), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runETLChain"));
                return Builder$JsonResponse$.MODULE$.apply(json, ds.etag());
            }).map((Function1 & Serializable)result -> result));
        }));
    }

    public Task<Builder.Response> runETLBatch(UserDB.User user, ETLDataset ds, List<BsonDocument> steps, boolean strict) {
        long start = System.currentTimeMillis();
        ETLHelper etlHelper = this.module.etlHelper();
        return etlHelper.getChainSet(user, ds.chainset()).flatMap((Function1 & Serializable)chainset -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runETLBatch$$anonfun$1$$anonfun$1((ETLChainSet)chainset);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain()), ambience.etl.package$.MODULE$.EmptyJsonObject()).flatMap((Function1 & Serializable)uuid -> Task$.MODULE$.apply(() -> this.runETLBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ds, uuid)).flatMap((Function1 & Serializable)mds -> this.runMongo((MongoDBDataset)mds, steps, strict).map((Function1 & Serializable)reply -> {
                etlHelper.dropTemp(user, (String)uuid);
                long stop = System.currentTimeMillis();
                this.log().info(() -> BuildAll.runETLBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(user, ds, stop, start), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runETLBatch"));
                return reply;
            }).map((Function1 & Serializable)result -> result)));
        }));
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, MongoDBDataset ds, boolean strict) {
        return ((Observable)filterFn.apply((Object)ds)).toListL().flatMap((Function1 & Serializable)userFilters -> {
            List<BsonDocument> steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)userFilters, JsonParams$.MODULE$.Empty());
            return this.runMongo(ds, steps, strict);
        });
    }

    public Task<Builder.Response> runMongo(MongoDBDataset ds, List<BsonDocument> steps, boolean strict) {
        Option option = this.module.databaseMap().get((Object)ds.database());
        if (option instanceof Some) {
            MongoDatabase database = (MongoDatabase)((Some)option).value();
            return this.runMongo(ds, steps, database, strict);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(() -> BuildAll.runMongo$$anonfun$2(ds), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runMongo"));
            return Task$.MODULE$.now((Object)Builder$NotFound$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Task<Builder.Response> runMongo(MongoDBDataset ds, List<BsonDocument> steps, MongoDatabase database, boolean strict) {
        RichMongoCollection cltn = new RichMongoCollection(database.getCollection(ds.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return this.runMongo((Dataset)ds, steps, cltn, strict);
    }

    public Task<Builder.Response> runMongo(Dataset ds, List<BsonDocument> steps, RichMongoCollection cltn, boolean strict) {
        long start = System.currentTimeMillis();
        return cltn.aggregateO(steps).map((Function1 & Serializable)doc -> DatasetsModule$.MODULE$.bsonToJsonString(strict, (Document)doc)).toListL().map((Function1 & Serializable)reply -> {
            Builder.JsonResponse response = Builder$JsonResponse$.MODULE$.apply(reply.mkString("[", ",\n", "]"), ds.etag());
            long stop = System.currentTimeMillis();
            this.log().info(() -> BuildAll.runMongo$$anonfun$4$$anonfun$1(ds, stop, start), Line$.MODULE$.apply(102), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runMongo"));
            return response;
        });
    }

    public Task<Builder.Response> runCached(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, CachedDataset ds, boolean strict) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonObjectId$.MODULE$.apply(ds.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        List baseSteps = CachedHelper$.MODULE$.BaseSteps().$colon$colon((Object)bsonDocument);
        List steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)package$.MODULE$.Nil(), JsonParams$.MODULE$.Empty()).$colon$colon$colon(baseSteps);
        return this.runMongo(ds, (List<BsonDocument>)steps, Collections$.MODULE$.datasets(), strict);
    }

    private static final Object run$$anonfun$1(String datasetName$1) {
        return "buildAllRecords(" + datasetName$1 + ") starting";
    }

    private static final Builder.Response run$$anonfun$2$$anonfun$1(Builder.Response response$1) {
        return response$1;
    }

    private static final Object runETL$$anonfun$1$$anonfun$1(List steps$1) {
        return "runETL steps are: " + steps$1;
    }

    private static final Object runETLChain$$anonfun$1$$anonfun$1$$anonfun$1(ETLChainSet chainset$2) {
        return "buildAll runETLChain using chainset: " + chainset$2.name();
    }

    private final void runETLChain$$anonfun$1$$anonfun$1(ETLChainSet chainset$1) {
        this.log().info(() -> BuildAll.runETLChain$$anonfun$1$$anonfun$1$$anonfun$1(chainset$1), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runETLChain"));
    }

    private static final ChainRunner.ChainIdSpec runETLChain$$anonfun$1$$anonfun$2$$anonfun$1(ETLChainSet chainset$4, ETLDataset ds$3) {
        return ChainRunner.ChainIdSpec$.MODULE$.apply(chainset$4._id(), ds$3.chain());
    }

    private static final Object runETLChain$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(UserDB.User user$7, ETLDataset ds$7, long stop$1, long start$5) {
        return "buildAll(" + user$7.name() + "," + ds$7.chain() + ") via ETL completed. Elapsed time: " + (stop$1 - start$5) + "ms";
    }

    private static final Object runETLBatch$$anonfun$1$$anonfun$1$$anonfun$1(ETLChainSet chainset$6) {
        return "buildAll runETLBatch using chainset: " + chainset$6.name();
    }

    private final void runETLBatch$$anonfun$1$$anonfun$1(ETLChainSet chainset$5) {
        this.log().info(() -> BuildAll.runETLBatch$$anonfun$1$$anonfun$1$$anonfun$1(chainset$5), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.datasets.BuildAll.runETLBatch"));
    }

    private final MongoDBDataset runETLBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ETLDataset ds$11, String uuid$1) {
        return ds$11.toMongo(this.module.tempDatabaseName(), uuid$1);
    }

    private static final Object runETLBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$13, ETLDataset ds$14, long stop$2, long start$11) {
        return "buildAll(" + user$13.name() + "," + ds$14.chain() + ") via ETL completed. Elapsed time: " + (stop$2 - start$11) + "ms";
    }

    private static final Object runMongo$$anonfun$2(MongoDBDataset ds$16) {
        return "buildAllRecords(" + ds$16.name() + ") database " + ds$16.database() + " not found";
    }

    private static final Object runMongo$$anonfun$4$$anonfun$1(Dataset ds$18, long stop$3, long start$13) {
        return "buildAllRecords(" + ds$18.name() + ") completed. Elapsed time: " + (stop$3 - start$13) + "ms";
    }
}

