/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.Builder;
import ambience.datasets.Builder$BuildError$;
import ambience.datasets.Builder$NotFound$;
import ambience.datasets.Builder$StreamResponse$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedHelper$;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.ExcludeHiddenFields$;
import ambience.datasets.ExportBuilder;
import ambience.datasets.ExportCSV;
import ambience.datasets.ExportColumn;
import ambience.datasets.ExportRequest;
import ambience.datasets.ExportXLSX;
import ambience.datasets.FilterManager$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.PipelinePreprocessor$;
import ambience.datasets.UserLookup$;
import ambience.etl.ETLChainSet;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.coredata.Data;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Aggregates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BuildExport
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BuildExport.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;

    public BuildExport(DatasetsModule module) {
        this.module = module;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Builder.Response> run(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request) {
        this.log().info(() -> BuildExport.run$$anonfun$1(user, request), Line$.MODULE$.apply(21), FullName$.MODULE$.apply("ambience.datasets.BuildExport.run"));
        this.log().info(() -> BuildExport.run$$anonfun$2(request), Line$.MODULE$.apply(22), FullName$.MODULE$.apply("ambience.datasets.BuildExport.run"));
        return this.module.fetchDataset(user, request.dsId(), (Option<String>)None$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.runMongo(user, filterFn, request, ds);
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.runETL(user, filterFn, request, ds);
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return this.runCached(user, filterFn, request, ds);
                }
            }
            if (either instanceof Left) {
                Builder.Response response = (Builder.Response)((Left)either).value();
                return Task$.MODULE$.apply(() -> BuildExport.run$$anonfun$3$$anonfun$1(response));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Builder.Response> runETL(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request, ETLDataset ds) {
        long start = System.currentTimeMillis();
        ETLHelper etlHelper = this.module.etlHelper();
        return etlHelper.getChainSet(user, ds.chainset()).flatMap((Function1 & Serializable)chainset -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runETL$$anonfun$1$$anonfun$1((ETLChainSet)chainset);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain()), request.stepSequence().etlInjection()).flatMap((Function1 & Serializable)uuid -> Task$.MODULE$.apply(() -> this.runETL$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ds, uuid)).flatMap((Function1 & Serializable)mds -> this.runMongo(user, filterFn, request, (MongoDBDataset)mds).map((Function1 & Serializable)reply -> {
                etlHelper.dropTemp(user, (String)uuid);
                long stop = System.currentTimeMillis();
                this.log().info(() -> BuildExport.runETL$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(user, request, stop, start), Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.datasets.BuildExport.runETL"));
                return reply;
            }).map((Function1 & Serializable)result -> result)));
        }));
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request, MongoDBDataset ds) {
        return ((Observable)filterFn.apply((Object)ds)).toListL().flatMap((Function1 & Serializable)userFilters -> {
            Option option = this.module.databaseMap().get((Object)ds.database());
            if (option instanceof Some) {
                MongoDatabase database = (MongoDatabase)((Some)option).value();
                return this.runMongo(user, filterFn, request, ds, (List<BsonDocument>)userFilters, database);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> BuildExport.runMongo$$anonfun$1$$anonfun$1(request, ds), Line$.MODULE$.apply(53), FullName$.MODULE$.apply("ambience.datasets.BuildExport.runMongo"));
                return Task$.MODULE$.now((Object)Builder$NotFound$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request, MongoDBDataset ds, List<BsonDocument> userFilters, MongoDatabase database) {
        RichMongoCollection cltn = new RichMongoCollection(database.getCollection(ds.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return this.runMongo(user, filterFn, request, (Dataset)ds, userFilters, cltn);
    }

    public Task<Builder.Response> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request, Dataset ds, List<BsonDocument> userFilters, RichMongoCollection cltn) {
        long start = System.currentTimeMillis();
        ListBuffer pipeline = new ListBuffer();
        pipeline.$plus$plus$eq(userFilters);
        if (ds.filters().nonEmpty()) {
            pipeline.$plus$eq((Object)BsonUtils$.MODULE$.toDocument(Aggregates$.MODULE$.match(FilterManager$.MODULE$.buildFilter(ds.filters()))));
        }
        pipeline.$plus$plus$eq((IterableOnce)ds.aggregation().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        pipeline.$plus$plus$eq((IterableOnce)ds.export().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        pipeline.$plus$plus$eq((IterableOnce)request.stepSequence().steps().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        ExcludeHiddenFields$.MODULE$.from(ds).foreach((Function1 & Serializable)_$1 -> (ListBuffer)pipeline.$plus$eq(_$1));
        Option<ExportBuilder> option = this.getExportBuilder(request.dsId(), MimeType$.MODULE$.apply(request.mimeType()), ds.schema(), request.columns());
        if (option instanceof Some) {
            ExportBuilder builder = (ExportBuilder)((Some)option).value();
            List<BsonDocument> steps = PipelinePreprocessor$.MODULE$.bson((List<BsonValue>)pipeline.toList(), this.lookup(user));
            return cltn.aggregateO(steps).foreachL((Function1)(JProcedure1 & Serializable)doc -> builder.add((Document)doc)).map((Function1 & Serializable)_$2 -> {
                long stop = System.currentTimeMillis();
                this.log().info(() -> BuildExport.runMongo$$anonfun$7$$anonfun$1(user, request, stop, start), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.datasets.BuildExport.runMongo"));
                Gravity.Header contentType = Gravity.Header$.MODULE$.apply("Content-Type", builder.contentType());
                Gravity.Header contentDisposition = GravityResponse.ContentDisposition$.MODULE$.attachment(this.getFilename(request));
                List headers = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType, contentDisposition}));
                return Builder$StreamResponse$.MODULE$.apply((List<Gravity.Header>)headers, builder.buildSource());
            });
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)Builder$BuildError$.MODULE$.apply("Unsupported export format"));
        }
        throw new MatchError(option);
    }

    public PartialFunction<String, Json> lookup(UserDB.User user) {
        return UserLookup$.MODULE$.apply(user).orElse(PipelinePreprocessor$.MODULE$.ConfiguredLookup());
    }

    public Task<Builder.Response> runCached(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ExportRequest request, CachedDataset ds) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonObjectId$.MODULE$.apply(ds.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        List steps = CachedHelper$.MODULE$.BaseSteps().$colon$colon((Object)bsonDocument);
        return this.runMongo(user, filterFn, request, ds, (List<BsonDocument>)steps, Collections$.MODULE$.datasets());
    }

    public String getFilename(ExportRequest request) {
        String base = (String)request.title().flatMap((Function1 & Serializable)s -> this.opts((String)s)).getOrElse(() -> BuildExport.$anonfun$2(request));
        return base + "." + MimeInfo$.MODULE$.extension(MimeType$.MODULE$.apply(request.mimeType()));
    }

    public Option<String> opts(String s) {
        String test = s.trim();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(test))) {
            return Some$.MODULE$.apply((Object)test);
        }
        return None$.MODULE$;
    }

    public Option<ExportBuilder> getExportBuilder(String datasetName, MimeType mimeType, Data.Schema schema, List<ExportColumn> cols) {
        MimeType mimeType2 = mimeType;
        MimeType mimeType3 = MimeTypes$.MODULE$.CSV();
        MimeType mimeType4 = mimeType2;
        if (!(mimeType3 != null ? !mimeType3.equals(mimeType4) : mimeType4 != null)) {
            return Some$.MODULE$.apply((Object)new ExportCSV(schema, cols));
        }
        MimeType mimeType5 = MimeTypes$.MODULE$.XLSX();
        MimeType mimeType6 = mimeType2;
        if (!(mimeType5 != null ? !mimeType5.equals(mimeType6) : mimeType6 != null)) {
            return Some$.MODULE$.apply((Object)new ExportXLSX(datasetName, schema, cols));
        }
        this.log().warn(() -> BuildExport.getExportBuilder$$anonfun$1(mimeType), Line$.MODULE$.apply(127), FullName$.MODULE$.apply("ambience.datasets.BuildExport.getExportBuilder"));
        return None$.MODULE$;
    }

    private static final Object run$$anonfun$1(UserDB.User user$1, ExportRequest request$1) {
        return "buildExport(" + user$1.name() + "," + request$1.dsId() + ") starting";
    }

    private static final Object run$$anonfun$2(ExportRequest request$2) {
        return "buildExport full request: " + request$2;
    }

    private static final Builder.Response run$$anonfun$3$$anonfun$1(Builder.Response response$1) {
        return response$1;
    }

    private static final Object runETL$$anonfun$1$$anonfun$1$$anonfun$1(ETLChainSet chainset$2) {
        return "buildExport runETL using chainset: " + chainset$2.name();
    }

    private final void runETL$$anonfun$1$$anonfun$1(ETLChainSet chainset$1) {
        this.log().info(() -> BuildExport.runETL$$anonfun$1$$anonfun$1$$anonfun$1(chainset$1), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("ambience.datasets.BuildExport.runETL"));
    }

    private final MongoDBDataset runETL$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ETLDataset ds$4, String uuid$1) {
        return ds$4.toMongo(this.module.tempDatabaseName(), uuid$1);
    }

    private static final Object runETL$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$8, ExportRequest request$9, long stop$1, long start$6) {
        return "buildExport(" + user$8.name() + "," + request$9.dsId() + ") via ETL completed. Elapsed time: " + (stop$1 - start$6) + "ms";
    }

    private static final Object runMongo$$anonfun$1$$anonfun$1(ExportRequest request$11, MongoDBDataset ds$6) {
        return "buildExport(" + request$11.dsId() + ") database " + ds$6.database() + " not found";
    }

    private static final Object runMongo$$anonfun$7$$anonfun$1(UserDB.User user$11, ExportRequest request$13, long stop$2, long start$8) {
        return "buildExport(" + user$11.name() + "," + request$13.dsId() + ") completed. Elapsed time: " + (stop$2 - start$8) + "ms";
    }

    private static final String $anonfun$2(ExportRequest request$14) {
        return request$14.dsId().replace(":", "_");
    }

    private static final Object getExportBuilder$$anonfun$1(MimeType mimeType$1) {
        return "Unsupported export format: " + mimeType$1.value();
    }
}

