/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.WorkgroupsAPI;
import ambience.api.WorkgroupsAPI$;
import ambience.datasets.Collections$;
import ambience.datasets.DSType$;
import ambience.datasets.DatasetsModule;
import ambience.framework.AuditedDocumentManager2;
import ambience.framework.DocumentManager2$;
import ambience.framework.ErrorExplanation$;
import ambience.framework.URAugment3$;
import ambience.framework.UserRoleInfo2;
import ambience.framework.UserRoleInfo2$;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.Data$;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DatasetManager
extends AuditedDocumentManager2
implements LoggingHelper2 {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DatasetManager.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DatasetManager.class.getDeclaredField("uniqueKey$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DatasetManager.class.getDeclaredField("cltn$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatasetManager.class.getDeclaredField("scheduler$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object scheduler$lzy1;
    private volatile Object cltn$lzy1;
    private volatile Object uniqueKey$lzy1;
    private final AuditAPI.AuditAppender auditAppender;
    private final AuditAPI.Component auditComponent;
    private final Function1 UnAugmenter;

    public DatasetManager(DatasetsModule module) {
        this.auditAppender = module.auditAppender();
        this.auditComponent = module.AuditComponent();
        List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Remove[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("ownerName")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("access.roleNames")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("workgroupNames"))}));
        this.UnAugmenter = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list, json);
        this.init().runToFuture(this.scheduler());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        Object object = this.scheduler$lzy1;
        if (object instanceof Scheduler) {
            return (Scheduler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Scheduler)this.scheduler$lzyINIT1();
    }

    private Object scheduler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.scheduler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Scheduler scheduler = null;
                    try {
                        scheduler = Scheduler$.MODULE$.global();
                        object2 = scheduler == null ? LazyVals.NullValue$.MODULE$ : scheduler;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scheduler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return scheduler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = Collections$.MODULE$.datasets();
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String uniqueKey() {
        Object object = this.uniqueKey$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.uniqueKey$lzyINIT1();
    }

    private Object uniqueKey$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uniqueKey$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "name";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uniqueKey$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public Function1<Json, Json> UnAugmenter() {
        return this.UnAugmenter;
    }

    public Task<Either<LogMessage, BsonObjectId>> add(UserDB.User user, BsonValue key, Document doc) {
        return super.add(user, key, doc);
    }

    public Task<Json> get(UserDB.User user) {
        Bson excludeRecords = Projections$.MODULE$.exclude((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"records"}));
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})));
        Some some2 = Some$.MODULE$.apply((Object)excludeRecords);
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$4();
        FindOptions options = FindOptions$.MODULE$.apply((Option)some2, (Option)some, option, option2);
        return UserRoleInfo2$.MODULE$.load().flatMap((Function1 & Serializable)info -> WorkgroupsAPI$.MODULE$.allInfo(user).flatMap((Function1 & Serializable)wgInfo -> this.cltn().findO(DocumentManager2$.MODULE$.exists(this.uniqueKey()), options).map((Function1 & Serializable)_$1 -> DatasetManager.augment$1(info, wgInfo, _$1).toJson()).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.mkString("[", ",", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> DatasetManager.get$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(err), Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.datasets.DatasetManager.get"));
                return Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        })));
    }

    public Task<LogMessage> save(UserDB.User user, Json json) {
        return super.save(user, (Json)this.UnAugmenter().apply((Object)json));
    }

    public Task<LogMessage> update(UserDB.User user, BsonObjectId id, BsonValue key, Document doc) {
        if (doc.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).contains((Object)DSType$.MODULE$.Cached())) {
            return this.updateCached(user, id, key, doc);
        }
        return super.update(user, id, key, doc);
    }

    public Task<LogMessage> updateCached(UserDB.User user, BsonObjectId id, BsonValue key, Document doc) {
        this.log().info(() -> DatasetManager.updateCached$$anonfun$1(key), Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.datasets.DatasetManager.updateCached"));
        Bson updates = this.buildUpdates(doc, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "enabled", "description", "aggregation", "export", "access"}))));
        Task treply = this.cltn().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)id), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), updates).map((Function1 & Serializable)_$3 -> LogMessage$None$.MODULE$).onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Update failed", ex));
        return treply.map((Function1 & Serializable)reply -> {
            Option optName = Try$.MODULE$.apply(() -> DatasetManager.$anonfun$3(key)).toOption().map((Function1 & Serializable)_$4 -> _$4.getValue());
            LogMessage logMessage = reply;
            LogMessage$None$ logMessage$None$ = LogMessage$None$.MODULE$;
            AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(logMessage != null ? !logMessage.equals(logMessage$None$) : logMessage$None$ != null), id.getValue().toHexString(), "Updated", optName, AuditAPI.Action$.MODULE$.$lessinit$greater$default$5());
            AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), this.auditComponent(), action);
            this.auditAppender().append(auditMsg);
            return reply;
        });
    }

    public Bson buildUpdates(Document doc, List<String> fields) {
        Bson bson = Updates$.MODULE$.currentDate("lastModified");
        List all = fields.flatMap((Function1 & Serializable)f -> doc.get(f, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)v -> Updates$.MODULE$.set(f, v))).$colon$colon((Object)bson);
        return Updates$.MODULE$.combine((Seq)all);
    }

    public Task<Either<LogMessage, BoxedUnit>> updateSchema(String hexId, Data.Schema schema) {
        BsonObjectId id = BsonObjectId$.MODULE$.apply(hexId);
        this.log().info(() -> DatasetManager.updateSchema$$anonfun$1(hexId), Line$.MODULE$.apply(102), FullName$.MODULE$.apply("ambience.datasets.DatasetManager.updateSchema"));
        Bson lastModifiedUpdate = Updates$.MODULE$.currentDate("lastModified");
        List fields = schema.fields().map((Function1 & Serializable)f -> {
            Data.Field field = (Data.Field)io.circe.syntax.package$.MODULE$.EncoderOps(f);
            return Document$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)field, Data$.MODULE$.encodeField()).noSpaces()).toBsonDocument();
        });
        Bson schemaUpdate = Updates$.MODULE$.set("schema", (Object)BsonArray$.MODULE$.fromIterable((Iterable)fields));
        String etag = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Bson etagUpdate = Updates$.MODULE$.set("etag", (Object)BsonString$.MODULE$.apply(etag));
        Bson updates = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{lastModifiedUpdate, etagUpdate, schemaUpdate}));
        return this.cltn().updateOneT(Filters$.MODULE$.eq("_id", (Object)id), updates).map((Function1 & Serializable)_$5 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    private static final Document augment$1(UserRoleInfo2.Info info$2, WorkgroupsAPI.Info wgInfo$1, Document doc) {
        return URAugment3$.MODULE$.apply(info$2, wgInfo$1, doc);
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object updateCached$$anonfun$1(BsonValue key$1) {
        return "updating cached " + key$1;
    }

    private static final BsonString $anonfun$3(BsonValue key$3) {
        return key$3.asString();
    }

    private static final Object updateSchema$$anonfun$1(String hexId$1) {
        return "updateSchema: " + hexId$1;
    }
}

