/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.SystemScheduler$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedDataset$;
import ambience.datasets.DSType$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLDataset$;
import ambience.datasets.ETag$;
import ambience.datasets.FilterItem;
import ambience.datasets.FilterItem$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.MongoDBDataset$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.Data$;
import com.elixirtech.mongodb.BsonTransform$;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import java.io.Serializable;
import monix.execution.Scheduler;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class DatasetsModule$
implements LoggingHelper2,
Serializable {
    private volatile Object log$lzy2;
    private static final Scheduler scheduler;
    private static final JsonWriterSettings mongoJsonWriterSettings;
    private static final JsonWriterSettings StrictJsonWriterSettings;
    public static final DatasetsModule$ MODULE$;

    private DatasetsModule$() {
    }

    static {
        MODULE$ = new DatasetsModule$();
        scheduler = SystemScheduler$.MODULE$.global();
        mongoJsonWriterSettings = JsonWriterSettings.builder().int64Converter((value, writer) -> writer.writeNumber(value.toString())).decimal128Converter((value, writer) -> writer.writeNumber(BoxesRunTime.boxToDouble((double)value.doubleValue()).toString())).dateTimeConverter((value, writer) -> {
            writer.writeStartObject();
            writer.writeNumber("$date", value.toString());
            writer.writeEndObject();
        }).build();
        StrictJsonWriterSettings = JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).build();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy2;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT2();
    }

    private Object log$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, DatasetsModule.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, DatasetsModule.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, DatasetsModule.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, DatasetsModule.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DatasetsModule$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public JsonWriterSettings mongoJsonWriterSettings() {
        return mongoJsonWriterSettings;
    }

    public JsonWriterSettings StrictJsonWriterSettings() {
        return StrictJsonWriterSettings;
    }

    public String bsonToJson(Document document) {
        return document.toJson(this.mongoJsonWriterSettings());
    }

    public Json bsonToJsonObj(BsonValue document) {
        return BsonTransform$.MODULE$.toJson(document);
    }

    public String bsonToStrictJson(Document document) {
        return document.toJson(this.StrictJsonWriterSettings());
    }

    public String bsonToJsonString(boolean strict, Document doc) {
        if (strict) {
            return this.bsonToStrictJson(doc);
        }
        return this.bsonToJson(doc);
    }

    public Option<Dataset> toDataset(Document doc) {
        Option option = doc.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue());
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            String string2 = DSType$.MODULE$.MongoDB();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return this.toMongoDBDataset(doc);
            }
            String string4 = DSType$.MODULE$.ETL();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return this.toETLDataset(doc);
            }
            String string6 = DSType$.MODULE$.Cached();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return this.toCachedDataset(doc);
            }
        }
        return None$.MODULE$;
    }

    public Option<MongoDBDataset> toMongoDBDataset(Document doc) {
        return Some$.MODULE$.apply((Object)((BsonObjectId)doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).getOrElse(this::toMongoDBDataset$$anonfun$1)).getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).flatMap((Function1 & Serializable)description -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).flatMap((Function1 & Serializable)enabled -> this.toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(doc, (String)id, (String)name, (String)description, BoxesRunTime.unboxToBoolean((Object)enabled))))));
    }

    public Option<ETLDataset> toETLDataset(Document doc) {
        return Some$.MODULE$.apply((Object)((BsonObjectId)doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).getOrElse(this::toETLDataset$$anonfun$1)).getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$10 -> _$10.getValue()).flatMap((Function1 & Serializable)description -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$11 -> _$11.getValue()).flatMap((Function1 & Serializable)enabled -> this.toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(doc, (String)id, (String)name, (String)description, BoxesRunTime.unboxToBoolean((Object)enabled))))));
    }

    public Option<CachedDataset> toCachedDataset(Document doc) {
        return Some$.MODULE$.apply((Object)((BsonObjectId)doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).getOrElse(this::toCachedDataset$$anonfun$1)).getValue().toHexString()).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$15 -> _$15.getValue()).flatMap((Function1 & Serializable)name -> doc.get("description", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$16 -> _$16.getValue()).flatMap((Function1 & Serializable)description -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$17 -> _$17.getValue()).flatMap((Function1 & Serializable)enabled -> this.toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(doc, (String)id, (String)name, (String)description, BoxesRunTime.unboxToBoolean((Object)enabled))))));
    }

    public List<Json> buildAggregation(BsonString json) {
        String agg = json.getValue().trim();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(agg))) {
            Either either = io.circe.parser.package$.MODULE$.decode(json.getValue(), Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeJson()));
            if (either instanceof Right) {
                List listJson = (List)((Right)either).value();
                return listJson;
            }
            if (either instanceof Left) {
                Error msg = (Error)((Left)either).value();
                this.log().warn(() -> this.buildAggregation$$anonfun$1(json, msg), Line$.MODULE$.apply(136), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.buildAggregation"));
                return package$.MODULE$.Nil();
            }
            throw new MatchError((Object)either);
        }
        return package$.MODULE$.Nil();
    }

    public Option<FilterItem> buildFilter(BsonValue bv) {
        None$ optDoc = bv.isDocument() ? Some$.MODULE$.apply((Object)Document$.MODULE$.apply(bv.asDocument())) : None$.MODULE$;
        return optDoc.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$20 -> _$20.getValue()).flatMap((Function1 & Serializable)name -> doc.get("op", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$21 -> _$21.getValue()).flatMap((Function1 & Serializable)op -> doc.get("dataType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$22 -> _$22.getValue()).flatMap((Function1 & Serializable)dataType -> doc.get("value", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$23 -> _$23.getValue()).map((Function1 & Serializable)value -> FilterItem$.MODULE$.apply(name, op, dataType, value))))));
    }

    public Option<Data.Field> buildSchemaItem(BsonValue bv) {
        None$ optDoc = bv.isDocument() ? Some$.MODULE$.apply((Object)Document$.MODULE$.apply(bv.asDocument())) : None$.MODULE$;
        return optDoc.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$24 -> _$24.getValue()).flatMap((Function1 & Serializable)name -> doc.get("dataType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$25 -> _$25.getValue()).map((Function1 & Serializable)id -> Data$.MODULE$.fromId(id)).flatMap((Function1 & Serializable)dataType -> doc.get("properties", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).flatMap((Function1 & Serializable)bv -> this.buildFieldProperties((BsonValue)bv)).map((Function1 & Serializable)properties -> Data.Field$.MODULE$.apply(name, dataType, properties)))));
    }

    public Option<Data.FieldProperties> buildFieldProperties(BsonValue bv) {
        return io.circe.parser.package$.MODULE$.decode(this.bsonToJson(Document$.MODULE$.apply(bv.asDocument())), Data$.MODULE$.decodeFieldProperties()).toOption();
    }

    private final BsonObjectId toMongoDBDataset$$anonfun$1() {
        return BsonObjectId$.MODULE$.apply();
    }

    private final List toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final List toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final String toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ Option toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(Document doc$4, String id$3, String name$5, String description$1, boolean enabled) {
        return doc$4.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).flatMap((Function1 & Serializable)datasetType -> doc$4.get("database", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()).flatMap((Function1 & Serializable)database -> doc$4.get("collection", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue()).flatMap((Function1 & Serializable)collection -> Some$.MODULE$.apply((Object)doc$4.get("etag", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)s -> ETag$.MODULE$.apply(s.getValue()))).flatMap((Function1 & Serializable)etag -> doc$4.get("filters", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildFilter((BsonValue)bv))).toList()).flatMap((Function1 & Serializable)filters -> Some$.MODULE$.apply(doc$4.get("aggregation", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)aggregation -> Some$.MODULE$.apply(doc$4.get("export", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)exportValue -> Some$.MODULE$.apply(doc$4.get("rowSecurity", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$8 -> _$8.getValue()).getOrElse(this::toMongoDBDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)rowSecurity -> doc$4.get("schema", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> Data.Schema$.MODULE$.apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildSchemaItem((BsonValue)bv))).toList())).map((Function1 & Serializable)schema -> MongoDBDataset$.MODULE$.apply(id$3, name$5, description$1, enabled, (String)datasetType, (String)database, (String)collection, (Option<String>)etag, (List<FilterItem>)filters, (List<Json>)aggregation, (List<Json>)exportValue, (String)rowSecurity, (Data.Schema)schema))))))))));
    }

    private final BsonObjectId toETLDataset$$anonfun$1() {
        return BsonObjectId$.MODULE$.apply();
    }

    private final List toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final List toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ Option toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(Document doc$16, String id$15, String name$16, String description$11, boolean enabled) {
        return doc$16.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$12 -> _$12.getValue()).flatMap((Function1 & Serializable)datasetType -> doc$16.get("chainset", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$13 -> _$13.getValue()).flatMap((Function1 & Serializable)chainset -> doc$16.get("chain", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$14 -> _$14.getValue()).flatMap((Function1 & Serializable)chain -> Some$.MODULE$.apply((Object)doc$16.get("etag", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)s -> ETag$.MODULE$.apply(s.getValue()))).flatMap((Function1 & Serializable)etag -> doc$16.get("filters", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildFilter((BsonValue)bv))).toList()).flatMap((Function1 & Serializable)filters -> Some$.MODULE$.apply(doc$16.get("aggregation", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)aggregation -> Some$.MODULE$.apply(doc$16.get("export", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toETLDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)exportValue -> doc$16.get("schema", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> Data.Schema$.MODULE$.apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildSchemaItem((BsonValue)bv))).toList())).map((Function1 & Serializable)schema -> ETLDataset$.MODULE$.apply(id$15, name$16, description$11, enabled, (String)datasetType, (String)chainset, (String)chain, (Option<String>)etag, (List<FilterItem>)filters, (List<Json>)aggregation, (List<Json>)exportValue, (Data.Schema)schema)))))))));
    }

    private final BsonObjectId toCachedDataset$$anonfun$1() {
        return BsonObjectId$.MODULE$.apply();
    }

    private final int toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return 0;
    }

    private final List toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final List toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ Option toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3(Document doc$29, String id$28, String name$28, String description$22, boolean enabled$19, String datasetType$16, int recordCount) {
        return Some$.MODULE$.apply((Object)doc$29.get("etag", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)s -> ETag$.MODULE$.apply(s.getValue()))).flatMap((Function1 & Serializable)etag -> doc$29.get("filters", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildFilter((BsonValue)bv))).toList()).flatMap((Function1 & Serializable)filters -> Some$.MODULE$.apply(doc$29.get("aggregation", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)aggregation -> Some$.MODULE$.apply(doc$29.get("export", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)json -> this.buildAggregation((BsonString)json)).getOrElse(this::toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)exportValue -> doc$29.get("schema", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)array -> Data.Schema$.MODULE$.apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.buildSchemaItem((BsonValue)bv))).toList())).map((Function1 & Serializable)schema -> CachedDataset$.MODULE$.apply(id$28, name$28, description$22, enabled$19, datasetType$16, recordCount, (Option<String>)etag, (List<FilterItem>)filters, (List<Json>)aggregation, (List<Json>)exportValue, (Data.Schema)schema))))));
    }

    private final /* synthetic */ Option toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(Document doc$27, String id$26, String name$26, String description$20, boolean enabled) {
        return doc$27.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$18 -> _$18.getValue()).flatMap((Function1 & Serializable)datasetType -> Some$.MODULE$.apply(doc$27.get("recordCount", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)_$19 -> _$19.getValue()).getOrElse(this::toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)recordCount -> this.toCachedDataset$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3(doc$27, id$26, name$26, description$20, enabled, (String)datasetType, BoxesRunTime.unboxToInt((Object)recordCount))));
    }

    private final Object buildAggregation$$anonfun$1(BsonString json$3, Error msg$1) {
        return "Can't parse aggregation: " + json$3.getValue() + ": " + msg$1;
    }
}

