/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.SystemScheduler$;
import ambience.api.ChainRunner;
import ambience.api.Datasets;
import ambience.datasets.ArtifactSupplier$;
import ambience.datasets.AuthRoute;
import ambience.datasets.BuildAggregate;
import ambience.datasets.BuildAll;
import ambience.datasets.BuildExport;
import ambience.datasets.Builder;
import ambience.datasets.Builder$BuildError$;
import ambience.datasets.Builder$NotFound$;
import ambience.datasets.Builder$NotModified$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CommonRoute;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetAccessFilter$;
import ambience.datasets.DatasetManager;
import ambience.datasets.DatasetRoute;
import ambience.datasets.DatasetsAPI;
import ambience.datasets.DatasetsModule$;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.ETag;
import ambience.datasets.ETagManager;
import ambience.datasets.ExportRequest;
import ambience.datasets.FilterDatasetByUser;
import ambience.datasets.FilterDatasetByUser$;
import ambience.datasets.FilterItem;
import ambience.datasets.InferETLSchema;
import ambience.datasets.InferSchema$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.ObserveAll;
import ambience.datasets.StepSequence$;
import ambience.datasets.UploadHandler;
import ambience.datasets.WorkgroupSupport;
import ambience.framework.MongoDBConnectionPool$;
import ambience.module.Module;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoDatabase;
import com.elixirtech.webserver.WebReply;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DatasetsModule
implements Module,
LoggingHelper2 {
    public static final long OFFSET$12 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$11 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("databaseMap$lzy1"));
    public static final long OFFSET$10 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$9 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("authRoute$lzy1"));
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("commonRoute$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("etlHelper$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("chainAPI$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("filterDatasetByUser$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("uploadHandler$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("etagManager$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("docRoute$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("datasetManager$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule.class.getDeclaredField("AuditComponent$lzy1"));
    private volatile Object log$lzy1;
    private final ProjectConfig projectConfig;
    private final AuditAPI.AuditAppender auditAppender;
    private final WebReply webReply;
    private final Clock clock;
    private final MongoDB mongoDB;
    private final String id;
    private final String name;
    private final String url;
    private final DatasetsAPI datasetsAPI;
    private final Scheduler scheduler;
    private volatile Object AuditComponent$lzy1;
    private volatile Object datasetManager$lzy1;
    private volatile Object docRoute$lzy1;
    private volatile Object etagManager$lzy1;
    private volatile Object uploadHandler$lzy1;
    private volatile Object filterDatasetByUser$lzy1;
    private final WorkgroupSupport workgroupSupport;
    private volatile Object chainAPI$lzy1;
    private volatile Object etlHelper$lzy1;
    private volatile Object commonRoute$lzy1;
    private volatile Object authRoute$lzy1;
    private volatile Object route$lzy1;
    private final List datasetsDbNames;
    private final int DefaultLimit;
    private final int ChoicesLimit;
    private final int MaxStringLength;
    private final boolean HardenedMapping;
    private final String tempDatabaseName;
    private volatile Object databaseMap$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DatasetsModule$.class.getDeclaredField("log$lzy2"));

    public static JsonWriterSettings StrictJsonWriterSettings() {
        return DatasetsModule$.MODULE$.StrictJsonWriterSettings();
    }

    public static String bsonToJson(Document document) {
        return DatasetsModule$.MODULE$.bsonToJson(document);
    }

    public static Json bsonToJsonObj(BsonValue bsonValue) {
        return DatasetsModule$.MODULE$.bsonToJsonObj(bsonValue);
    }

    public static String bsonToJsonString(boolean bl, Document document) {
        return DatasetsModule$.MODULE$.bsonToJsonString(bl, document);
    }

    public static String bsonToStrictJson(Document document) {
        return DatasetsModule$.MODULE$.bsonToStrictJson(document);
    }

    public static List<Json> buildAggregation(BsonString bsonString) {
        return DatasetsModule$.MODULE$.buildAggregation(bsonString);
    }

    public static Option<Data.FieldProperties> buildFieldProperties(BsonValue bsonValue) {
        return DatasetsModule$.MODULE$.buildFieldProperties(bsonValue);
    }

    public static Option<FilterItem> buildFilter(BsonValue bsonValue) {
        return DatasetsModule$.MODULE$.buildFilter(bsonValue);
    }

    public static Option<Data.Field> buildSchemaItem(BsonValue bsonValue) {
        return DatasetsModule$.MODULE$.buildSchemaItem(bsonValue);
    }

    public static JsonWriterSettings mongoJsonWriterSettings() {
        return DatasetsModule$.MODULE$.mongoJsonWriterSettings();
    }

    public static Option<CachedDataset> toCachedDataset(Document document) {
        return DatasetsModule$.MODULE$.toCachedDataset(document);
    }

    public static Option<Dataset> toDataset(Document document) {
        return DatasetsModule$.MODULE$.toDataset(document);
    }

    public static Option<ETLDataset> toETLDataset(Document document) {
        return DatasetsModule$.MODULE$.toETLDataset(document);
    }

    public static Option<MongoDBDataset> toMongoDBDataset(Document document) {
        return DatasetsModule$.MODULE$.toMongoDBDataset(document);
    }

    public DatasetsModule(ProjectConfig projectConfig, AuditAPI.AuditAppender auditAppender, WebReply webReply, Clock clock, MongoDB mongoDB) {
        this.projectConfig = projectConfig;
        this.auditAppender = auditAppender;
        this.webReply = webReply;
        this.clock = clock;
        this.mongoDB = mongoDB;
        this.id = "datasets";
        this.name = "Datasets";
        this.url = this.id() + "/index.html";
        this.datasetsAPI = new DatasetsAPI(this);
        Elixir$.MODULE$.registerInstance((Object)this, ClassTag$.MODULE$.apply(DatasetsModule.class));
        Elixir$.MODULE$.registerInstance((Object)this.datasetsAPI(), ClassTag$.MODULE$.apply(Datasets.class));
        this.scheduler = SystemScheduler$.MODULE$.global();
        this.workgroupSupport = new WorkgroupSupport(this);
        ArtifactSupplier$.MODULE$.register();
        this.datasetsDbNames = CollectionConverters$.MODULE$.ListHasAsScala(mongoDB.sysConfig().config().getStringList("ambience.datasets.databases")).asScala().toList();
        this.DefaultLimit = mongoDB.sysConfig().config().getInt("ambience.datasets.analysis.limit");
        this.ChoicesLimit = mongoDB.sysConfig().config().getInt("ambience.datasets.choices.limit");
        this.MaxStringLength = mongoDB.sysConfig().config().getInt("ambience.datasets.choices.max-string-length");
        this.HardenedMapping = mongoDB.sysConfig().config().getBoolean("ambience.datasets.hardened-database-mapping");
        this.tempDatabaseName = mongoDB.temp().name();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ProjectConfig projectConfig() {
        return this.projectConfig;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public WebReply webReply() {
        return this.webReply;
    }

    public Clock clock() {
        return this.clock;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public DatasetsAPI datasetsAPI() {
        return this.datasetsAPI;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public AuditAPI.Component AuditComponent() {
        Object object = this.AuditComponent$lzy1;
        if (object instanceof AuditAPI.Component) {
            return (AuditAPI.Component)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.Component)this.AuditComponent$lzyINIT1();
    }

    private Object AuditComponent$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.AuditComponent$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.Component component = null;
                    try {
                        component = AuditAPI.Component$.MODULE$.apply(this.id(), "main");
                        object2 = component == null ? LazyVals.NullValue$.MODULE$ : component;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.AuditComponent$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return component;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DatasetManager datasetManager() {
        Object object = this.datasetManager$lzy1;
        if (object instanceof DatasetManager) {
            return (DatasetManager)((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DatasetManager)((Object)this.datasetManager$lzyINIT1());
    }

    private Object datasetManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.datasetManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DatasetManager datasetManager = null;
                    try {
                        datasetManager = new DatasetManager(this);
                        object2 = datasetManager == null ? LazyVals.NullValue$.MODULE$ : datasetManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.datasetManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return datasetManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DatasetRoute docRoute() {
        Object object = this.docRoute$lzy1;
        if (object instanceof DatasetRoute) {
            return (DatasetRoute)((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DatasetRoute)((Object)this.docRoute$lzyINIT1());
    }

    private Object docRoute$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.docRoute$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DatasetRoute datasetRoute = null;
                    try {
                        datasetRoute = new DatasetRoute(this.datasetManager());
                        object2 = datasetRoute == null ? LazyVals.NullValue$.MODULE$ : datasetRoute;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.docRoute$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return datasetRoute;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ETagManager etagManager() {
        Object object = this.etagManager$lzy1;
        if (object instanceof ETagManager) {
            return (ETagManager)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ETagManager)this.etagManager$lzyINIT1();
    }

    private Object etagManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.etagManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ETagManager eTagManager = null;
                    try {
                        eTagManager = new ETagManager(this);
                        object2 = eTagManager == null ? LazyVals.NullValue$.MODULE$ : eTagManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.etagManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return eTagManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UploadHandler uploadHandler() {
        Object object = this.uploadHandler$lzy1;
        if (object instanceof UploadHandler) {
            return (UploadHandler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UploadHandler)this.uploadHandler$lzyINIT1();
    }

    private Object uploadHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uploadHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UploadHandler uploadHandler = null;
                    try {
                        uploadHandler = new UploadHandler(this);
                        object2 = uploadHandler == null ? LazyVals.NullValue$.MODULE$ : uploadHandler;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uploadHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uploadHandler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FilterDatasetByUser filterDatasetByUser() {
        Object object = this.filterDatasetByUser$lzy1;
        if (object instanceof FilterDatasetByUser) {
            return (FilterDatasetByUser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FilterDatasetByUser)this.filterDatasetByUser$lzyINIT1();
    }

    private Object filterDatasetByUser$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.filterDatasetByUser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FilterDatasetByUser filterDatasetByUser = null;
                    try {
                        FilterDatasetByUser ret = (FilterDatasetByUser)Try$.MODULE$.apply(DatasetsModule::$anonfun$1).getOrElse(DatasetsModule::$anonfun$2);
                        this.log().info(() -> DatasetsModule.filterDatasetByUser$lzyINIT1$$anonfun$1(ret), Line$.MODULE$.apply(198), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.filterDatasetByUser"));
                        filterDatasetByUser = ret;
                        object2 = filterDatasetByUser == null ? LazyVals.NullValue$.MODULE$ : filterDatasetByUser;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.filterDatasetByUser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.filterDatasetByUser$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return filterDatasetByUser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public WorkgroupSupport workgroupSupport() {
        return this.workgroupSupport;
    }

    public ChainRunner chainAPI() {
        Object object = this.chainAPI$lzy1;
        if (object instanceof ChainRunner) {
            return (ChainRunner)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChainRunner)this.chainAPI$lzyINIT1();
    }

    private Object chainAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.chainAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChainRunner chainRunner = null;
                    try {
                        chainRunner = (ChainRunner)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ChainRunner.class));
                        object2 = chainRunner == null ? LazyVals.NullValue$.MODULE$ : chainRunner;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chainAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chainRunner;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ETLHelper etlHelper() {
        Object object = this.etlHelper$lzy1;
        if (object instanceof ETLHelper) {
            return (ETLHelper)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ETLHelper)this.etlHelper$lzyINIT1();
    }

    private Object etlHelper$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.etlHelper$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ETLHelper eTLHelper = null;
                    try {
                        eTLHelper = new ETLHelper(this, this.chainAPI(), this.mongoDB());
                        object2 = eTLHelper == null ? LazyVals.NullValue$.MODULE$ : eTLHelper;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.etlHelper$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return eTLHelper;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CommonRoute commonRoute() {
        Object object = this.commonRoute$lzy1;
        if (object instanceof CommonRoute) {
            return (CommonRoute)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CommonRoute)this.commonRoute$lzyINIT1();
    }

    private Object commonRoute$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.commonRoute$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CommonRoute commonRoute = null;
                    try {
                        commonRoute = new CommonRoute(this);
                        object2 = commonRoute == null ? LazyVals.NullValue$.MODULE$ : commonRoute;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.commonRoute$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return commonRoute;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuthRoute authRoute() {
        Object object = this.authRoute$lzy1;
        if (object instanceof AuthRoute) {
            return (AuthRoute)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuthRoute)this.authRoute$lzyINIT1();
    }

    private Object authRoute$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.authRoute$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuthRoute authRoute = null;
                    try {
                        authRoute = new AuthRoute(this);
                        object2 = authRoute == null ? LazyVals.NullValue$.MODULE$ : authRoute;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.authRoute$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return authRoute;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        Function1 docRouteHandler = RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> GravitySystem$.MODULE$.fromRoutes(this.docRoute().routes((UserDB.User)user), GravitySystem$.MODULE$.fromRoutes$default$2()));
                        List<GravityRoute> list = this.authRoute().routes();
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.commonRoute().routes().$colon$colon$colon(list), docRouteHandler);
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<String> datasetsDbNames() {
        return this.datasetsDbNames;
    }

    public int DefaultLimit() {
        return this.DefaultLimit;
    }

    public int ChoicesLimit() {
        return this.ChoicesLimit;
    }

    public int MaxStringLength() {
        return this.MaxStringLength;
    }

    public boolean HardenedMapping() {
        return this.HardenedMapping;
    }

    public String tempDatabaseName() {
        return this.tempDatabaseName;
    }

    public Map<String, MongoDatabase> databaseMap() {
        Object object = this.databaseMap$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.databaseMap$lzyINIT1();
    }

    private Object databaseMap$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.databaseMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.tempDatabaseName());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.mongoDB().temp());
                        map = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)this.datasetsDbNames().flatMap((Function1 & Serializable)name -> {
                            Option option = MongoDBConnectionPool$.MODULE$.getPool(name);
                            if (option instanceof Some) {
                                MongoDatabase db = (MongoDatabase)((Some)option).value();
                                String string = (String)Predef$.MODULE$.ArrowAssoc(name);
                                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)db));
                            }
                            if (None$.MODULE$.equals(option)) {
                                if (this.HardenedMapping()) {
                                    return None$.MODULE$;
                                }
                                this.log().warn(() -> DatasetsModule.databaseMap$lzyINIT1$$anonfun$1$$anonfun$1(name), Line$.MODULE$.apply(231), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.databaseMap"));
                                String string = (String)Predef$.MODULE$.ArrowAssoc(name);
                                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.mongoDB().mongoClient().getDatabase(name)));
                            }
                            throw new MatchError((Object)option);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.databaseMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.databaseMap$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<Dataset, Observable<BsonDocument>> filterDatasetFn(UserDB.User user) {
        return (Function1 & Serializable)ds -> this.filterDatasetByUser().getFilter(user, (Dataset)ds);
    }

    public Task<GravityResponse> buildCollectionNames() {
        Observable pairs = Observable$.MODULE$.fromIterable((Iterable)this.databaseMap().$minus((Object)this.tempDatabaseName())).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                MongoDatabase db = (MongoDatabase)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                MongoDatabase db = (MongoDatabase)tuple2._2();
                return new RichMongoDatabase(db).listCollectionNamesO().map((Function1 & Serializable)cs -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, cs);
                }).onErrorRecoverWith((PartialFunction)new Serializable(name, this){
                    private final String name$3;
                    private final /* synthetic */ DatasetsModule $outer;
                    {
                        this.name$3 = name$39;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable ex = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable ex = throwable = x;
                        this.$outer.log().warn(() -> this.applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(245), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.pairs"));
                        return Observable$.MODULE$.empty();
                    }

                    private final Object applyOrElse$$anonfun$1(Throwable ex$1) {
                        return "Cannot read collections for " + this.name$3 + ": " + ex$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                    }
                }).map((Function1 & Serializable)pairs -> pairs);
            }
            throw new MatchError((Object)tuple2);
        });
        return pairs.toListL().map((Function1 & Serializable)_$26 -> _$26.groupBy((Function1 & Serializable)_$27 -> (String)_$27._1())).map((Function1 & Serializable)kvs -> (Map)kvs.map((Function1 & Serializable)kv -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((List)kv._2()).map((Function1 & Serializable)_$28 -> (String)_$28._2()));
        })).map((Function1 & Serializable)m -> {
            Map map = (Map)package$.MODULE$.EncoderOps(m);
            return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)map, (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString()))));
        });
    }

    public Task<GravityResponse> buildRecords(UserDB.User user, String datasetName, Option<String> optEtag) {
        BuildAll buildAll = new BuildAll(this);
        return buildAll.run(user, this.filterDatasetFn(user), datasetName, optEtag, false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
    }

    public Task<GravityResponse> buildRecordsStrict(UserDB.User user, String datasetName, Option<String> optEtag) {
        BuildAll buildAll = new BuildAll(this);
        return buildAll.run(user, this.filterDatasetFn(user), datasetName, optEtag, true).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
    }

    public Task<GravityResponse> buildRecords(UserDB.User user, String datasetName, Json params) {
        return Task$.MODULE$.apply(() -> this.buildRecords$$anonfun$2(user, datasetName, params));
    }

    public Task<GravityResponse> buildRecordsStrict(UserDB.User user, String datasetName, Json params) {
        return Task$.MODULE$.apply(() -> this.buildRecordsStrict$$anonfun$2(user, datasetName, params));
    }

    public Task<GravityResponse> buildAggregate(UserDB.User user, String datasetName, Json json) {
        BuildAggregate buildAggregate = new BuildAggregate(this);
        return buildAggregate.run(user, this.filterDatasetFn(user), datasetName, json, false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
    }

    public Task<GravityResponse> buildAggregateStrict(UserDB.User user, String datasetName, Json json) {
        BuildAggregate buildAggregate = new BuildAggregate(this);
        return buildAggregate.run(user, this.filterDatasetFn(user), datasetName, json, true).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
    }

    public Task<GravityResponse> testAggregate(UserDB.User user, Json json) {
        Option<Dataset> option = DatasetsModule$.MODULE$.toDataset(Document$.MODULE$.apply(json.noSpaces()));
        if (option instanceof Some) {
            Dataset dataset = (Dataset)((Some)option).value();
            if (dataset instanceof MongoDBDataset) {
                MongoDBDataset dataset2 = (MongoDBDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                return buildAggregate.runMongo(user, this.filterDatasetFn(user), dataset2, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), StepSequence$.MODULE$.$lessinit$greater$default$2()), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
            if (dataset instanceof ETLDataset) {
                ETLDataset dataset3 = (ETLDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                return buildAggregate.runETL(user, this.filterDatasetFn(user), dataset3, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), StepSequence$.MODULE$.$lessinit$greater$default$2()), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
            if (dataset instanceof CachedDataset) {
                CachedDataset dataset4 = (CachedDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                return buildAggregate.runCached(user, this.filterDatasetFn(user), dataset4, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), StepSequence$.MODULE$.$lessinit$greater$default$2()), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warn(() -> DatasetsModule.testAggregate$$anonfun$4(json), Line$.MODULE$.apply(293), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.testAggregate"));
            return Task$.MODULE$.now((Object)this.toGravityResponse(Builder$BuildError$.MODULE$.apply("Can't parse Dataset")));
        }
        throw new MatchError(option);
    }

    public Task<GravityResponse> testExport(UserDB.User user, Json json) {
        Option<Dataset> option = DatasetsModule$.MODULE$.toDataset(Document$.MODULE$.apply(json.noSpaces()));
        if (option instanceof Some) {
            Dataset dataset = (Dataset)((Some)option).value();
            if (dataset instanceof MongoDBDataset) {
                MongoDBDataset dataset2 = (MongoDBDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                Vector exportSteps = dataset2.export().toVector();
                return buildAggregate.runMongo(user, this.filterDatasetFn(user), dataset2, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), (Vector<Json>)exportSteps), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
            if (dataset instanceof ETLDataset) {
                ETLDataset dataset3 = (ETLDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                Vector exportSteps = dataset3.export().toVector();
                return buildAggregate.runETL(user, this.filterDatasetFn(user), dataset3, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), (Vector<Json>)exportSteps), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
            if (dataset instanceof CachedDataset) {
                CachedDataset dataset4 = (CachedDataset)dataset;
                BuildAggregate buildAggregate = new BuildAggregate(this);
                Vector exportSteps = dataset4.export().toVector();
                return buildAggregate.runCached(user, this.filterDatasetFn(user), dataset4, StepSequence$.MODULE$.apply(StepSequence$.MODULE$.$lessinit$greater$default$1(), (Vector<Json>)exportSteps), false).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warn(() -> DatasetsModule.testExport$$anonfun$4(json), Line$.MODULE$.apply(319), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.testExport"));
            return Task$.MODULE$.now((Object)this.toGravityResponse(Builder$BuildError$.MODULE$.apply("Can't parse Dataset")));
        }
        throw new MatchError(option);
    }

    public Task<GravityResponse> buildExport(UserDB.User user, ExportRequest request) {
        BuildExport buildExport = new BuildExport(this);
        return buildExport.run(user, this.filterDatasetFn(user), request).map((Function1 & Serializable)r -> this.toGravityResponse((Builder.Response)r));
    }

    public Task<Either<Builder.Response, Dataset>> fetchDataset(UserDB.User user, String datasetName, Option<String> optEtag) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)datasetName), Filters$.MODULE$.eq("enabled", (Object)BoxesRunTime.boxToBoolean((boolean)true))})));
        Bson excludeRecords = Projections$.MODULE$.exclude((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"records"}));
        return this.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)excludeRecords), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4())).toListL().map((Function1 & Serializable)docs -> {
            Option option = docs.headOption();
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option<Dataset> option2 = DatasetsModule$.MODULE$.toDataset(doc);
                if (option2 instanceof Some) {
                    Dataset ds = (Dataset)((Some)option2).value();
                    if (ds.etag().isDefined()) {
                        Option<String> option3 = ds.etag();
                        Option option4 = optEtag;
                        if (!(option3 != null ? !option3.equals((Object)option4) : option4 != null)) {
                            return scala.package$.MODULE$.Left().apply((Object)Builder$NotModified$.MODULE$);
                        }
                    }
                    return scala.package$.MODULE$.Right().apply((Object)ds);
                }
                if (None$.MODULE$.equals(option2)) {
                    this.log().warn(() -> DatasetsModule.fetchDataset$$anonfun$1$$anonfun$1(datasetName), Line$.MODULE$.apply(340), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.fetchDataset"));
                    return scala.package$.MODULE$.Left().apply((Object)Builder$NotFound$.MODULE$);
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> DatasetsModule.fetchDataset$$anonfun$1$$anonfun$2(datasetName), Line$.MODULE$.apply(344), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.fetchDataset"));
                return scala.package$.MODULE$.Left().apply((Object)Builder$NotFound$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<GravityResponse> bumpETag(UserDB.User user, String dsId) {
        return this.etagManager().bumpETagById(user, dsId).map((Function1 & Serializable)s -> GravityResponse$.MODULE$.text(s));
    }

    public Task<GravityResponse> deleteETag(UserDB.User user, String dsId) {
        return this.etagManager().deleteETagById(user, dsId).map((Function1 & Serializable)reply -> DatasetsModule.deleteETag$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)reply)));
    }

    public Task<GravityResponse> getETag(UserDB.User user, String dsId) {
        return this.etagManager().getETagById(user, dsId).map((Function1 & Serializable)s -> GravityResponse$.MODULE$.text(s));
    }

    public Task<GravityResponse> getETagByName(UserDB.User user, String ds) {
        return this.etagManager().getETagByName(user, ds).map((Function1 & Serializable)s -> GravityResponse$.MODULE$.text(s));
    }

    public GravityResponse toGravityResponse(Builder.Response r) {
        Builder.Response response = r;
        if (response instanceof Builder.JsonResponse) {
            List list;
            Builder.JsonResponse b = (Builder.JsonResponse)response;
            Option<String> option = b.etag();
            if (option instanceof Some) {
                Object object = ((Some)option).value();
                String etag = object == null ? null : ((ETag)object).value();
                list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.apply("ETag", etag), GravityResponse$.MODULE$.Json()}));
            } else if (None$.MODULE$.equals(option)) {
                list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Json()}));
            } else {
                throw new MatchError(option);
            }
            List headers = list;
            return GravityResponse$.MODULE$.json(b.json()).withHeaders((Seq)headers);
        }
        if (response instanceof Builder.StreamResponse) {
            Builder.StreamResponse b = (Builder.StreamResponse)response;
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply(b.headers());
            DataBytes dataBytes = DataBytes$.MODULE$.apply(b.stream());
            int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
            return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
        }
        if (response instanceof Builder.BuildError) {
            Builder.BuildError b = (Builder.BuildError)response;
            return Gravity$.MODULE$.BadRequestResponse(b.msg());
        }
        if (Builder$NotFound$.MODULE$.equals(response)) {
            return Gravity$.MODULE$.NotFoundResponse();
        }
        if (Builder$NotModified$.MODULE$.equals(response)) {
            return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.NotModified(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError((Object)response);
    }

    public GravityResponse toGravityResponse(Observable<Document> from) {
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Text()}));
        DataBytes body = DataBytes$.MODULE$.apply(from.map((Function1 & Serializable)doc -> (DatasetsModule$.MODULE$.bsonToJson((Document)doc) + "\n").getBytes(Gravity$.MODULE$.UTF_8())));
        return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), headers, body);
    }

    public GravityResponse toStrictGravityResponse(Observable<Document> from) {
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Text()}));
        DataBytes body = DataBytes$.MODULE$.apply(from.map((Function1 & Serializable)doc -> (DatasetsModule$.MODULE$.bsonToStrictJson((Document)doc) + "\n").getBytes(Gravity$.MODULE$.UTF_8())));
        return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), headers, body);
    }

    public Task<Data.Schema> inferSchema(UserDB.User user, String database, String collection, List<Json> aggregation) {
        if (this.safe(aggregation)) {
            return InferSchema$.MODULE$.apply(this, user, database, collection, aggregation);
        }
        return Task$.MODULE$.now((Object)Data.Schema$.MODULE$.apply((List)scala.package$.MODULE$.Nil()));
    }

    public Task<Data.Schema> inferETLSchema(UserDB.User user, String chainSetName, String chainName, List<Json> aggregation) {
        if (this.safe(aggregation)) {
            InferETLSchema infer = new InferETLSchema(this.etlHelper());
            return infer.getSchema(user, chainSetName, chainName, aggregation);
        }
        return Task$.MODULE$.now((Object)Data.Schema$.MODULE$.apply((List)scala.package$.MODULE$.Nil()));
    }

    public boolean safe(List<Json> aggregation) {
        String text = aggregation.map((Function1 & Serializable)_$29 -> _$29.noSpaces()).mkString("\n");
        boolean usesOut = text.contains("\"$out\"");
        if (usesOut) {
            this.log().info(() -> DatasetsModule.safe$$anonfun$1(text), Line$.MODULE$.apply(412), FullName$.MODULE$.apply("ambience.datasets.DatasetsModule.safe"));
            return false;
        }
        return true;
    }

    private static final FilterDatasetByUser $anonfun$1() {
        return (FilterDatasetByUser)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(FilterDatasetByUser.class));
    }

    private static final FilterDatasetByUser $anonfun$2() {
        return FilterDatasetByUser$.MODULE$.Default();
    }

    private static final Object filterDatasetByUser$lzyINIT1$$anonfun$1(FilterDatasetByUser ret$1) {
        return "Using FilterDatasetByUser: " + ret$1.getFilterName();
    }

    private static final Object databaseMap$lzyINIT1$$anonfun$1$$anonfun$1(String name$1) {
        return "Hardened database mapping is disabled. Using direct database: " + name$1;
    }

    private final GravityResponse buildRecords$$anonfun$2(UserDB.User user$2, String datasetName$1, Json params$1) {
        ObserveAll observeAll = new ObserveAll(this);
        return this.toGravityResponse(observeAll.run(user$2, this.filterDatasetFn(user$2), datasetName$1, params$1));
    }

    private final GravityResponse buildRecordsStrict$$anonfun$2(UserDB.User user$3, String datasetName$2, Json params$2) {
        ObserveAll observeAll = new ObserveAll(this);
        return this.toStrictGravityResponse(observeAll.run(user$3, this.filterDatasetFn(user$3), datasetName$2, params$2));
    }

    private static final Object testAggregate$$anonfun$4(Json json$1) {
        return "testAggregate can't parse dataset " + json$1.spaces2();
    }

    private static final Object testExport$$anonfun$4(Json json$2) {
        return "testExport can't parse dataset " + json$2.spaces2();
    }

    private static final Object fetchDataset$$anonfun$1$$anonfun$1(String datasetName$4) {
        return "buildRecords future dataset " + datasetName$4 + " loading error";
    }

    private static final Object fetchDataset$$anonfun$1$$anonfun$2(String datasetName$5) {
        return "buildRecords future dataset " + datasetName$5 + " not found";
    }

    private static final /* synthetic */ GravityResponse deleteETag$$anonfun$1(boolean reply) {
        if (reply) {
            return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        return Gravity$.MODULE$.NotFoundResponse();
    }

    private static final Object safe$$anonfun$1(String text$1) {
        return "Unsafe aggregation uses $out: " + text$1;
    }
}

