/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.datasets.ExportBuilder;
import ambience.datasets.ExportBuilder$;
import ambience.datasets.ExportColumn;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.BsonUtils$;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;

public class ExportCSV
implements ExportBuilder {
    private final List<ExportColumn> cols;
    private final Scheduler scheduler;
    private final Path filePath;
    private final CSVPrinter writer;
    private final String contentType;

    public ExportCSV(Data.Schema schema, List<ExportColumn> cols) {
        this.cols = cols;
        this.scheduler = Scheduler$.MODULE$.global();
        this.filePath = Files.createTempFile("export", ".csv", new FileAttribute[0]);
        this.writer = new CSVPrinter((Appendable)new FileWriter(this.filePath.toFile()), CSVFormat.EXCEL);
        this.contentType = "text/csv; charset=UTF-8";
        this.writer.printRecord((Object[])((String[])Arrays$.MODULE$.seqToArray((Seq)cols.map((Function1 & Serializable)_$1 -> _$1.label()), String.class)));
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public void add(Document doc) {
        List items = this.cols.map((Function1 & Serializable)col -> (String)BsonUtils$.MODULE$.get(doc, col.field()).map((Function1 & Serializable)bv -> ExportBuilder$.MODULE$.format((BsonValue)bv)).getOrElse(ExportCSV::$anonfun$1$$anonfun$2));
        this.writer.printRecord((Object[])((String[])Arrays$.MODULE$.seqToArray((Seq)items, String.class)));
    }

    @Override
    public Observable<byte[]> buildSource() {
        this.writer.close(true);
        return DataBytes$.MODULE$.apply(this.filePath.toFile()).observable().doOnComplete(Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.buildSource$$anonfun$1();
            return BoxedUnit.UNIT;
        }));
    }

    private static final String $anonfun$1$$anonfun$2() {
        return "";
    }

    private final void buildSource$$anonfun$1() {
        Files.delete(this.filePath);
    }
}

