/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.DatasetFieldAnalysis;
import ambience.datasets.DatasetFieldAnalysis$;
import ambience.datasets.ETLHelper;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class InferETLSchema
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InferETLSchema.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ETLHelper etlHelper;
    private final int MaxCount;

    public InferETLSchema(ETLHelper etlHelper) {
        this.etlHelper = etlHelper;
        this.MaxCount = 10000;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int MaxCount() {
        return this.MaxCount;
    }

    public Task<Data.Schema> getSchema(UserDB.User user, String chainSetName, String chainName, List<Json> aggregation) {
        if (aggregation.isEmpty()) {
            return this.getSchemaChain(user, chainSetName, chainName);
        }
        return this.getSchemaBatch(user, chainSetName, chainName, aggregation);
    }

    public Task<Data.Schema> getSchemaChain(UserDB.User user, String chainSetName, String chainName) {
        Observable records = Observable$.MODULE$.fromTask(this.etlHelper.getChainSet(user, chainSetName)).flatMap((Function1 & Serializable)chainSet -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ChainRunner.ChainIdSpec[]{ChainRunner.ChainIdSpec$.MODULE$.apply(chainSet._id(), chainName)})).flatMap((Function1 & Serializable)chainSpec -> {
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            this.log().info(() -> InferETLSchema.$anonfun$1$$anonfun$1$$anonfun$1(chainSetName, chainName), Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.datasets.InferETLSchema.records"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.etlHelper.chainAPI().runChain(user, (ChainRunner.ChainSpec)chainSpec, Observable$.MODULE$.now((Object)package$.MODULE$.Document().apply())).take(Int$.MODULE$.int2long(this.MaxCount())).map((Function1 & Serializable)docs -> docs);
            });
        }));
        DatasetFieldAnalysis analysis = new DatasetFieldAnalysis(this.etlHelper.datasetsModule().ChoicesLimit(), DatasetFieldAnalysis$.MODULE$.$lessinit$greater$default$2());
        return records.foldLeft(() -> InferETLSchema.getSchemaChain$$anonfun$1(analysis), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                DatasetFieldAnalysis a = (DatasetFieldAnalysis)tuple2._1();
                Document rec = (Document)tuple2._2();
                return a.add(rec.toBsonDocument());
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)_$1 -> _$1.results()).firstL();
    }

    public Task<Data.Schema> getSchemaBatch(UserDB.User user, String chainSetName, String chainName, List<Json> aggregation) {
        return this.etlHelper.getChainSet(user, chainSetName).flatMap((Function1 & Serializable)chainset -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.getSchemaBatch$$anonfun$1$$anonfun$1(chainSetName, chainName);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), chainName), ambience.etl.package$.MODULE$.EmptyJsonObject()).flatMap((Function1 & Serializable)uuid -> this.buildSchemaBatch(user, (String)uuid, aggregation).map((Function1 & Serializable)schema -> schema));
        }));
    }

    public Task<Data.Schema> buildSchemaBatch(UserDB.User user, String uuid, List<Json> aggregation) {
        DatasetFieldAnalysis analysis = new DatasetFieldAnalysis(this.etlHelper.datasetsModule().ChoicesLimit(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_elxIdx"}))));
        RichMongoCollection cltn = new RichMongoCollection(this.etlHelper.mongoDB().temp().getCollection(uuid, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        this.log().info(this::buildSchemaBatch$$anonfun$1, Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.datasets.InferETLSchema.buildSchemaBatch"));
        List steps = aggregation.map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces()));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$limit");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(this.MaxCount())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return cltn.aggregateO((Seq)steps.toVector().$colon$plus((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).foldLeft(() -> InferETLSchema.buildSchemaBatch$$anonfun$2(analysis), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                DatasetFieldAnalysis a = (DatasetFieldAnalysis)tuple2._1();
                Document d = (Document)tuple2._2();
                return a.add(d.toBsonDocument());
            }
            throw new MatchError((Object)tuple2);
        }).doOnComplete(this.etlHelper.dropTemp(user, uuid)).map((Function1 & Serializable)_$2 -> _$2.results()).firstL();
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$1(String chainSetName$3, String chainName$3) {
        return "Running ETLChain for " + chainSetName$3 + " " + chainName$3 + " in order to infer schema";
    }

    private static final DatasetFieldAnalysis getSchemaChain$$anonfun$1(DatasetFieldAnalysis analysis$1) {
        return analysis$1;
    }

    private static final Object getSchemaBatch$$anonfun$1$$anonfun$1$$anonfun$1(String chainSetName$6, String chainName$6) {
        return "Running ETLBatch for " + chainSetName$6 + " " + chainName$6 + " in order to infer schema";
    }

    private final void getSchemaBatch$$anonfun$1$$anonfun$1(String chainSetName$5, String chainName$5) {
        this.log().info(() -> InferETLSchema.getSchemaBatch$$anonfun$1$$anonfun$1$$anonfun$1(chainSetName$5, chainName$5), Line$.MODULE$.apply(38), FullName$.MODULE$.apply("ambience.datasets.InferETLSchema.getSchemaBatch"));
    }

    private final Object buildSchemaBatch$$anonfun$1() {
        return "Infer ETL schema analysing " + this.MaxCount() + " records";
    }

    private static final DatasetFieldAnalysis buildSchemaBatch$$anonfun$2(DatasetFieldAnalysis analysis$2) {
        return analysis$2;
    }
}

