/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.datasets.DSType$;
import ambience.datasets.DatasetManager;
import ambience.datasets.DatasetsModule;
import ambience.datasets.UploadHandler$Result$;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.json.JsonLens$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import io.circe.DecodingFailure;
import io.circe.DecodingFailure$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UploadHandler
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UploadHandler.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;

    public UploadHandler(DatasetsModule module) {
        this.module = module;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<GravityResponse> handleUpload(UserDB.User user, DataBytes bytes, String name, String overwrite) {
        String string = overwrite;
        String string2 = "true";
        return this.doHandleUpload(user, bytes, (Option<String>)Some$.MODULE$.apply((Object)name), !(string != null ? !string.equals(string2) : string2 != null)).map((Function1 & Serializable)x$1 -> {
            Result result = x$1;
            if (result != null) {
                Result result2 = UploadHandler$Result$.MODULE$.unapply(result);
                String string = result2._1();
                LogMessage logMessage = result2._2();
                if (LogMessage$None$.MODULE$.equals(logMessage)) {
                    return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                }
                LogMessage msg = logMessage;
                return Gravity$.MODULE$.BadRequestResponse(msg.msg());
            }
            throw new MatchError((Object)result);
        });
    }

    public Task<Result> doHandleUpload(UserDB.User user, DataBytes bytes, Option<String> optName, boolean overwrite) {
        return GravityHelper$.MODULE$.textT(bytes).flatMap((Function1 & Serializable)jsonString -> {
            Either either = io.circe.parser.package$.MODULE$.parse(jsonString);
            if (either instanceof Right) {
                Json datasetJson = (Json)((Right)either).value();
                return this.doHandleJsonUpload(user, datasetJson, optName, overwrite);
            }
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> UploadHandler.doHandleUpload$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.doHandleUpload"));
                return Task$.MODULE$.now((Object)UploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Decode json failed")));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Result> doHandleJsonUpload(UserDB.User user, Json datasetJson, Option<String> optName, boolean overwrite) {
        Either<DecodingFailure, Json> either = this.decodeDataset(datasetJson);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            Option option = optName.orElse(() -> UploadHandler.doHandleJsonUpload$$anonfun$1(json));
            if (option instanceof Some) {
                String name = (String)((Some)option).value();
                Task<LogMessage> tpreparation = overwrite ? this.handleDeleteBeforeUpload(user, name) : Task$.MODULE$.now((Object)LogMessage$None$.MODULE$);
                return tpreparation.flatMap((Function1 & Serializable)x$12 -> {
                    LogMessage logMessage = x$12;
                    if (LogMessage$None$.MODULE$.equals(logMessage)) {
                        Document newDoc = Document$.MODULE$.apply(datasetJson.mapObject((Function1 & Serializable)obj -> obj.add("name", Json$.MODULE$.fromString(name))).noSpaces());
                        return this.module.datasetManager().add(user, (BsonValue)BsonString$.MODULE$.apply(name), newDoc).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Right) {
                                return UploadHandler$Result$.MODULE$.apply(name, (LogMessage)LogMessage$None$.MODULE$);
                            }
                            if (either instanceof Left) {
                                LogMessage msg = (LogMessage)((Left)either).value();
                                this.log().apply(msg, Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.doHandleJsonUpload"));
                                return UploadHandler$Result$.MODULE$.apply(name, (LogMessage)LogMessage.Error$.MODULE$.apply("Add failed"));
                            }
                            throw new MatchError((Object)either);
                        });
                    }
                    LogMessage msg = logMessage;
                    this.log().apply(msg, Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.doHandleJsonUpload"));
                    return Task$.MODULE$.now((Object)UploadHandler$Result$.MODULE$.apply(name, (LogMessage)LogMessage.Error$.MODULE$.apply("Overwrite removal failed")));
                });
            }
            if (None$.MODULE$.equals(option)) {
                this.log().error(UploadHandler::doHandleJsonUpload$$anonfun$3, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.doHandleJsonUpload"));
                return Task$.MODULE$.now((Object)UploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Missing name")));
            }
            throw new MatchError((Object)option);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().error(() -> UploadHandler.doHandleJsonUpload$$anonfun$4(err), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.doHandleJsonUpload"));
            return Task$.MODULE$.now((Object)UploadHandler$Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Decode dataset failed")));
        }
        throw new MatchError(either);
    }

    public Task<LogMessage> handleDeleteBeforeUpload(UserDB.User user, String name) {
        this.log().info(UploadHandler::handleDeleteBeforeUpload$$anonfun$1, Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.handleDeleteBeforeUpload"));
        DatasetManager docManager = this.module.datasetManager();
        Task ret = this.getRecord(name).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option optOwner = doc.get("owner", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue());
                if (optOwner.contains((Object)user.id()) || optOwner.isEmpty()) {
                    Option option2 = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class)).map((Function1 & Serializable)_$2 -> _$2.getValue().toHexString());
                    if (option2 instanceof Some) {
                        String _id = (String)((Some)option2).value();
                        return docManager.delete(user, _id).map((Function1 & Serializable)_$3 -> LogMessage$None$.MODULE$);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Can't get _id"));
                    }
                    throw new MatchError((Object)option2);
                }
                return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Can't overwrite. " + user.name() + " with id " + user.id() + " does not match owner " + optOwner));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)LogMessage$None$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
        ret.map((Function1)(JProcedure1 & Serializable)msg -> this.log().info(() -> UploadHandler.handleDeleteBeforeUpload$$anonfun$2$$anonfun$1(msg), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.datasets.UploadHandler.handleDeleteBeforeUpload")));
        return ret;
    }

    public Task<Option<Document>> getRecord(String name) {
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "owner"})));
        return this.module.datasetManager().cltn().findO(Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name)), projections).firstOptionL();
    }

    public Either<DecodingFailure, Json> decodeDataset(Json json) {
        Option datasetType = json.asObject().flatMap((Function1 & Serializable)_$4 -> _$4.apply("datasetType").flatMap((Function1 & Serializable)_$5 -> _$5.asString()));
        Option option = datasetType;
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            String string2 = DSType$.MODULE$.MongoDB();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return package$.MODULE$.Right().apply((Object)json);
            }
            String string4 = DSType$.MODULE$.ETL();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return package$.MODULE$.Right().apply((Object)json);
            }
            String string6 = DSType$.MODULE$.Cached();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return package$.MODULE$.Right().apply((Object)json);
            }
        }
        return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("Unknown datasetType: " + datasetType, UploadHandler::decodeDataset$$anonfun$1));
    }

    private static final Object doHandleUpload$$anonfun$1$$anonfun$1(ParsingFailure err$1) {
        return "Cannot decode uploaded file as json: " + err$1;
    }

    private static final Option doHandleJsonUpload$$anonfun$1(Json json$1) {
        return JsonLens$.MODULE$.root().selectDynamic("name").string().getOption((Object)json$1);
    }

    private static final Object doHandleJsonUpload$$anonfun$3() {
        return "Upload is missing a name field";
    }

    private static final Object doHandleJsonUpload$$anonfun$4(DecodingFailure err$2) {
        return "Cannot decode uploaded file as a dataset: " + err$2;
    }

    private static final Object handleDeleteBeforeUpload$$anonfun$1() {
        return "handleDeleteBeforeUpload";
    }

    private static final Object handleDeleteBeforeUpload$$anonfun$2$$anonfun$1(LogMessage msg$1) {
        return "handleDeleteBeforeUpload returns " + msg$1;
    }

    private static final List decodeDataset$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    public static final class Result
    implements Product,
    Serializable {
        private final String name;
        private final LogMessage msg;

        public static Result apply(String string, LogMessage logMessage) {
            return UploadHandler$Result$.MODULE$.apply(string, logMessage);
        }

        public static Result fromProduct(Product product) {
            return UploadHandler$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return UploadHandler$Result$.MODULE$.unapply(result);
        }

        public Result(String name, LogMessage msg) {
            this.name = name;
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            String string = this.name();
            String string2 = result.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            LogMessage logMessage = this.msg();
            LogMessage logMessage2 = result.msg();
            if (logMessage == null) {
                if (logMessage2 == null) return true;
                return false;
            } else {
                if (!logMessage.equals(logMessage2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public LogMessage msg() {
            return this.msg;
        }

        public Result copy(String name, LogMessage msg) {
            return new Result(name, msg);
        }

        public String copy$default$1() {
            return this.name();
        }

        public LogMessage copy$default$2() {
            return this.msg();
        }

        public String _1() {
            return this.name();
        }

        public LogMessage _2() {
            return this.msg();
        }
    }
}

