/*
 * Decompiled with CFR 0.152.
 */
package ambience.dsengine.datastore;

import ambience.dsengine.datastore.XlsxDataStore$Lookup$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.arch.param.Template;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.data.RichSchema$;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.attributes.Format;
import com.elixirtech.opc.DateTimeUtil$;
import com.typesafe.config.Config;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Date;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class XlsxDataStore
implements DataListener,
SLF4J,
LoggingHelper {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(XlsxDataStore.class.getDeclaredField("logger$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(XlsxDataStore.class.getDeclaredField("Lookup$lzy1"));
    private volatile Object logger$lzy1;
    private final OutputStream outputStream;
    private final Config config;
    private final XSSFWorkbook workbook;
    private final int MaxRows;
    private final String DoubleFormatString;
    private final String TimestampFormatString;
    private final XSSFCellStyle DefaultDoubleFormat;
    private final XSSFCellStyle DefaultLongFormat;
    private final XSSFCellStyle DefaultDateFormat;
    private final XSSFCellStyle DefaultTimeFormat;
    private final XSSFCellStyle DefaultTimestampFormat;
    private Option<PushContext> context;
    private DataSchema schema;
    private Template sheetName;
    private Option<XSSFSheet> optSheet;
    private final HashSet<String> sheetNames;
    private int row;
    private int groupedSheetsLevel;
    private boolean firstRowHeader;
    public final Stack<DataGroup> ambience$dsengine$datastore$XlsxDataStore$$groupStack;
    private Option<String> optPassword;
    private volatile Object Lookup$lzy1;

    public XlsxDataStore(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.config = (Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class));
        this.workbook = new XSSFWorkbook();
        this.MaxRows = this.config().getInt("ambience.ds-engine.store.xlsx.max-rows");
        this.DoubleFormatString = this.config().getString("ambience.ds-engine.store.xlsx.format.double");
        this.TimestampFormatString = this.config().getString("ambience.ds-engine.store.xlsx.format.timestamp");
        this.DefaultDoubleFormat = this.buildStyle(this.DoubleFormatString());
        this.DefaultLongFormat = this.buildStyle(1);
        this.DefaultDateFormat = this.buildStyle(14);
        this.DefaultTimeFormat = this.buildStyle(20);
        this.DefaultTimestampFormat = this.buildStyle(this.TimestampFormatString());
        this.context = None$.MODULE$;
        this.schema = null;
        this.sheetName = Template$.MODULE$.apply("Sheet1");
        this.optSheet = None$.MODULE$;
        this.sheetNames = new HashSet();
        this.row = 0;
        this.groupedSheetsLevel = 1;
        this.firstRowHeader = false;
        this.ambience$dsengine$datastore$XlsxDataStore$$groupStack = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
        this.optPassword = None$.MODULE$;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config config() {
        return this.config;
    }

    public int MaxRows() {
        return this.MaxRows;
    }

    public String DoubleFormatString() {
        return this.DoubleFormatString;
    }

    public String TimestampFormatString() {
        return this.TimestampFormatString;
    }

    public XSSFCellStyle DefaultDoubleFormat() {
        return this.DefaultDoubleFormat;
    }

    public XSSFCellStyle DefaultLongFormat() {
        return this.DefaultLongFormat;
    }

    public XSSFCellStyle DefaultDateFormat() {
        return this.DefaultDateFormat;
    }

    public XSSFCellStyle DefaultTimeFormat() {
        return this.DefaultTimeFormat;
    }

    public XSSFCellStyle DefaultTimestampFormat() {
        return this.DefaultTimestampFormat;
    }

    public void setContext(PushContext cxt) {
        this.context = Some$.MODULE$.apply((Object)cxt);
    }

    public void setPassword(String p) {
        this.optPassword = Option$.MODULE$.apply((Object)p);
    }

    public String getPassword() {
        return (String)this.optPassword.getOrElse(XlsxDataStore::getPassword$$anonfun$1);
    }

    public void setSheetName(String sn) {
        this.sheetName = Template$.MODULE$.apply(sn);
    }

    public int getSheetGroupLevel() {
        return this.groupedSheetsLevel;
    }

    public void setSheetGroupLevel(int level) {
        this.groupedSheetsLevel = level;
    }

    public boolean isFirstRowHeader() {
        return this.firstRowHeader;
    }

    public void setFirstRowHeader(boolean b) {
        this.firstRowHeader = b;
    }

    public void startData(IDataSource src) {
        this.schema = src.getSchema();
    }

    public void startGroup(DataGroup group) {
        this.ambience$dsengine$datastore$XlsxDataStore$$groupStack.push((Object)group);
        if (group.getLevel() == this.groupedSheetsLevel - 1) {
            String sn = this.ensureUnique(this.ensureValidChars(this.sheetName.substitute(this.Lookup().lift())));
            this.sheetNames.add((Object)sn);
            XSSFSheet sheet = this.workbook.createSheet(sn);
            this.optSheet = Some$.MODULE$.apply((Object)sheet);
            this.row = 0;
            this.outputHeader(sheet);
            return;
        }
    }

    public boolean processRecord(DataRecord record) {
        boolean bl;
        block8: {
            XSSFSheet xSSFSheet;
            Option<XSSFSheet> option = this.optSheet;
            if (option instanceof Some) {
                XSSFSheet s;
                xSSFSheet = s = (XSSFSheet)((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                String sn = this.ensureUnique(this.ensureValidChars(this.sheetName.substitute(this.Lookup().lift())));
                this.sheetNames.add((Object)sn);
                XSSFSheet s = this.workbook.createSheet(sn);
                this.optSheet = Some$.MODULE$.apply((Object)s);
                this.row = 0;
                this.outputHeader(s);
                xSSFSheet = s;
            } else {
                throw new MatchError(option);
            }
            XSSFSheet sheet = xSSFSheet;
            try {
                this.output(sheet, record.getData());
                Option<PushContext> option2 = this.context;
                if (option2 instanceof Some) {
                    PushContext cxt = (PushContext)((Some)option2).value();
                    bl = !cxt.isAborted();
                    break block8;
                }
                if (None$.MODULE$.equals(option2)) {
                    bl = true;
                    break block8;
                }
                throw new MatchError(option2);
            }
            catch (Exception ex) {
                this.error(() -> this.processRecord$$anonfun$1(ex), ex, Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.dsengine.datastore.XlsxDataStore.processRecord"));
                bl = false;
            }
        }
        return bl;
    }

    public void endGroup(DataGroup group) {
        this.ambience$dsengine$datastore$XlsxDataStore$$groupStack.pop();
    }

    public void endData(IDataSource src) {
        this.outputToOs(this.outputStream);
    }

    public void outputHeader(XSSFSheet sheet) {
        if (this.firstRowHeader) {
            this.output(sheet, (Object[])((IterableOnceOps)RichSchema$.MODULE$.schema2rich(this.schema).items().map((Function1 & Serializable)_$1 -> _$1.name())).toArray(ClassTag$.MODULE$.apply(Object.class)));
            return;
        }
    }

    public void output(XSSFSheet sheet, Object[] data) {
        if (this.row < this.MaxRows()) {
            XSSFRow newRow = sheet.createRow(this.row);
            Object object = Predef$.MODULE$.refArrayOps(data);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                block10: {
                    Object object;
                    XSSFCell cell;
                    int i;
                    Object field;
                    block11: {
                        block13: {
                            block12: {
                                DataType dt;
                                tuple2 = x$1;
                                if (tuple2 == null) break block10;
                                field = tuple2._1();
                                i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                cell = newRow.createCell(i);
                                object = field;
                                if (object instanceof String) {
                                    String s = (String)object;
                                    cell.setCellValue(s);
                                    return;
                                }
                                if (!(object instanceof Number)) break block11;
                                Number n = (Number)object;
                                double d = n.doubleValue();
                                if (Double.isNaN(d)) {
                                    cell.setCellValue("");
                                    return;
                                }
                                cell.setCellValue(d);
                                DataType dataType = dt = this.schema.getColumnType(i);
                                DataType dataType2 = DataType.DOUBLE;
                                if (!(dataType == null ? dataType2 != null : !dataType.equals(dataType2))) break block12;
                                DataType dataType3 = dt;
                                DataType dataType4 = DataType.DECIMAL;
                                if (dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null) break block13;
                            }
                            XSSFCellStyle style = (XSSFCellStyle)this.buildStyle(this.schema.getColumn(i)).getOrElse(this::$anonfun$1);
                            cell.setCellStyle((CellStyle)style);
                            return;
                        }
                        XSSFCellStyle style = (XSSFCellStyle)this.buildStyle(this.schema.getColumn(i)).getOrElse(this::$anonfun$2);
                        cell.setCellStyle((CellStyle)style);
                        return;
                    }
                    if (object instanceof Date) {
                        DataType dt;
                        Date d = (Date)object;
                        DataType dataType = dt = this.schema.getColumnType(i);
                        DataType dataType5 = DataType.DATE;
                        DataType dataType6 = dataType;
                        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                            int days = DateTimeUtil$.MODULE$.getDaysSince1900(d);
                            cell.setCellValue(Int$.MODULE$.int2double(days));
                            XSSFCellStyle style = (XSSFCellStyle)this.buildStyle(this.schema.getColumn(i)).getOrElse(this::$anonfun$3);
                            cell.setCellStyle((CellStyle)style);
                            return;
                        }
                        DataType dataType7 = DataType.TIME;
                        DataType dataType8 = dataType;
                        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                            double secs = DateTimeUtil$.MODULE$.getTimeSinceMidnight(d);
                            cell.setCellValue(secs);
                            XSSFCellStyle style = (XSSFCellStyle)this.buildStyle(this.schema.getColumn(i)).getOrElse(this::$anonfun$4);
                            cell.setCellStyle((CellStyle)style);
                            return;
                        }
                        DataType dataType9 = DataType.TIMESTAMP;
                        DataType dataType10 = dataType;
                        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                            double ts = DateTimeUtil$.MODULE$.getTimestamp(d);
                            cell.setCellValue(ts);
                            XSSFCellStyle style = (XSSFCellStyle)this.buildStyle(this.schema.getColumn(i)).getOrElse(this::$anonfun$5);
                            cell.setCellStyle((CellStyle)style);
                            return;
                        }
                        cell.setCellValue("Unexpected date: " + d);
                        return;
                    }
                    if (object instanceof Boolean) {
                        Boolean b = (Boolean)object;
                        cell.setCellValue(Predef$.MODULE$.Boolean2boolean(b));
                        return;
                    }
                    String s = this.schema.format(this.schema.getColumnType(i), field);
                    cell.setCellValue(s);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            ++this.row;
            return;
        }
        this.optSheet = None$.MODULE$;
        this.row = 0;
        DataRecord rec = new DataRecord(this.schema, data);
        this.processRecord(rec);
    }

    private String ensureUnique(String s) {
        if (this.sheetNames.contains((Object)s)) {
            String buff = s.endsWith("1") ? s.substring(0, s.length() - 1) : s;
            int idx = 1;
            boolean found = false;
            while (!found) {
                String test = buff + idx;
                if (!this.sheetNames.contains((Object)test)) {
                    found = true;
                    continue;
                }
                ++idx;
            }
            return buff + idx;
        }
        return s;
    }

    private String ensureValidChars(String name) {
        String ret = name.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('{', '_');
        if (ret.length() > 31) {
            return ret.substring(0, 31);
        }
        return ret;
    }

    public final XlsxDataStore$Lookup$ Lookup() {
        Object object = this.Lookup$lzy1;
        if (object instanceof XlsxDataStore$Lookup$) {
            return (XlsxDataStore$Lookup$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (XlsxDataStore$Lookup$)this.Lookup$lzyINIT1();
    }

    private Object Lookup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Lookup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    XlsxDataStore$Lookup$ xlsxDataStore$Lookup$ = null;
                    try {
                        xlsxDataStore$Lookup$ = new XlsxDataStore$Lookup$(this);
                        object2 = xlsxDataStore$Lookup$ == null ? LazyVals.NullValue$.MODULE$ : xlsxDataStore$Lookup$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Lookup$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return xlsxDataStore$Lookup$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private XSSFCellStyle buildStyle(String s) {
        XSSFCellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setDataFormat(this.workbook.getCreationHelper().createDataFormat().getFormat(s));
        return cellStyle;
    }

    private XSSFCellStyle buildStyle(int id) {
        XSSFCellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setDataFormat(id);
        return cellStyle;
    }

    private Option<XSSFCellStyle> buildStyle(SchemaItem si) {
        return Option$.MODULE$.apply((Object)si.attrs.getAttribute(Format.class)).map((Function1 & Serializable)fa -> this.buildStyle(fa.getFormat()));
    }

    private void outputToOs(OutputStream os) {
        String password;
        Option<PushContext> option = this.context;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Context undefined");
            }
            throw new MatchError(option);
        }
        PushContext c = (PushContext)((Some)option).value();
        PushContext cxt = c;
        String string = password = (String)this.optPassword.map((Function1 & Serializable)p -> cxt.substitute(p).trim()).getOrElse(XlsxDataStore::$anonfun$7);
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            File tempFile = File.createTempFile("tmp-", ".xlsx");
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                BufferedOutputStream out = (BufferedOutputStream)arm.manage((Object)new BufferedOutputStream(new FileOutputStream(tempFile)));
                this.workbook.write((OutputStream)out);
            });
            this.encryptFile(tempFile, password);
            ARM$.MODULE$.run((Function1 & Serializable)arm -> Files.copy(tempFile.toPath(), os));
            tempFile.delete();
            return;
        }
        this.workbook.write(os);
    }

    public void encryptFile(File file, String password) {
        JobLogging$.MODULE$.info("XLSX", () -> XlsxDataStore.encryptFile$$anonfun$1(file));
        try {
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                OPCPackage opc = (OPCPackage)arm.manage((Object)OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ_WRITE));
                OutputStream os = (OutputStream)arm.manage((Object)enc.getDataStream(fs));
                opc.save(os);
            });
            File temp2 = File.createTempFile("tmp-", ".xlsx");
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm2 -> {
                FileOutputStream fos = (FileOutputStream)arm2.manage((Object)new FileOutputStream(temp2));
                fs.writeFilesystem((OutputStream)fos);
            });
            file.delete();
            temp2.renameTo(file);
            JobLogging$.MODULE$.info("XLSX", XlsxDataStore::encryptFile$$anonfun$4);
        }
        catch (Exception ex) {
            JobLogging$.MODULE$.error("XLSX", () -> XlsxDataStore.encryptFile$$anonfun$5(ex), ex);
        }
    }

    private static final String getPassword$$anonfun$1() {
        return "";
    }

    private final Object processRecord$$anonfun$1(Exception ex$1) {
        return "Error processing record " + this.row + ": " + ex$1;
    }

    private final XSSFCellStyle $anonfun$1() {
        return this.DefaultDoubleFormat();
    }

    private final XSSFCellStyle $anonfun$2() {
        return this.DefaultLongFormat();
    }

    private final XSSFCellStyle $anonfun$3() {
        return this.DefaultDateFormat();
    }

    private final XSSFCellStyle $anonfun$4() {
        return this.DefaultTimeFormat();
    }

    private final XSSFCellStyle $anonfun$5() {
        return this.DefaultTimestampFormat();
    }

    public static final String ambience$dsengine$datastore$XlsxDataStore$Lookup$$$_$apply$$anonfun$3(String key$1) {
        return key$1;
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final String encryptFile$$anonfun$1(File file$1) {
        return "Encrypting file from source " + file$1.length() + " bytes";
    }

    private static final String encryptFile$$anonfun$4() {
        return "Encryption complete.";
    }

    private static final String encryptFile$$anonfun$5(Exception ex$2) {
        return "Encryption error: " + ex$2;
    }
}

