/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine;

import ambience.api.Repository;
import ambience.module.CurrentUser$;
import ambience.module.UserDB;
import ambience.rml.AuthWrapper$;
import ambience.rmlengine.AmbienceDSM;
import ambience.rmlengine.AmbienceDSM$;
import ambience.rmlengine.AmbienceDSM$DSFileData$;
import ambience.rmlengine.AmbienceDataSource;
import ambience.rmlengine.AmbienceDataSource$;
import ambience.rmlengine.AmbienceDynamicDataSource;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelperT;
import com.elixirtech.arch.LoggingInterfaceT;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.data2.DSUtil2$;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.regex.Pattern;
import monix.eval.Task;
import monix.eval.Task$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AmbienceDSMT
implements LoggingHelperT {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDSMT.class.getDeclaredField("log$lzy2"));
    private volatile Object log$lzy2;
    private final DataSourceManager dsm;
    private final HashMap<String, AmbienceDSM.DSFileData> cache;
    private final List dynamicSchemas;

    public AmbienceDSMT(Config config, DataSourceManager dsm) {
        this.dsm = dsm;
        this.cache = new HashMap();
        this.dynamicSchemas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getStringList("ambience.rml-engine.dynamic-schema")).asScala().flatMap((Function1 & Serializable)s -> {
            Try try_ = Try$.MODULE$.apply(() -> AmbienceDSMT.$init$$$anonfun$1$$anonfun$1(s));
            if (try_ instanceof Success) {
                Pattern re = (Pattern)((Success)try_).value();
                return Some$.MODULE$.apply((Object)re);
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                AmbienceDSM$.MODULE$.log().warn(() -> AmbienceDSMT.$init$$$anonfun$1$$anonfun$2(s, ex), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.dynamicSchemas"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        })).toList();
    }

    public LoggingInterfaceT log() {
        Object object = this.log$lzy2;
        if (object instanceof LoggingInterfaceT) {
            return (LoggingInterfaceT)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterfaceT)this.log$lzyINIT2();
    }

    private Object log$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterfaceT loggingInterfaceT = null;
                    try {
                        loggingInterfaceT = LoggingHelperT.log$((LoggingHelperT)this);
                        object2 = loggingInterfaceT == null ? LazyVals.NullValue$.MODULE$ : loggingInterfaceT;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterfaceT;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<Pattern> dynamicSchemas() {
        return this.dynamicSchemas;
    }

    public Task<IDataSource> getDataSource(UserDB.User user, DataSourceManager context, String dontUse) {
        String noPrefixName = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(dontUse), "repository:");
        if (this.dynamicSchemas().exists((Function1 & Serializable)_$2 -> _$2.matcher(noPrefixName).matches())) {
            AmbienceDSM$.MODULE$.log().info(() -> AmbienceDSMT.getDataSource$$anonfun$3(noPrefixName), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.getDataSource"));
            return Task$.MODULE$.apply(() -> AmbienceDSMT.getDataSource$$anonfun$4(user, noPrefixName));
        }
        return this.loadFromRepository(user, context, noPrefixName).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                IDataSource ds = (IDataSource)((Some)option).value();
                return Task$.MODULE$.now((Object)ds);
            }
            if (None$.MODULE$.equals(option)) {
                return this.loadFromDataset(user, noPrefixName);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<IDataSource> loadFromDataset(UserDB.User user, String name) {
        return AmbienceDataSource$.MODULE$.load(user, name).flatMap((Function1 & Serializable)optds -> (optds.isDefined() ? this.log().infoT(() -> AmbienceDSMT.loadFromDataset$$anonfun$1$$anonfun$1(name), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.loadFromDataset")) : this.log().errorT(() -> AmbienceDSMT.loadFromDataset$$anonfun$1$$anonfun$2(name), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.loadFromDataset"))).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (AmbienceDataSource)optds.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }));
    }

    public Task<Option<IDataSource>> loadFromRepository(UserDB.User user, DataSourceManager context, String name) {
        Task tOptDs = this.log().debugElapsedTimeT(AmbienceDSMT::$anonfun$1, () -> this.$anonfun$2(name, user, context), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.tOptDs"));
        return tOptDs.map((Function1 & Serializable)optds -> optds.map((Function1 & Serializable)ds -> (IDataSource)CurrentUser$.MODULE$.withUser(user, () -> this.loadFromRepository$$anonfun$1$$anonfun$1$$anonfun$1(ds))));
    }

    public Task<Option<IDataSource>> doLoadFromRepository(UserDB.User user, DataSourceManager context, String name) {
        return this.optLoadFile(user, Path$.MODULE$.apply(name)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Repository.FileData fileData = (Repository.FileData)((Some)option).value();
                return this.loadBytes(user, context, fileData);
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<Repository.FileData>> optLoadFile(UserDB.User user, Path path) {
        Repository repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
        return repository.readFileDataT(user, path).map((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return None$.MODULE$;
            }
        });
    }

    public Task<Option<IDataSource>> doUpdateFromRepository(UserDB.User user, DataSourceManager context, AmbienceDSM.DSFileData rfd) {
        Repository repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
        return repository.readFileDataIfModifiedT(user, rfd.fd().path(), rfd.fd().lastModified()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Repository.FileData fd = (Repository.FileData)((Some)option).value();
                return this.loadBytes(user, context, fd);
            }
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply((Object)rfd.ds());
            }
            throw new MatchError((Object)option);
        });
    }

    public Option<IDataSource> loadBytes(UserDB.User user, DataSourceManager context, Repository.FileData fd) {
        Option option;
        AmbienceDSM$.MODULE$.log().info(() -> AmbienceDSMT.loadBytes$$anonfun$1(fd), Line$.MODULE$.apply(118), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.loadBytes"));
        try {
            option = (Option)AuthWrapper$.MODULE$.withUser(user, () -> this.loadBytes$$anonfun$2(fd, context));
        }
        catch (Exception ex) {
            AmbienceDSM$.MODULE$.log().error(() -> AmbienceDSMT.loadBytes$$anonfun$3(fd, ex), (Throwable)ex, Line$.MODULE$.apply(128), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.loadBytes"));
            option = None$.MODULE$;
        }
        return option;
    }

    private static final Pattern $init$$$anonfun$1$$anonfun$1(String s$1) {
        return Pattern.compile(s$1);
    }

    private static final Object $init$$$anonfun$1$$anonfun$2(String s$2, Throwable ex$1) {
        return "Can't parse \"" + s$2 + "\": " + ex$1;
    }

    private static final Object getDataSource$$anonfun$3(String noPrefixName$2) {
        return "Using dynamic schema for " + noPrefixName$2;
    }

    private static final AmbienceDynamicDataSource getDataSource$$anonfun$4(UserDB.User user$1, String noPrefixName$3) {
        return new AmbienceDynamicDataSource(user$1, noPrefixName$3);
    }

    private static final Object loadFromDataset$$anonfun$1$$anonfun$1(String name$2) {
        return "Loaded dataset " + name$2;
    }

    private static final Object loadFromDataset$$anonfun$1$$anonfun$2(String name$3) {
        return "Can't find datasource " + name$3;
    }

    private static final String $anonfun$1() {
        return "loadFromRepository";
    }

    private final Task $anonfun$2(String name$4, UserDB.User user$3, DataSourceManager context$1) {
        Option option = this.cache.get((Object)name$4);
        if (option instanceof Some) {
            AmbienceDSM.DSFileData rfd = (AmbienceDSM.DSFileData)((Some)option).value();
            return this.doUpdateFromRepository(user$3, context$1, rfd);
        }
        if (None$.MODULE$.equals(option)) {
            return this.doLoadFromRepository(user$3, context$1, name$4);
        }
        throw new MatchError((Object)option);
    }

    private final IDataSource loadFromRepository$$anonfun$1$$anonfun$1$$anonfun$1(IDataSource ds$1) {
        return DataSourceDefinition.clone((DataSourceManager)this.dsm, (IDataSource)ds$1);
    }

    private static final Object loadBytes$$anonfun$1(Repository.FileData fd$1) {
        return "Repository file " + fd$1.path() + " found with size " + fd$1.bytes().length;
    }

    private static final String $anonfun$3(Repository.FileData fd$3) {
        return "building " + fd$3.path();
    }

    private static final IDataSource $anonfun$4(DataSourceManager context$5, Repository.FileData fd$4) {
        return DSUtil2$.MODULE$.load(context$5, fd$4.bytes());
    }

    private final Some loadBytes$$anonfun$2(Repository.FileData fd$2, DataSourceManager context$4) {
        IDataSource ds = (IDataSource)AmbienceDSM$.MODULE$.log().debugElapsedTime(() -> AmbienceDSMT.$anonfun$3(fd$2), () -> AmbienceDSMT.$anonfun$4(context$4, fd$2), Line$.MODULE$.apply(121), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDSMT.ds"));
        this.cache.put((Object)fd$2.path().toString(), (Object)AmbienceDSM$DSFileData$.MODULE$.apply(fd$2, ds));
        return Some$.MODULE$.apply((Object)ds);
    }

    private static final Object loadBytes$$anonfun$3(Repository.FileData fd$5, Exception ex$2) {
        return "Can't load datasource " + fd$5.path() + " from repository: " + ex$2;
    }
}

