/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine;

import ambience.api.RMLEngine;
import ambience.api.ReportEngine;
import ambience.api.WebStore;
import ambience.dsengine.DataBytesHelper$;
import ambience.framework.ActivityLog;
import ambience.job.JobHelper$;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import ambience.rml.AuthWrapper$;
import ambience.rmlengine.RenderRML;
import ambience.rmlengine.RenderRMLUI$;
import better.files.File;
import better.files.File$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.JobLogStorage$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import org.owasp.encoder.Encode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RenderHelper$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(RenderHelper$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(RenderHelper$.class.getDeclaredField("ExpiresAfterMs$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(RenderHelper$.class.getDeclaredField("webStorePrefix$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(RenderHelper$.class.getDeclaredField("activityLog$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenderHelper$.class.getDeclaredField("engine$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object engine$lzy1;
    private volatile Object activityLog$lzy1;
    private volatile Object webStorePrefix$lzy1;
    private volatile Object ExpiresAfterMs$lzy1;
    public static final RenderHelper$ MODULE$ = new RenderHelper$();

    private RenderHelper$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenderHelper$.class);
    }

    public RMLEngine engine() {
        Object object = this.engine$lzy1;
        if (object instanceof RMLEngine) {
            return (RMLEngine)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RMLEngine)this.engine$lzyINIT1();
    }

    private Object engine$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.engine$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RMLEngine rMLEngine = null;
                    try {
                        rMLEngine = (RMLEngine)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RMLEngine.class));
                        object2 = rMLEngine == null ? LazyVals.NullValue$.MODULE$ : rMLEngine;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.engine$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return rMLEngine;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ActivityLog activityLog() {
        Object object = this.activityLog$lzy1;
        if (object instanceof ActivityLog) {
            return (ActivityLog)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActivityLog)this.activityLog$lzyINIT1();
    }

    private Object activityLog$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.activityLog$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActivityLog activityLog = null;
                    try {
                        activityLog = (ActivityLog)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ActivityLog.class));
                        object2 = activityLog == null ? LazyVals.NullValue$.MODULE$ : activityLog;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.activityLog$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return activityLog;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String webStorePrefix() {
        Object object = this.webStorePrefix$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.webStorePrefix$lzyINIT1();
    }

    private Object webStorePrefix$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.webStorePrefix$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).WebURL()), "/") + "/web-store";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.webStorePrefix$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long ExpiresAfterMs() {
        Object object = this.ExpiresAfterMs$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.ExpiresAfterMs$lzyINIT1());
    }

    private Object ExpiresAfterMs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ExpiresAfterMs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Long l = null;
                    try {
                        l = BoxesRunTime.boxToLong((long)((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).config().getDuration("ambience.rml-engine.web-store-expiry", TimeUnit.MILLISECONDS));
                        object2 = l == null ? LazyVals.NullValue$.MODULE$ : l;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ExpiresAfterMs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return l;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<GravityResponse> run(UserDB.User user, String filename, Path rml, Map<String, String> params, Map<String, String> renderDetails, RenderRML.RenderMode renderMode) {
        String mimeType = this.getMimeType(params);
        String ext = this.getExtension(mimeType);
        String newFilename = Path$.MODULE$.apply(filename).withExtension(ext).name();
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.run$$anonfun$1(rml, user);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)AuthWrapper$.MODULE$.withUser(user, () -> this.run$$anonfun$2$$anonfun$1(params, renderDetails, rml, mimeType, user, renderMode, newFilename))).map((Function1 & Serializable)response -> response);
        });
    }

    public boolean useWebStore(String mimeType, RenderRML.RenderMode renderMode) {
        return renderMode.webstore() || !renderMode.api() && RenderRMLUI$.MODULE$.LeftRenderMimeTypes().contains((Object)mimeType);
    }

    public String getMimeType(Map<String, String> params) {
        return (String)params.getOrElse((Object)"mimeType", this::getMimeType$$anonfun$1);
    }

    public String getExtension(String mimeType) {
        return MimeInfo$.MODULE$.extension(MimeType$.MODULE$.apply(mimeType));
    }

    public Gravity.Header getContentDispositionType(Map<String, String> params, String filename) {
        Option option = params.get((Object)"contentDisposition");
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            if ("inline".equals(string)) {
                return GravityResponse.ContentDisposition$.MODULE$.inline(filename);
            }
            if ("attachment".equals(string)) {
                return GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
            }
        }
        return GravityResponse.ContentDisposition$.MODULE$.inline(filename);
    }

    public Task<GravityResponse> directReturn(Map<String, String> params, String newFilename, ReportEngine.Report result) {
        return Task$.MODULE$.apply(() -> this.directReturn$$anonfun$1(result, params, newFilename));
    }

    public Task<GravityResponse> webStoreReturn(String newFilename, ReportEngine.Report result, RenderRML.RenderMode renderMode) {
        if (MimeTypes$.MODULE$.isArchiveMimeType(result.metadata().mimeType())) {
            return this.webStoreReturnZip(result, renderMode);
        }
        return this.webStoreReturnSimple(newFilename, result, renderMode);
    }

    public Task<GravityResponse> webStoreReturnSimple(String newFilename, ReportEngine.Report result, RenderRML.RenderMode renderMode) {
        WebStore webStore = (WebStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(WebStore.class));
        String uuid = UUID.randomUUID().toString();
        String id = uuid + "/" + newFilename;
        return webStore.add(id, (DataBytes)result.bytes(), (WebStore.Expires)WebStore.Expires$.AfterMs$.MODULE$.apply(this.ExpiresAfterMs())).map((Function1 & Serializable)_$1 -> {
            String target = this.buildWebStoreTarget(id);
            return this.buildLocationResponse(target, renderMode);
        });
    }

    public Task<GravityResponse> webStoreReturnZip(ReportEngine.Report result, RenderRML.RenderMode renderMode) {
        WebStore webStore = (WebStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(WebStore.class));
        String uuid = UUID.randomUUID().toString();
        Option option = File$.MODULE$.newTemporaryFile$default$3();
        File tempFile = File$.MODULE$.newTemporaryFile("web-", ".zip", option, File$.MODULE$.newTemporaryFile$default$4("web-", ".zip", option));
        return DataBytesHelper$.MODULE$.writeToFile(tempFile, (DataBytes)result.bytes()).flatMap((Function1 & Serializable)_$2 -> {
            Function1 function1 = tempFile.unzip$default$1();
            File zdir = tempFile.unzip(function1, tempFile.unzip$default$2(function1));
            return this.add(webStore, uuid, (WebStore.Expires)WebStore.Expires$.AfterMs$.MODULE$.apply(this.ExpiresAfterMs()), zdir, (Iterator<File>)zdir.listRecursively(zdir.listRecursively$default$1())).map((Function1 & Serializable)_$3 -> {
                zdir.delete(true, zdir.delete$default$2());
                tempFile.delete(true, tempFile.delete$default$2());
                String target = this.buildWebStoreTarget(uuid) + "/index.html";
                return this.buildLocationResponse(target, renderMode);
            });
        });
    }

    public String buildWebStoreTarget(String id) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])id.split("/"));
        String encoded = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$0 -> Encode.forUriComponent((String)x$0), ClassTag$.MODULE$.apply(String.class))).mkString("/");
        return this.webStorePrefix() + "/" + encoded;
    }

    public GravityResponse buildLocationResponse(String target, RenderRML.RenderMode renderMode) {
        if (renderMode.api()) {
            this.log().info(() -> this.buildLocationResponse$$anonfun$1(target), Line$.MODULE$.apply(124), FullName$.MODULE$.apply("ambience.rmlengine.RenderHelper.buildLocationResponse"));
            return GravityResponse$.MODULE$.text(target);
        }
        this.log().info(() -> this.buildLocationResponse$$anonfun$2(target), Line$.MODULE$.apply(128), FullName$.MODULE$.apply("ambience.rmlengine.RenderHelper.buildLocationResponse"));
        return Gravity$.MODULE$.TempRedirectResponse(target);
    }

    public Task<BoxedUnit> add(WebStore webStore, String uuid, WebStore.Expires expiry, File zdir, Iterator<File> it) {
        while (it.hasNext()) {
            File f = (File)it.next();
            if (f.isDirectory(f.isDirectory$default$1())) continue;
            String id = uuid + "/" + zdir.path().relativize(f.path()).toString();
            this.log().info(() -> this.add$$anonfun$1(id), Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.rmlengine.RenderHelper.add"));
            return webStore.add(id, (DataBytes)FullDataBytes$.MODULE$.apply(f.byteArray()), expiry).flatMap((Function1 & Serializable)_$4 -> this.add(webStore, uuid, expiry, zdir, it));
        }
        return Task$.MODULE$.unit();
    }

    private final Object run$$anonfun$1$$anonfun$1(Path rml$2, UserDB.User user$2) {
        return "render " + rml$2.toString() + " for user " + user$2.name();
    }

    private final void run$$anonfun$1(Path rml$1, UserDB.User user$1) {
        this.log().info(() -> this.run$$anonfun$1$$anonfun$1(rml$1, user$1), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.rmlengine.RenderHelper.run"));
    }

    private final Object run$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(Path rml$6, UserDB.User user$6, ReportEngine.Error err$1) {
        return "Report rendering " + rml$6.toString() + " for user " + user$6.name() + " failed: " + err$1.value();
    }

    private final Task run$$anonfun$2$$anonfun$1(Map params$2, Map renderDetails$2, Path rml$4, String mimeType$2, UserDB.User user$4, RenderRML.RenderMode renderMode$2, String newFilename$2) {
        Json json = Json$.MODULE$.fromFields((Iterable)params$2.toList().map((Function1 & Serializable)kv -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString((String)kv._2()));
        }));
        Json renderDetailsJson = Json$.MODULE$.fromFields((Iterable)renderDetails$2.toList().map((Function1 & Serializable)kv -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString((String)kv._2()));
        }));
        ReportEngine.Request request = ReportEngine.Request$.MODULE$.apply(ReportEngine.TemplatePath$.MODULE$.apply(rml$4.toString()), MimeType$.MODULE$.apply(mimeType$2), json, renderDetailsJson);
        return this.engine().queueReport(user$4, request).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                ReportEngine.Report result = (ReportEngine.Report)((Right)either).value();
                return (this.useWebStore(mimeType$2, renderMode$2) ? this.webStoreReturn(newFilename$2, result, renderMode$2) : this.directReturn((Map<String, String>)params$2, newFilename$2, result)).map((Function1 & Serializable)ret -> ret);
            }
            if (either instanceof Left) {
                ReportEngine.Error err = (ReportEngine.Error)((Left)either).value();
                this.log().error(() -> this.run$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(rml$4, user$4, err), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.rmlengine.RenderHelper.run"));
                return Gravity$.MODULE$.BadRequestResponseT(err.value());
            }
            throw new MatchError((Object)either);
        });
    }

    private final String getMimeType$$anonfun$1() {
        return MimeTypes$.MODULE$.PDF().value();
    }

    private final GravityResponse directReturn$$anonfun$1(ReportEngine.Report result$1, Map params$4, String newFilename$4) {
        IJobLog jobLog = JobLogStorage$.MODULE$.load(result$1.metadata().jobLog());
        Gravity.Header cd = this.getContentDispositionType((Map<String, String>)params$4, newFilename$4);
        Gravity.Header mediaType = Gravity.Header$.MODULE$.ContentType(result$1.metadata().mimeType().value());
        Gravity.Headers headers = new Gravity.Headers(JobHelper$.MODULE$.jobHeaders(jobLog).$colon$colon((Object)mediaType).$colon$colon((Object)cd));
        return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), headers, (DataBytes)result$1.bytes());
    }

    private final Object buildLocationResponse$$anonfun$1(String target$1) {
        return "Replying with " + target$1;
    }

    private final Object buildLocationResponse$$anonfun$2(String target$2) {
        return "Redirecting to " + target$2;
    }

    private final Object add$$anonfun$1(String id$2) {
        return "Adding " + id$2;
    }
}

