/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository;

import ambience.module.UserDB;
import ambience.repository.InlineView$;
import ambience.repository.RepositoryAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import laika.api.Transformer;
import laika.parse.markup.DocumentParser;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class InlineView
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InlineView.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final RepositoryAPI api;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(InlineView$.class.getDeclaredField("MarkdownTransformer$lzy1"));

    public static Transformer MarkdownTransformer() {
        return InlineView$.MODULE$.MarkdownTransformer();
    }

    public InlineView(RepositoryAPI api) {
        this.api = api;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> getInline(UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Option option = request.parameter("path");
            if (option instanceof Some) {
                String pathString = (String)((Some)option).value();
                Path path = Path$.MODULE$.apply(pathString);
                return this.api.readFileT(user, path).map((Function1 & Serializable)bytes -> {
                    this.log().info(() -> InlineView.getInline$$anonfun$1$$anonfun$1$$anonfun$1(user, path, bytes), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.repository.InlineView.getInline"));
                    return this.buildResponse(path, (byte[])bytes);
                }).onErrorRecover((PartialFunction)new Serializable(path, this){
                    private final Path path$3;
                    private final /* synthetic */ InlineView $outer;
                    {
                        this.path$3 = path$4;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.repository.InlineView.getInline"));
                        return Gravity$.MODULE$.NotFoundResponse();
                    }

                    private final Object applyOrElse$$anonfun$1(Throwable x$1) {
                        return "repository/inline path " + this.path$3 + " exception: " + x$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                    }
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Missing parameter 'path'");
            }
            throw new MatchError((Object)option);
        };
    }

    public GravityResponse buildResponse(Path path, byte[] bytes) {
        Gravity.Header cd = GravityResponse.ContentDisposition$.MODULE$.inline(path.name());
        if (path.extension().map((Function1 & Serializable)_$1 -> _$1.toLowerCase()).contains((Object)"md")) {
            String md = new String(bytes, Gravity$.MODULE$.UTF_8());
            Either either = InlineView$.MODULE$.MarkdownTransformer().transform(md);
            if (either instanceof Right) {
                String value = (String)((Right)either).value();
                String html = this.fixBase(value);
                return GravityResponse$.MODULE$.html(html).withHeader(cd);
            }
            if (either instanceof Left) {
                DocumentParser.TransformationError ex = (DocumentParser.TransformationError)((Left)either).value();
                return GravityResponse$.MODULE$.text("[" + ex + "]\n\n" + md).withHeader(cd);
            }
            throw new MatchError((Object)either);
        }
        Gravity.Header ct = Gravity.Header$.MODULE$.ContentType(MimeInfo$.MODULE$.mimeType(path).value());
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{ct, cd}));
        DataBytes dataBytes = DataBytes$.MODULE$.apply(bytes);
        int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    public String fixBase(String html) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<!DOCTYPE html>\n        |<html>\n        |<head>\n        |<base href=\"../..\">\n        |</head>\n        |<body>\n        |")));
        sb.append(html);
        sb.append("\n</body>\n</html>");
        return sb.toString();
    }

    private static final Object getInline$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$3, Path path$2, byte[] bytes$1) {
        return user$3.name() + " viewing " + path$2 + " (" + bytes$1.length + " bytes)";
    }
}

