/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository;

import ambience.api.Repository;
import ambience.chunk.ChunkAPI;
import ambience.module.UserDB;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.RepositoryModule;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.CreateIfNotExists$;
import ambience.repository.actions.DeleteFile$;
import ambience.repository.actions.DeleteFile$Info$;
import ambience.repository.actions.DeleteFolder$;
import ambience.repository.actions.DeleteFolder$Info$;
import ambience.repository.actions.GetByExtension$;
import ambience.repository.actions.GetByTag$;
import ambience.repository.actions.GetByTag$All$;
import ambience.repository.actions.GetByTag$Files$;
import ambience.repository.actions.GetByTag$Folders$;
import ambience.repository.actions.WriteFile$;
import com.elixirtech.arch.Path;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class RepositoryAPI
implements Repository {
    private final RepositoryModule module;

    public RepositoryAPI(RepositoryModule module) {
        this.module = module;
    }

    public Task<Repository.FileData> readFileDataT(UserDB.User user, Path path) {
        Task omd = Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)optItem -> this.readableFile((AccessChecker)checker, (Option<Metadata.Item>)optItem).map((Function1 & Serializable)optMetadata -> optMetadata)));
        return omd.flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Metadata.File md = (Metadata.File)((Some)option).value();
                return this.bytesChunkBuilder((Observable<ChunkAPI.Chunk>)this.module.chunkDB().read(md.chunkIds())).map((Function1 & Serializable)bytes -> Repository.FileData$.MODULE$.apply(path, md.lastModified(), bytes));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.raiseError((Throwable)new RuntimeException("File not found (user=" + user.name() + "): " + path.toString()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<Repository.FileData>> readFileDataIfModifiedT(UserDB.User user, Path path, long lastModified) {
        Task omd = Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)optItem -> this.readableFile((AccessChecker)checker, (Option<Metadata.Item>)optItem).map((Function1 & Serializable)optMetadata -> optMetadata)));
        return omd.flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Metadata.File md = (Metadata.File)((Some)option).value();
                if (md.lastModified() == lastModified) {
                    return Task$.MODULE$.now((Object)None$.MODULE$);
                }
                return this.bytesChunkBuilder((Observable<ChunkAPI.Chunk>)this.module.chunkDB().read(md.chunkIds())).map((Function1 & Serializable)bytes -> Some$.MODULE$.apply((Object)Repository.FileData$.MODULE$.apply(path, md.lastModified(), bytes)));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.raiseError((Throwable)new RuntimeException("File not found (user=" + user.name() + "): " + path.toString()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Observable<byte[]> readFileO(UserDB.User user, Path path) {
        Task omd = Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)optItem -> this.readableFile((AccessChecker)checker, (Option<Metadata.Item>)optItem).map((Function1 & Serializable)optMetadata -> optMetadata)));
        return Observable$.MODULE$.fromTask(omd).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Metadata.File md = (Metadata.File)((Some)option).value();
                return this.module.chunkDB().read(md.chunkIds()).map((Function1 & Serializable)_$1 -> _$1.bytes());
            }
            if (None$.MODULE$.equals(option)) {
                return Observable$.MODULE$.raiseError((Throwable)new RuntimeException("File not found (user=" + user.name() + "): " + path.toString()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<byte[]> readFileT(UserDB.User user, Path path) {
        return this.bytesBuilder(this.readFileO(user, path));
    }

    public Task<BoxedUnit> writeFileT(UserDB.User user, Path path, byte[] data) {
        return this.writeFileT(user, path, (Observable<byte[]>)Observable$.MODULE$.now((Object)data));
    }

    public Task<BoxedUnit> writeFileT(UserDB.User user, Path path, Observable<byte[]> data) {
        return WriteFile$.MODULE$.apply(user, path, data).map((Function1)(JProcedure1 & Serializable)reply -> {
            if (reply.close()) {
                return;
            }
            throw new RuntimeException("writeFileT(" + user.name() + "," + path + ") " + reply.alertType() + ": " + reply.message());
        });
    }

    public Task<Object> createFolderT(UserDB.User user, Path path) {
        return CreateIfNotExists$.MODULE$.ensureExists(user, path).map((Function1 & Serializable)reply -> reply.close());
    }

    public Task<Object> deleteFileT(UserDB.User user, Path path) {
        return DeleteFile$.MODULE$.run(user, DeleteFile$Info$.MODULE$.apply(path.toString())).map((Function1 & Serializable)reply -> reply.close());
    }

    public Task<Object> deleteFolderT(UserDB.User user, Path path) {
        return DeleteFolder$.MODULE$.run(user, DeleteFolder$Info$.MODULE$.apply(path.toString())).map((Function1 & Serializable)reply -> reply.close());
    }

    public Task<Option<Repository.RItem>> getItemT(UserDB.User user, Path path) {
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> checker.canRead(path).flatMap((Function1 & Serializable)ok -> this.getItemT$$anonfun$1$$anonfun$1(path, BoxesRunTime.unboxToBoolean((Object)ok))));
    }

    public Observable<Path> getByTagO(UserDB.User user, String tag) {
        return GetByTag$.MODULE$.run(user, tag, GetByTag$All$.MODULE$);
    }

    public Observable<Path> getFilesByTagO(UserDB.User user, String tag) {
        return GetByTag$.MODULE$.run(user, tag, GetByTag$Files$.MODULE$);
    }

    public Observable<Path> getFoldersByTagO(UserDB.User user, String tag) {
        return GetByTag$.MODULE$.run(user, tag, GetByTag$Folders$.MODULE$);
    }

    public Observable<Path> getByExtensionO(UserDB.User user, String ext) {
        return GetByExtension$.MODULE$.run(user, ext);
    }

    public Observable<Repository.RItem> getChildrenO(UserDB.User user, Path path) {
        return Observable$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)t -> AccessChecker$.MODULE$.readO((AccessChecker)checker, (Function1 & Serializable)_$2 -> _$2.path(), t)})).flatMap((Function1 & Serializable)readChecker -> Metadata$.MODULE$.repository().findO(ActionHelper$.MODULE$.childFilter(path)).flatMap((Function1 & Serializable)child -> Metadata$.MODULE$.toItemO((Document)child).map((Function1 & Serializable)item -> this.toRItem((Metadata.Item)item)).flatMap((Function1 & Serializable)item -> ((Observable)readChecker.apply(item)).map((Function1 & Serializable)visible -> visible)))));
    }

    public Observable<Repository.RItem> getDescendantsO(UserDB.User user, Path path) {
        return Observable$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)t -> AccessChecker$.MODULE$.readO((AccessChecker)checker, (Function1 & Serializable)_$3 -> _$3.path(), t)})).flatMap((Function1 & Serializable)readChecker -> Metadata$.MODULE$.repository().findO(ActionHelper$.MODULE$.descendantsFilter(path)).flatMap((Function1 & Serializable)child -> Metadata$.MODULE$.toItemO((Document)child).map((Function1 & Serializable)item -> this.toRItem((Metadata.Item)item)).flatMap((Function1 & Serializable)item -> ((Observable)readChecker.apply(item)).map((Function1 & Serializable)visible -> visible)))));
    }

    public Task<Object> canReadT(UserDB.User user, Path path) {
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> checker.canRead(path).map((Function1 & Serializable)ok -> BoxesRunTime.unboxToBoolean((Object)ok)));
    }

    public Task<Object> canWriteT(UserDB.User user, Path path) {
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> checker.canWrite(path).map((Function1 & Serializable)ok -> BoxesRunTime.unboxToBoolean((Object)ok)));
    }

    private Task<Option<Metadata.File>> readableFile(AccessChecker checker, Option<Metadata.Item> optF) {
        Option option = optF.flatMap((Function1 & Serializable)md -> Metadata$.MODULE$.optFile((Metadata.Item)md));
        if (option instanceof Some) {
            Metadata.File f = (Metadata.File)((Some)option).value();
            return checker.canRead(f.path()).map((Function1 & Serializable)ok -> RepositoryAPI.readableFile$$anonfun$2(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private Repository.RItem toRItem(Metadata.Item item) {
        Metadata.Item item2 = item;
        if (item2 instanceof Metadata.File) {
            Metadata.File f = (Metadata.File)item2;
            return Repository.RFile$.MODULE$.apply(f.path(), (Set)f.tags().values().map((Function1 & Serializable)_$4 -> _$4.value()), f.length(), f.lastModified());
        }
        if (item2 instanceof Metadata.Folder) {
            Metadata.Folder f = (Metadata.Folder)item2;
            return Repository.RFolder$.MODULE$.apply(f.path(), (Set)f.tags().values().map((Function1 & Serializable)_$5 -> _$5.value()));
        }
        throw new MatchError((Object)item2);
    }

    private Task<byte[]> bytesChunkBuilder(Observable<ChunkAPI.Chunk> o) {
        return this.bytesBuilder((Observable<byte[]>)o.map((Function1 & Serializable)_$6 -> _$6.bytes()));
    }

    private Task<byte[]> bytesBuilder(Observable<byte[]> o) {
        return o.toListL().map((Function1 & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return Array$.MODULE$.emptyByteArray();
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                byte[] head = (byte[])colon2.head();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    return head;
                }
            }
            List bytesList = list;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bytesList.foreach((Function1)(JProcedure1 & Serializable)bytes -> baos.write((byte[])bytes));
            return baos.toByteArray();
        });
    }

    private final /* synthetic */ Task getItemT$$anonfun$1$$anonfun$1(Path path$11, boolean ok) {
        return (ok ? Metadata$.MODULE$.apply(path$11) : Task$.MODULE$.now((Object)None$.MODULE$)).map((Function1 & Serializable)optItem -> optItem.map((Function1 & Serializable)item -> this.toRItem((Metadata.Item)item)));
    }

    private static final /* synthetic */ Option readableFile$$anonfun$2(Metadata.File f$1, boolean ok) {
        if (ok) {
            return Some$.MODULE$.apply((Object)f$1);
        }
        return None$.MODULE$;
    }
}

