/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.PanelExtras;
import ambience.repository.PanelExtras$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.DeleteFile$;
import ambience.repository.actions.DeleteFile$Info$;
import ambience.repository.actions.DeleteFolder;
import ambience.repository.actions.DeleteFolder$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.mongodb.client.result.DeleteResult;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class DeleteFolder$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DeleteFolder$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final DeleteFolder$Info$ Info;
    public static final DeleteFolder$ MODULE$;

    private DeleteFolder$() {
    }

    static {
        MODULE$ = new DeleteFolder$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeleteFolder$.class);
    }

    public Panel panel(Path path) {
        PanelExtras.DeleteWarningSetup deleteWarningSetup = (PanelExtras.DeleteWarningSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)PanelExtras.DeleteWarningSetup$.MODULE$.apply(path.toString()));
        String string = "path";
        Json setup = package.EncoderOps$.MODULE$.asJson$extension((Object)deleteWarningSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{Panel.Item$.MODULE$.apply(PanelExtras$.MODULE$.DeleteWarning(), "", "", setup)})));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        boolean size = true;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), this::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::apply$$anonfun$3)))));
        if (either instanceof Right) {
            DeleteFolder.Info info = (DeleteFolder.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> this.apply$$anonfun$4(json, err), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("ambience.repository.actions.DeleteFolder.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), false));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, DeleteFolder.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            DeleteFolder.Info info = (DeleteFolder.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "delete-folder", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<String> getDeleteWarning(Path path) {
        FindOptions options = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path", "type"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        Bson withPrefix = ActionHelper$.MODULE$.descendantsFilter(path);
        return Metadata$.MODULE$.repository().findO(withPrefix, options).toListL().flatMap((Function1 & Serializable)all -> Task$.MODULE$.apply(() -> this.getDeleteWarning$$anonfun$1$$anonfun$1(all)).map((Function1 & Serializable)pair -> {
            String msg1 = "<p>This action will delete " + this.countItems(((SeqOps)pair._1()).size(), "file") + " and " + this.countItems(((SeqOps)pair._2()).size() + 1, "folder") + "</p>";
            String msg2 = "<p>Are you sure?</p>";
            return msg1 + msg2;
        }));
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, DeleteFolder.Info info) {
        Path path = Path$.MODULE$.apply(info.path());
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)item -> this.canDelete((AccessChecker)checker, (Option<Metadata.Item>)item).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = this.doRun(user, info);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        })));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canDelete(AccessChecker checker, Option<Metadata.Item> item) {
        Metadata.Item item2;
        Option<Metadata.Item> option = item;
        if (option instanceof Some && (item2 = (Metadata.Item)((Some)option).value()) instanceof Metadata.Folder) {
            Metadata.Folder f = (Metadata.Folder)item2;
            return checker.canWrite(f.path()).map((Function1 & Serializable)ok -> this.canDelete$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(UserDB.User user, DeleteFolder.Info info) {
        FindOptions options = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path", "type"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        Bson withPrefix = ActionHelper$.MODULE$.thisOrDescendantsFilter(Path$.MODULE$.apply(info.path()));
        return Metadata$.MODULE$.repository().findO(withPrefix, options).toListL().flatMap((Function1 & Serializable)all -> Task$.MODULE$.apply(() -> this.doRun$$anonfun$1$$anonfun$1(all)).flatMap((Function1 & Serializable)pair -> this.deleteFiles(user, this.getPaths((List<Document>)((List)pair._1()))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.deleteFolders(this.getPaths((List<Document>)((List)pair._2()))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                String msg = "Deleted " + this.countItems(((SeqOps)pair._1()).size(), "file") + " and " + this.countItems(((SeqOps)pair._2()).size(), "folder");
                return RepositoryModel.ActionResult$.MODULE$.apply("info", msg, (Option)Some$.MODULE$.apply((Object)Path$.MODULE$.apply(info.path()).parent().toString()), true);
            });
        })));
    }

    public Task<BoxedUnit> deleteFiles(UserDB.User user, List<String> files) {
        List<String> list = files;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list3;
            return DeleteFile$.MODULE$.doRun(user, DeleteFile$Info$.MODULE$.apply(head)).flatMap((Function1 & Serializable)_$1 -> this.deleteFiles(user, (List<String>)tail));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> deleteFolders(List<String> folders) {
        List<String> list = folders;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list3;
            return this.deleteFolder(head).flatMap((Function1 & Serializable)_$2 -> this.deleteFolders((List<String>)tail));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> deleteFolder(String folder) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.deleteFolder$$anonfun$1(folder);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Metadata$.MODULE$.repository().deleteOneT(Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(folder))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                DeleteResult deleteResult = x$1;
            });
        });
    }

    public boolean isFile(Document doc) {
        return doc.get("type", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).contains((Object)"file");
    }

    public List<String> getPaths(List<Document> docs) {
        return docs.flatMap((Function1 & Serializable)doc -> this.getPath((Document)doc));
    }

    public Option<String> getPath(Document doc) {
        return doc.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue());
    }

    public String countItems(int count, String item) {
        if (count == 1) {
            return "1 " + item;
        }
        return count + " " + item + "s";
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List apply$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 apply$$anonfun$2() {
        DeleteFolder$Info$ deleteFolder$Info$ = DeleteFolder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (DeleteFolder.Info)deleteFolder$Info$.fromProduct((Product)p);
    }

    private final Product apply$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    private final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private final List auditRun$$anonfun$1$$anonfun$1() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Tuple2 getDeleteWarning$$anonfun$1$$anonfun$1(List all$1) {
        return all$1.partition((Function1 & Serializable)doc -> this.isFile((Document)doc));
    }

    private final /* synthetic */ Either canDelete$$anonfun$1(Metadata.Folder f$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)f$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not deletable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Tuple2 doRun$$anonfun$1$$anonfun$1(List all$2) {
        return all$2.partition((Function1 & Serializable)doc -> this.isFile((Document)doc));
    }

    private final Object deleteFolder$$anonfun$1$$anonfun$1(String folder$2) {
        return "Deleting " + folder$2;
    }

    private final void deleteFolder$$anonfun$1(String folder$1) {
        this.log().info(() -> this.deleteFolder$$anonfun$1$$anonfun$1(folder$1), Line$.MODULE$.apply(106), FullName$.MODULE$.apply("ambience.repository.actions.DeleteFolder.deleteFolder"));
    }
}

