/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.PanelExtras;
import ambience.repository.PanelExtras$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.MoveFile;
import ambience.repository.actions.MoveFile$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class MoveFile$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(MoveFile$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final MoveFile$Info$ Info;
    public static final MoveFile$ MODULE$;

    private MoveFile$() {
    }

    static {
        MODULE$ = new MoveFile$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MoveFile$.class);
    }

    public Panel panel(UserDB.User user) {
        PanelExtras.FolderChooserSetup folderChooserSetup = (PanelExtras.FolderChooserSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)PanelExtras.FolderChooserSetup$.MODULE$.apply("/User/" + user.name()));
        String string = "value";
        Json setup = package.EncoderOps$.MODULE$.asJson$extension((Object)folderChooserSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{Panel.Item$.MODULE$.apply(PanelExtras$.MODULE$.FolderChooser(), "newParent", "Target Folder", setup)})));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "newParent";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::apply$$anonfun$3)))));
        if (either instanceof Right) {
            MoveFile.Info info = (MoveFile.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> this.apply$$anonfun$4(json, err), Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), false));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, MoveFile.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            MoveFile.Info info = (MoveFile.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "newParent";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "move-file", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, MoveFile.Info info) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = Path$.MODULE$.apply(info.newParent());
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newFolder -> Metadata$.MODULE$.apply(newPath.$div(oldPath.name())).flatMap((Function1 & Serializable)newFile -> this.canMove((AccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newFolder, (Option<Metadata.Item>)newFile).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = this.doRun(info);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        })))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canMove(AccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newFolder, Option<Metadata.Item> newFile) {
        Metadata.Item item;
        if (newFile.isDefined()) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target file already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.File) {
            Metadata.Item item2;
            Metadata.File f = (Metadata.File)item;
            Option<Metadata.Item> option2 = newFolder;
            if (option2 instanceof Some && (item2 = (Metadata.Item)((Some)option2).value()) instanceof Metadata.Folder) {
                Metadata.Folder newParent = (Metadata.Folder)item2;
                return checker.canWrite(newParent.path()).map((Function1 & Serializable)ok -> this.canMove$$anonfun$1(newParent, BoxesRunTime.unboxToBoolean((Object)ok)));
            }
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a file", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(MoveFile.Info info) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = Path$.MODULE$.apply(info.newParent()).$div(oldPath.name());
        Task result = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$2(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.moveFile(oldPath, newPath).map((Function1 & Serializable)reply -> reply);
        });
        return result.onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> this.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    public Path getUniqueName(Path newParent, List<Document> children, String name) {
        Set pathSet = children.flatMap((Function1 & Serializable)_$1 -> _$1.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$2 -> _$2.getValue()).toSet();
        return newParent.$div(this.getNewName((Set<String>)pathSet, newParent, name));
    }

    public String getNewName(Set<String> pathSet, Path newParent, String name) {
        Object workingName = name;
        if (pathSet.contains((Object)newParent.$div((String)workingName).toString())) {
            String newname = (String)workingName + " (Copy)";
            int i = 1;
            while (pathSet.contains((Object)newParent.$div(newname).toString())) {
                newname = (String)workingName + " (Copy " + ++i + ")";
            }
            workingName = newname;
        }
        return workingName;
    }

    public Task<RepositoryModel.ActionResult> moveFile(Path oldPath, Path newPath) {
        Bson update = Updates$.MODULE$.set("path", (Object)BsonString$.MODULE$.apply(newPath.toString()));
        return Metadata$.MODULE$.repository().updateOneT(Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(oldPath.toString())), update).map((Function1 & Serializable)reply -> {
            if (reply.getModifiedCount() == 1L) {
                return RepositoryModel.ActionResult$.MODULE$.apply("info", "File moved successfully", (Option)Some$.MODULE$.apply((Object)oldPath.parent().toString()), true);
            }
            return RepositoryModel.ActionResult$.MODULE$.apply("warn", "File move failed - file no longer available", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List apply$$anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 apply$$anonfun$2() {
        MoveFile$Info$ moveFile$Info$ = MoveFile$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MoveFile.Info)moveFile$Info$.fromProduct((Product)p);
    }

    private final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private final List auditRun$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        void var2_1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final /* synthetic */ Either canMove$$anonfun$1(Metadata.Folder newParent$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)newParent$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target folder is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Object $anonfun$2$$anonfun$1(Path oldPath$5, Path newPath$5) {
        return "Moving " + oldPath$5.toString() + " to " + newPath$5.toString();
    }

    private final void $anonfun$2(Path oldPath$4, Path newPath$4) {
        this.log().info(() -> this.$anonfun$2$$anonfun$1(oldPath$4, newPath$4), Line$.MODULE$.apply(83), FullName$.MODULE$.apply("ambience.repository.actions.MoveFile.result"));
    }

    private final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }
}

