/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.PanelExtras;
import ambience.repository.PanelExtras$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.MoveFolder;
import ambience.repository.actions.MoveFolder$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.mongodb.client.result.UpdateResult;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class MoveFolder$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(MoveFolder$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final MoveFolder$Info$ Info;
    public static final MoveFolder$ MODULE$;

    private MoveFolder$() {
    }

    static {
        MODULE$ = new MoveFolder$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MoveFolder$.class);
    }

    public Panel panel(UserDB.User user) {
        PanelExtras.FolderChooserSetup folderChooserSetup = (PanelExtras.FolderChooserSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)PanelExtras.FolderChooserSetup$.MODULE$.apply("/User/" + user.name()));
        String string = "value";
        Json setup = package.EncoderOps$.MODULE$.asJson$extension((Object)folderChooserSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{Panel.Item$.MODULE$.apply(PanelExtras$.MODULE$.FolderChooser(), "newParent", "Target Folder", setup)})));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "newParent";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::apply$$anonfun$3)))));
        if (either instanceof Right) {
            MoveFolder.Info info = (MoveFolder.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> this.apply$$anonfun$4(json, err), Line$.MODULE$.apply(31), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, MoveFolder.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            MoveFolder.Info info = (MoveFolder.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "newParent";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "move-folder", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, MoveFolder.Info info) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = Path$.MODULE$.apply(info.newParent());
        if (newPath.toString().startsWith(oldPath.toString())) {
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Target folder cannot be a descendent of the source", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        Path newChildPath = newPath.$div(oldPath.name());
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newFolder -> Metadata$.MODULE$.apply(newChildPath).flatMap((Function1 & Serializable)newChild -> this.canMove((AccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newFolder, (Option<Metadata.Item>)newChild).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                Metadata.Folder newParent = (Metadata.Folder)((Right)either).value();
                task = this.doRun(info, newParent);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        })))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canMove(AccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newFolder, Option<Metadata.Item> newChild) {
        if (newChild.isDefined()) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target folder already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && ((Some)option).value() instanceof Metadata.Folder) {
            Metadata.Item item;
            Option<Metadata.Item> option2 = newFolder;
            if (option2 instanceof Some && (item = (Metadata.Item)((Some)option2).value()) instanceof Metadata.Folder) {
                Metadata.Folder newParent = (Metadata.Folder)item;
                return checker.canWrite(newParent.path()).map((Function1 & Serializable)ok -> this.canMove$$anonfun$1(newParent, BoxesRunTime.unboxToBoolean((Object)ok)));
            }
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(MoveFolder.Info info, Metadata.Folder newParent) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = newParent.path().$div(oldPath.name());
        Task result = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$2(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.moveFolder(oldPath, newPath).flatMap((Function1 & Serializable)reply -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.$anonfun$3$$anonfun$1$$anonfun$1(oldPath, newPath);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (reply.close() ? this.moveFolderChildren(oldPath, newPath) : Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)0))).flatMap((Function1 & Serializable)count -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(count);
                    return BoxedUnit.UNIT;
                }).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return reply;
                }));
            }));
        });
        return result.onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> this.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    public Task<RepositoryModel.ActionResult> moveFolder(Path oldPath, Path newPath) {
        return Metadata$.MODULE$.repository().findO(Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(oldPath.toString()))).firstOptionL().flatMap((Function1 & Serializable)optDoc -> {
            Task task;
            Option option = optDoc;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option<Bson> option2 = this.update(doc, oldPath, newPath);
                if (option2 instanceof Some) {
                    Bson up = (Bson)((Some)option2).value();
                    task = Metadata$.MODULE$.repository().updateOneT(this.filter(doc), up).map((Function1 & Serializable)_$1 -> RepositoryModel.ActionResult$.MODULE$.apply("info", "Folder moved successfully", (Option)Some$.MODULE$.apply((Object)newPath.toString()), true));
                    return task.map((Function1 & Serializable)reply -> reply);
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    this.log().warn(() -> this.moveFolder$$anonfun$1$$anonfun$2(oldPath), Line$.MODULE$.apply(111), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.moveFolder"));
                    task = Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Folder move failed - folder path not available", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
                }
                return task.map((Function1 & Serializable)reply -> reply);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                this.log().warn(() -> this.moveFolder$$anonfun$1$$anonfun$3(oldPath), Line$.MODULE$.apply(115), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.moveFolder"));
                task = Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Folder move failed - folder no longer available", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
            }
            return task.map((Function1 & Serializable)reply -> reply);
        });
    }

    public Task<Object> moveFolderChildren(Path oldPath, Path newPath) {
        Observable all = Metadata$.MODULE$.repository().findO(ActionHelper$.MODULE$.descendantsFilter(oldPath)).flatMap((Function1 & Serializable)doc -> {
            Observable observable;
            Option<Bson> option = this.update((Document)doc, oldPath, newPath);
            if (option instanceof Some) {
                Bson up = (Bson)((Some)option).value();
                observable = Observable$.MODULE$.fromTask(Metadata$.MODULE$.repository().updateOneT(this.filter((Document)doc), up));
            } else if (None$.MODULE$.equals(option)) {
                observable = Observable$.MODULE$.empty();
            } else {
                throw new MatchError(option);
            }
            return observable.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                UpdateResult updateResult = x$1;
            });
        });
        return all.countL();
    }

    public Bson filter(Document doc) {
        return Filters$.MODULE$.eq("_id", (Object)doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
    }

    public Option<Bson> update(Document doc, Path oldBase, Path newBase) {
        return doc.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)oldPath -> {
            Path newPath = newBase.$div(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(oldPath.getValue()), oldBase.toString()));
            this.log().info(() -> this.update$$anonfun$1$$anonfun$1(oldPath, newPath), Line$.MODULE$.apply(137), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.update"));
            return Updates$.MODULE$.set("path", (Object)BsonString$.MODULE$.apply(newPath.toString()));
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List apply$$anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 apply$$anonfun$2() {
        MoveFolder$Info$ moveFolder$Info$ = MoveFolder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MoveFolder.Info)moveFolder$Info$.fromProduct((Product)p);
    }

    private final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private final List auditRun$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        void var2_1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final /* synthetic */ Either canMove$$anonfun$1(Metadata.Folder newParent$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)newParent$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target folder is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Object $anonfun$2$$anonfun$1(Path oldPath$3, Path newPath$4) {
        return "Moving " + oldPath$3.toString() + " to " + newPath$4.toString();
    }

    private final void $anonfun$2(Path oldPath$2, Path newPath$3) {
        this.log().info(() -> this.$anonfun$2$$anonfun$1(oldPath$2, newPath$3), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.result"));
    }

    private final Object $anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(Path oldPath$7, Path newPath$8) {
        return "Moving children of " + oldPath$7.toString() + " to " + newPath$8.toString();
    }

    private final void $anonfun$3$$anonfun$1$$anonfun$1(Path oldPath$6, Path newPath$7) {
        this.log().info(() -> this.$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(oldPath$6, newPath$7), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.result"));
    }

    private final Object $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Object count$2) {
        return "Move complete (" + count$2 + " children moved)";
    }

    private final void $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Object count$1) {
        this.log().info(() -> this.$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(count$1), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.repository.actions.MoveFolder.result"));
    }

    private final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }

    private final Object moveFolder$$anonfun$1$$anonfun$2(Path oldPath$10) {
        return "Folder copy failed " + oldPath$10 + " record has no path string";
    }

    private final Object moveFolder$$anonfun$1$$anonfun$3(Path oldPath$11) {
        return "Folder copy failed " + oldPath$11 + " no longer available";
    }

    private final Object update$$anonfun$1$$anonfun$1(BsonString oldPath$13, Path newPath$13) {
        return "Moving " + oldPath$13.getValue() + " to " + newPath$13.toString();
    }
}

