/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.FolderActions$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.FolderWarnings$;
import ambience.repository.actions.RenameFolder;
import ambience.repository.actions.RenameFolder$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RenameFolder$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenameFolder$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final RenameFolder$Info$ Info;
    public static final RenameFolder$ MODULE$;

    private RenameFolder$() {
    }

    static {
        MODULE$ = new RenameFolder$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenameFolder$.class);
    }

    public Panel panel(String name) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{Panel.Item$.MODULE$.apply(Panel$.MODULE$.Text(), "name", "Folder Name", FolderActions$.MODULE$.text(name))})));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "name";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::apply$$anonfun$3)))));
        if (either instanceof Right) {
            RenameFolder.Info info = (RenameFolder.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> this.apply$$anonfun$4(json, err), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.repository.actions.RenameFolder.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), false));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, RenameFolder.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            RenameFolder.Info info = (RenameFolder.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "name";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "rename-folder", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, RenameFolder.Info info) {
        Option<RepositoryModel.ActionResult> option = FolderWarnings$.MODULE$.validName(info.name());
        if (option instanceof Some) {
            RepositoryModel.ActionResult reply = (RepositoryModel.ActionResult)((Some)option).value();
            return Task$.MODULE$.apply(() -> this.run$$anonfun$1(reply));
        }
        if (None$.MODULE$.equals(option)) {
            Path oldPath = Path$.MODULE$.apply(info.path());
            Path newPath = oldPath.parent().$div(info.name());
            return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newItem -> this.canRename((AccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newItem).flatMap((Function1 & Serializable)eReply -> {
                Task task;
                Either either = eReply;
                if (either instanceof Right) {
                    task = this.doRun(user, info);
                } else if (either instanceof Left) {
                    RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                    task = Task$.MODULE$.now((Object)reply2);
                } else {
                    throw new MatchError((Object)either);
                }
                return task.map((Function1 & Serializable)reply -> reply);
            }))));
        }
        throw new MatchError(option);
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canRename(AccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newItem) {
        Metadata.Item item;
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.Folder) {
            Metadata.Folder f = (Metadata.Folder)item;
            if (newItem.isDefined()) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "New path already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
            }
            return checker.canWrite(f.path()).map((Function1 & Serializable)ok -> this.canRename$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(UserDB.User user, RenameFolder.Info info) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = oldPath.parent().$div(info.name());
        Bson withId = Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(oldPath.toString()));
        Bson setId = Updates$.MODULE$.set("path", (Object)BsonString$.MODULE$.apply(newPath.toString()));
        Task result = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$1(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Metadata$.MODULE$.repository().findOneAndUpdateT(withId, setId).flatMap((Function1 & Serializable)x$12 -> {
                Option option = x$12;
                return this.updateAllDescendants(oldPath.toString(), newPath.toString()).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return RepositoryModel.ActionResult$.MODULE$.apply("info", "Folder renamed successfully", (Option)Some$.MODULE$.apply((Object)newPath.toString()), true);
                });
            });
        });
        return result.onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> this.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.repository.actions.RenameFolder.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    public Task<BoxedUnit> updateAllDescendants(String oldPath, String newPath) {
        FindOptions options = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        Bson withPrefix = ActionHelper$.MODULE$.descendantsFilter(Path$.MODULE$.apply(oldPath));
        return Metadata$.MODULE$.repository().findO(withPrefix, options).flatMap((Function1 & Serializable)doc -> {
            Option option = doc.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
            if (option instanceof Some) {
                BsonString s = (BsonString)((Some)option).value();
                Bson withPath = Filters$.MODULE$.eq("path", (Object)s);
                String oldId = s.getValue();
                BsonString newId = BsonString$.MODULE$.apply(newPath + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(oldId), oldPath));
                this.log().info(() -> this.updateAllDescendants$$anonfun$1$$anonfun$1(s, newId), Line$.MODULE$.apply(96), FullName$.MODULE$.apply("ambience.repository.actions.RenameFolder.updateAllDescendants"));
                return Observable$.MODULE$.fromIterator(Metadata$.MODULE$.repository().findOneAndUpdateT(withPath, Updates$.MODULE$.set("path", (Object)newId)).map((Function1 & Serializable)_$1 -> _$1.iterator()));
            }
            if (None$.MODULE$.equals(option)) {
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        }).completedL();
    }

    /*
     * WARNING - void declaration
     */
    private final List apply$$anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 apply$$anonfun$2() {
        RenameFolder$Info$ renameFolder$Info$ = RenameFolder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RenameFolder.Info)renameFolder$Info$.fromProduct((Product)p);
    }

    private final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private final List auditRun$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        void var2_1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final RepositoryModel.ActionResult run$$anonfun$1(RepositoryModel.ActionResult reply$1) {
        return reply$1;
    }

    private final /* synthetic */ Either canRename$$anonfun$1(Metadata.Folder f$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)f$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Object $anonfun$1$$anonfun$1(Path oldPath$3, Path newPath$4) {
        return "Renaming " + oldPath$3.toString() + " to " + newPath$4.toString();
    }

    private final void $anonfun$1(Path oldPath$2, Path newPath$3) {
        this.log().info(() -> this.$anonfun$1$$anonfun$1(oldPath$2, newPath$3), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.repository.actions.RenameFolder.result"));
    }

    private final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }

    private final Object updateAllDescendants$$anonfun$1$$anonfun$1(BsonString s$1, BsonString newId$1) {
        return "Renaming " + s$1 + " -> " + newId$1;
    }
}

