/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.etl;

import ambience.api.Repository;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.Builder$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.etl.FileWriter;
import ambience.repository.etl.FileWriter$Info$;
import ambience.repository.etl.FileWriter$State$;
import ambience.repository.etl.RepositoryCategory$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileWriter$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileWriter$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Clock clock;
    public static final FileWriter$Info$ Info;
    public static final FileWriter$State$ State;
    private static final String stepType;
    private static final Function1 getBytes;
    public static final FileWriter$ MODULE$;

    private FileWriter$() {
    }

    static {
        MODULE$ = new FileWriter$();
        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
        stepType = ETLStepType$.MODULE$.apply("repository.FileWriter");
        getBytes = (Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)doc -> {
            BsonValue bsonValue;
            Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBinary) {
                BsonBinary bin = (BsonBinary)bsonValue;
                return Observable$.MODULE$.now((Object)bin);
            }
            return Observable$.MODULE$.empty();
        });
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileWriter$.class);
    }

    public Clock clock() {
        return clock;
    }

    public String stepType() {
        return stepType;
    }

    public Function1<Observable<Document>, Observable<BsonBinary>> getBytes() {
        return getBytes;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "filepath";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), this::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> this.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> this.run(cxt, (FileWriter.Info)info));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "filepath";
        boolean size = true;
        FileWriter.Info info = (FileWriter.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(info));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Function1<Observable<Document>, Observable<Document>> run(Builder.Context cxt, FileWriter.Info info) {
        return (Function1 & Serializable)from -> {
            File file = File.createTempFile("etl-", ".dat");
            Try try_ = Try$.MODULE$.apply(() -> this.run$$anonfun$1$$anonfun$1(file, from, cxt, info));
            if (try_ instanceof Success) {
                Observable doc = (Observable)((Success)try_).value();
                return doc;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                String msg = "Can't write to " + info.filepath() + ": " + ex;
                return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply(msg, ex))).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object[] objectArray = new Document[1];
                    Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
                    objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt64$.MODULE$.apply(0L)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
                    objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(0L)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    objectArray[0] = Builder$.MODULE$.withError(package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), msg);
                    return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)ret -> ret);
                });
            }
            throw new MatchError((Object)try_);
        };
    }

    public Task<BsonBinary> debugFlow(Builder.Context cxt, BsonBinary bin) {
        return cxt.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Appending " + bin.getData().length + " bytes")).as((Object)bin);
    }

    public FileWriter.State write(FileWriter.State s, BsonBinary bin) {
        s.os().write(bin.getData());
        long l = s.count() + 1L;
        long l2 = s.length() + (long)bin.getData().length;
        Builder.Context context = s.copy$default$1();
        FileWriter.Info info = s.copy$default$2();
        File file = s.copy$default$3();
        OutputStream outputStream = s.copy$default$4();
        long l3 = s.copy$default$5();
        return s.copy(context, info, file, outputStream, l3, l, l2);
    }

    public Task<Document> buildResult(FileWriter.State s) {
        Path path = Path$.MODULE$.apply(s.info().filepath());
        return s.cxt().logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Closing " + s.file().getAbsolutePath())).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.buildResult$$anonfun$1$$anonfun$1(s);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return RepositoryCategory$.MODULE$.getUser(s.cxt()).flatMap((Function1 & Serializable)user -> RepositoryCategory$.MODULE$.repository().createFolderT(user, path.parent()).flatMap((Function1 & Serializable)x$1 -> this.buildResult$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1((UserDB.User)user, path, s, BoxesRunTime.unboxToBoolean((Object)x$1))));
            });
        });
    }

    public Task<Document> getResult(FileWriter.State s, UserDB.User user, Path path) {
        return RepositoryCategory$.MODULE$.repository().getItemT(user, path).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Repository.RItem rItem = (Repository.RItem)((Some)option).value();
                if (rItem instanceof Repository.RFile) {
                    Repository.RFile rFile = (Repository.RFile)rItem;
                    Repository.RFile f = rFile;
                    if (f.lastModified() >= s.start()) {
                        long elapsedTime = this.clock().now() - s.start();
                        return Task$.MODULE$.apply(() -> this.getResult$$anonfun$1$$anonfun$1(s, elapsedTime));
                    }
                    Repository.RFile f2 = rFile;
                    String msg = "The file at " + path + " could not be overwritten";
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                    return s.cxt().logRecord(package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)LogMessage.Error$.MODULE$.apply(msg));
                }
                if (rItem instanceof Repository.RFolder) {
                    Repository.RFolder f = (Repository.RFolder)rItem;
                    String msg = path + " is a folder, not a file";
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                    return s.cxt().logRecord(package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)LogMessage.Error$.MODULE$.apply(msg));
                }
            }
            if (None$.MODULE$.equals(option)) {
                String msg = "File " + path + " could not be created";
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return s.cxt().logRecord(package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)LogMessage.Error$.MODULE$.apply(msg));
            }
            throw new MatchError((Object)option);
        });
    }

    public Observable<byte[]> loadBytesFrom(File file) {
        return Observable$.MODULE$.fromInputStream(Task$.MODULE$.apply(() -> this.loadBytesFrom$$anonfun$1(file)), Observable$.MODULE$.fromInputStream$default$2());
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 build$$anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private final Product build$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private final FileWriter.Info $anonfun$4() {
        return FileWriter$Info$.MODULE$.apply(FileWriter$Info$.MODULE$.$lessinit$greater$default$1());
    }

    private final Panel buildPanel$$anonfun$1(FileWriter.Info info$3) {
        return Panel$.MODULE$.apply((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{PanelItem$.MODULE$.text("filepath", "File Path", info$3.filepath(), PanelItem$.MODULE$.text$default$4())})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        FileWriter$Info$ fileWriter$Info$ = FileWriter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileWriter.Info)fileWriter$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileWriter$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "filepath";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            FileWriter.Info info2 = (FileWriter.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "filepath";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string2 = step$2.copy$default$1();
            String string3 = step$2.copy$default$2();
            String string4 = step$2.copy$default$3();
            String string5 = step$2.copy$default$4();
            String string6 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string2, string3, string4, string5, string6, json, bl, bl2);
        });
    }

    private final FileWriter.State run$$anonfun$1$$anonfun$1$$anonfun$3(Builder.Context cxt$8, FileWriter.Info info$6, File file$5, BufferedOutputStream os$3) {
        return FileWriter$State$.MODULE$.apply(cxt$8, info$6, file$5, os$3, FileWriter$State$.MODULE$.$lessinit$greater$default$5(), FileWriter$State$.MODULE$.$lessinit$greater$default$6(), FileWriter$State$.MODULE$.$lessinit$greater$default$7());
    }

    private final Observable run$$anonfun$1$$anonfun$1(File file$3, Observable from$1, Builder.Context cxt$4, FileWriter.Info info$4) {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file$3));
        return ((Observable)this.getBytes().apply((Object)from$1.doOnStart((Function1 & Serializable)_$2 -> cxt$4.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Opening " + file$3.getAbsolutePath()))))).mapEval((Function1 & Serializable)bin -> this.debugFlow(cxt$4, (BsonBinary)bin)).foldLeft(() -> this.run$$anonfun$1$$anonfun$1$$anonfun$3(cxt$4, info$4, file$3, os), (Function2 & Serializable)(s, bin) -> this.write((FileWriter.State)s, (BsonBinary)bin)).mapEval((Function1 & Serializable)s -> this.buildResult((FileWriter.State)s));
    }

    private final void buildResult$$anonfun$1$$anonfun$1(FileWriter.State s$2) {
        s$2.os().close();
    }

    private final /* synthetic */ Task buildResult$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$2, Path path$5, FileWriter.State s$6, boolean x$12) {
        boolean bl = x$12;
        return RepositoryCategory$.MODULE$.repository().writeFileT(user$2, path$5, this.loadBytesFrom(s$6.file())).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.getResult(s$6, user$2, path$5).map((Function1 & Serializable)reply -> reply);
        });
    }

    private final /* synthetic */ Task buildResult$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$1, Path path$4, FileWriter.State s$5, boolean x$12) {
        boolean bl = x$12;
        return RepositoryCategory$.MODULE$.repository().deleteFileT(user$1, path$4).flatMap((Function1 & Serializable)x$1 -> this.buildResult$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(user$1, path$4, s$5, BoxesRunTime.unboxToBoolean((Object)x$1)));
    }

    private final Document getResult$$anonfun$1$$anonfun$1(FileWriter.State s$9, long elapsedTime$1) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt64$.MODULE$.apply(s$9.count())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(s$9.length())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(elapsedTime$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final FileInputStream loadBytesFrom$$anonfun$1(File file$6) {
        return new FileInputStream(file$6);
    }
}

