/*
 * Decompiled with CFR 0.152.
 */
package ambience.gis.explorer.db;

import ambience.arch.MongoDBLinkResolver;
import ambience.arch.MongoDBLinkResolver$;
import ambience.framework.DocumentManager2$;
import ambience.framework.URFilter2$;
import ambience.gis.Model;
import ambience.gis.explorer.db.ExplorerDB;
import ambience.gis.explorer.db.ExplorerMongoDB$;
import ambience.gis.explorer.db.Util$;
import ambience.gis.explorer.provider.MapProvider;
import ambience.gis.explorer.provider.MapProvider$;
import ambience.gis.explorer.provider.MigrationResult;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.json.JsonLens$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monocle.POptional;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ExplorerMongoDB
implements ExplorerDB,
LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ExplorerMongoDB.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ExplorerMongoDB.class.getDeclaredField("layerCol$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExplorerMongoDB.class.getDeclaredField("explorerCol$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final Scheduler scheduler;
    private volatile Object explorerCol$lzy1;
    private volatile Object layerCol$lzy1;

    public static POptional<Json, Json, String, String> IdLens() {
        return ExplorerMongoDB$.MODULE$.IdLens();
    }

    public static POptional<Json, Json, String, String> ProviderLens() {
        return ExplorerMongoDB$.MODULE$.ProviderLens();
    }

    public static POptional<Json, Json, Vector<Json>, Vector<Json>> ResultArrLens() {
        return ExplorerMongoDB$.MODULE$.ResultArrLens();
    }

    public ExplorerMongoDB(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public RichMongoCollection explorerCol() {
        Object object = this.explorerCol$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.explorerCol$lzyINIT1();
    }

    private Object explorerCol$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.explorerCol$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB().database().getCollection("GISExplorer", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.explorerCol$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection layerCol() {
        Object object = this.layerCol$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.layerCol$lzyINIT1();
    }

    private Object layerCol$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.layerCol$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB().database().getCollection("GeoLayer", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.layerCol$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<String, Json>> load(UserDB.User user, MongoDBLinkResolver.LinkJson link) {
        this.log().info(() -> ExplorerMongoDB.load$$anonfun$1(link), Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.gis.explorer.db.ExplorerMongoDB.load"));
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> MongoDBLinkResolver$.MODULE$.resolveLinkJson(this.explorerCol(), link, (Option)Some$.MODULE$.apply((Object)Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, Filters$.MODULE$.exists("name")})))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                String jsonStr = doc.toJson();
                Option option2 = io.circe.parser.package$.MODULE$.parse(jsonStr).toOption();
                if (option2 instanceof Some) {
                    Json json = (Json)((Some)option2).value();
                    String id = Model.ProviderId$.MODULE$.apply((String)ExplorerMongoDB$.MODULE$.ProviderLens().getOption((Object)json).getOrElse(ExplorerMongoDB::$anonfun$1));
                    MapProvider provider = MapProvider$.MODULE$.get(id);
                    Json resolvedJson = provider.resolveJson(this.ensureVersion(json));
                    Either<String, MigrationResult> result = provider.migrate(resolvedJson);
                    return this.handleMigration(result);
                }
                if (None$.MODULE$.equals(option2)) {
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("Error parsing json: " + jsonStr)));
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("GISExplorer not found with link:" + link)));
            }
            throw new MatchError((Object)option);
        }));
    }

    public Task<Either<String, Json>> handleMigration(Either<String, MigrationResult> result) {
        Either<String, MigrationResult> either = result;
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg));
        }
        if (either instanceof Right) {
            MigrationResult result2 = (MigrationResult)((Right)either).value();
            if (result2.migrated()) {
                return this.saveMigration(result2.json()).map((Function1 & Serializable)_$1 -> Right$.MODULE$.apply((Object)result2.json()));
            }
            return Task$.MODULE$.apply(() -> ExplorerMongoDB.handleMigration$$anonfun$2(result2));
        }
        throw new MatchError(either);
    }

    public Json ensureVersion(Json json) {
        JsonProcessor.Default a = JsonProcessor.Default$.MODULE$.apply((Option)None$.MODULE$, "version", Json$.MODULE$.fromString("1.0"));
        return (Json)JsonProcessor$.MODULE$.run((JsonProcessor.Action)a).apply((Object)json);
    }

    @Override
    public Task<Either<String, BoxedUnit>> save(UserDB.User user, Json explorer) {
        String provider = Model.ProviderId$.MODULE$.apply((String)ExplorerMongoDB$.MODULE$.ProviderLens().getOption((Object)explorer).getOrElse(ExplorerMongoDB::$anonfun$2));
        return MapProvider$.MODULE$.get(provider).save(user, explorer);
    }

    @Override
    public Task<Either<String, BoxedUnit>> saveMigration(Json explorer) {
        String id = (String)ExplorerMongoDB$.MODULE$.IdLens().getOption((Object)explorer).getOrElse(ExplorerMongoDB::$anonfun$3);
        Bson filters = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.where(id), DocumentManager2$.MODULE$.exists("name")}));
        Document newDoc = Document$.MODULE$.apply(explorer.noSpaces());
        return this.explorerCol().replaceOneT(filters, newDoc).map((Function1 & Serializable)_$2 -> Right$.MODULE$.apply((Object)BoxedUnit.UNIT)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)("saveMigration failed: " + ex.getMessage()));
            }
        });
    }

    @Override
    public Task<Either<String, List<Json>>> layerList() {
        FindOptions opts = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        return this.layerCol().findO(opts).toListL().map((Function1 & Serializable)reply -> Right$.MODULE$.apply((Object)reply.flatMap((Function1 & Serializable)d -> {
            Either either = io.circe.parser.package$.MODULE$.decode(d.toJson(), Decoder$.MODULE$.decodeJson());
            if (either instanceof Right) {
                Json result = (Json)((Right)either).value();
                String id = (String)JsonLens$.MODULE$.root().selectDynamic("_id").selectDynamic("$oid").string().getOption((Object)result).getOrElse(ExplorerMongoDB::$anonfun$4);
                return Some$.MODULE$.apply((Object)result.mapObject((Function1 & Serializable)_$3 -> _$3.add("id", Json$.MODULE$.fromString(id))));
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                this.log().error(() -> ExplorerMongoDB.layerList$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(99), FullName$.MODULE$.apply("ambience.gis.explorer.db.ExplorerMongoDB.layerList"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        })));
    }

    @Override
    public Task<Either<String, Json>> loadLayer(String name) {
        this.log().info(() -> ExplorerMongoDB.loadLayer$$anonfun$1(name), Line$.MODULE$.apply(107), FullName$.MODULE$.apply("ambience.gis.explorer.db.ExplorerMongoDB.loadLayer"));
        return this.layerCol().findO(this.whereName(name)).toListL().map((Function1 & Serializable)reply -> {
            Option option = reply.headOption();
            if (option instanceof Some) {
                Document msg = (Document)((Some)option).value();
                String jsonStr = msg.toJson();
                Either either = io.circe.parser.package$.MODULE$.parse(jsonStr);
                if (either instanceof Right) {
                    Json result = (Json)((Right)either).value();
                    return Right$.MODULE$.apply((Object)result);
                }
                if (either instanceof Left) {
                    ParsingFailure err = (ParsingFailure)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)("Invalid Layer: " + err.getMessage()));
                }
                throw new MatchError((Object)either);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)("Layer not found with name:" + name));
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Task<Either<String, Json>> loadGeoJsonFeatureProperties(String name) {
        this.log().info(() -> ExplorerMongoDB.loadGeoJsonFeatureProperties$$anonfun$1(name), Line$.MODULE$.apply(122), FullName$.MODULE$.apply("ambience.gis.explorer.db.ExplorerMongoDB.loadGeoJsonFeatureProperties"));
        Seq bsonSeq = (Seq)Util$.MODULE$.buildGeoJsonFeaturePropertiesAgg(name).map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces()));
        return this.layerCol().aggregateO(bsonSeq).toListL().map((Function1 & Serializable)reply -> {
            Option option = reply.headOption();
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Either either = io.circe.parser.package$.MODULE$.parse(doc.toJson());
                if (either instanceof Right) {
                    Json result = (Json)((Right)either).value();
                    return Right$.MODULE$.apply((Object)Json$.MODULE$.fromValues((Iterable)ExplorerMongoDB$.MODULE$.ResultArrLens().getOption((Object)result).getOrElse(ExplorerMongoDB::loadGeoJsonFeatureProperties$$anonfun$2$$anonfun$1)));
                }
                if (either instanceof Left) {
                    ParsingFailure err = (ParsingFailure)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)("Invalid Layer: " + err.getMessage()));
                }
                throw new MatchError((Object)either);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)("Layer not found with name:" + name));
            }
            throw new MatchError((Object)option);
        });
    }

    public Bson where(String id) {
        return Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
    }

    private Bson whereName(String name) {
        return Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name));
    }

    private static final Object load$$anonfun$1(MongoDBLinkResolver.LinkJson link$1) {
        return "Loading GISExplorer link:" + link$1;
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final Right handleMigration$$anonfun$2(MigrationResult result$2) {
        return Right$.MODULE$.apply((Object)result$2.json());
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final Object layerList$$anonfun$1$$anonfun$1$$anonfun$2(Error err$1) {
        return err$1.getMessage();
    }

    private static final Object loadLayer$$anonfun$1(String name$1) {
        return "Loading Layer name:" + name$1;
    }

    private static final Object loadGeoJsonFeatureProperties$$anonfun$1(String name$3) {
        return "Loading feature properties for:" + name$3;
    }

    private static final Vector loadGeoJsonFeatureProperties$$anonfun$2$$anonfun$1() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }
}

