/*
 * Decompiled with CFR 0.152.
 */
package ambience.gis.explorers;

import ambience.api.Datasets;
import ambience.framework.UUIDDocumentManager2;
import ambience.framework.UUIDDocumentRoute2;
import ambience.gis.DatasetHelper$;
import ambience.gis.Model;
import ambience.gis.explorer.db.ExplorerMongoDB$;
import ambience.gis.explorer.provider.MapProvider;
import ambience.gis.explorer.provider.MapProvider$;
import ambience.gis.explorers.ExplorerManager;
import ambience.gis.explorers.ExplorerManager$;
import ambience.gis.explorers.ExplorersModule$;
import ambience.gravity.GravityHelper$;
import ambience.module.CustomOAuth2Client;
import ambience.module.Module;
import ambience.module.PrivilegeSupplier;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.UploadHelper2$;
import com.elixirtech.webserver.Avatar;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DefaultCodeLoader;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monocle.POptional;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ExplorersModule
implements Module,
PrivilegeSupplier,
LoggingHelper2 {
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("docRouteForExplorers$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("explorerManager$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("avatar$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExplorersModule.class.getDeclaredField("datasets$lzy1"));
    private volatile Object log$lzy1;
    public final ProjectConfig ambience$gis$explorers$ExplorersModule$$projectConfig;
    private final CustomOAuth2Client oAuth2Client;
    private final MongoDB mongoDB;
    private final String id;
    private final String name;
    private final String url;
    private final List ProvidersList;
    private volatile Object datasets$lzy1;
    private volatile Object avatar$lzy1;
    private volatile Object explorerManager$lzy1;
    private volatile Object docRouteForExplorers$lzy1;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;

    public static POptional<Json, Json, String, String> Provider() {
        return ExplorersModule$.MODULE$.Provider();
    }

    public ExplorersModule(ProjectConfig projectConfig, CustomOAuth2Client oAuth2Client, MongoDB mongoDB) {
        this.ambience$gis$explorers$ExplorersModule$$projectConfig = projectConfig;
        this.oAuth2Client = oAuth2Client;
        this.mongoDB = mongoDB;
        this.id = "gis-explorers";
        this.name = "GIS Explorers";
        this.url = this.id() + "/index.html";
        this.ProvidersList = (List)Try$.MODULE$.apply(() -> ExplorersModule.$init$$$anonfun$1(projectConfig)).getOrElse(ExplorersModule::$init$$$anonfun$2);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public List<String> ProvidersList() {
        return this.ProvidersList;
    }

    public Datasets datasets() {
        Object object = this.datasets$lzy1;
        if (object instanceof Datasets) {
            return (Datasets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Datasets)this.datasets$lzyINIT1();
    }

    private Object datasets$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.datasets$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Datasets datasets = null;
                    try {
                        datasets = (Datasets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Datasets.class));
                        object2 = datasets == null ? LazyVals.NullValue$.MODULE$ : datasets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.datasets$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return datasets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Avatar avatar() {
        Object object = this.avatar$lzy1;
        if (object instanceof Avatar) {
            return (Avatar)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Avatar)this.avatar$lzyINIT1();
    }

    private Object avatar$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.avatar$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Avatar avatar = null;
                    try {
                        avatar = new Avatar((Avatar.Options)this.ambience$gis$explorers$ExplorersModule$$projectConfig);
                        object2 = avatar == null ? LazyVals.NullValue$.MODULE$ : avatar;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.avatar$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return avatar;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ExplorerManager explorerManager() {
        Object object = this.explorerManager$lzy1;
        if (object instanceof ExplorerManager) {
            return (ExplorerManager)((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ExplorerManager)((Object)this.explorerManager$lzyINIT1());
    }

    private Object explorerManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.explorerManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ExplorerManager explorerManager = null;
                    try {
                        explorerManager = new ExplorerManager(this.mongoDB(), this.ProvidersList());
                        object2 = explorerManager == null ? LazyVals.NullValue$.MODULE$ : explorerManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.explorerManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return explorerManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UUIDDocumentRoute2 docRouteForExplorers() {
        Object object = this.docRouteForExplorers$lzy1;
        if (object instanceof UUIDDocumentRoute2) {
            return (UUIDDocumentRoute2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UUIDDocumentRoute2)this.docRouteForExplorers$lzyINIT1();
    }

    private Object docRouteForExplorers$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.docRouteForExplorers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UUIDDocumentRoute2 uUIDDocumentRoute2 = null;
                    try {
                        uUIDDocumentRoute2 = new UUIDDocumentRoute2((UUIDDocumentManager2)this.explorerManager(), "mod-gis-explorers-edit");
                        object2 = uUIDDocumentRoute2 == null ? LazyVals.NullValue$.MODULE$ : uUIDDocumentRoute2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.docRouteForExplorers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uUIDDocumentRoute2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ ExplorersModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-gis-explorer-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.ambience$gis$explorers$ExplorersModule$$projectConfig.WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DefaultCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DefaultCodeLoader) {
            return (DefaultCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultCodeLoader defaultCodeLoader = null;
                    try {
                        defaultCodeLoader = new DefaultCodeLoader(this.codeLoaderOptions());
                        object2 = defaultCodeLoader == null ? LazyVals.NullValue$.MODULE$ : defaultCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<PrivilegeSupplier.Privilege> requiredPrivileges() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrivilegeSupplier.Privilege[]{PrivilegeSupplier.Privilege$.MODULE$.apply("mod-gis-explorers-edit", "Allowed to edit explorers metadata (eg. role access)")}));
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "index.html", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.buildIndexHtml((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/*", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getDataSeg((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.postAdd((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "upload", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.upload((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "datasets", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> DatasetHelper$.MODULE$.getDatasets((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "dataset/*", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> DatasetHelper$.MODULE$.getDatasetSeg((UserDB.User)user))), this.codeLoader().route(), GravityRoute$.MODULE$.all(this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.docRouteForExplorers().route(user).handler()))}));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> withModUser(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn) {
        return this.oAuth2Client.approveWithUser((Function1 & Serializable)user -> {
            if (this.isValidGroup((UserDB.User)user)) {
                return (Function1)fn.apply(user);
            }
            return Gravity$.MODULE$.ForbiddenHandler();
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildIndexHtml(UserDB.User user) {
        return (Function1 & Serializable)request -> this.extrasT(user).flatMap((Function1 & Serializable)extras -> ((Task)RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)this.codeLoader(), "gis/explorers", (PartialFunction)extras, user).apply(request)).map((Function1 & Serializable)ret -> ret));
    }

    public Task<Map<String, String>> extrasT(UserDB.User user) {
        return this.datasets(user).map((Function1 & Serializable)datasetsList -> {
            String ps = this.ProvidersList().map((Function1 & Serializable)i -> "\"" + i + "\"").mkString("[", ",", "]");
            String ds = datasetsList.map((Function1 & Serializable)i -> "\"" + i + "\"").mkString("[", ",", "]");
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"datasetList");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ds);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"providersList");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ps);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    public Task<Json> prepareNewExplorer(UserDB.User user, String name, String copyFrom, String providerId) {
        MapProvider provider = MapProvider$.MODULE$.get(providerId);
        if (copyFrom.isEmpty()) {
            return Task$.MODULE$.now((Object)provider.blankExplorer(user, name));
        }
        return this.explorerManager().get(user, copyFrom).map((Function1 & Serializable)reply -> (Json)reply.map(this.copy(user, name)).getOrElse(() -> this.prepareNewExplorer$$anonfun$1$$anonfun$1(copyFrom, provider, user, name)));
    }

    public Function1<Json, Json> copy(UserDB.User user, String name) {
        List actions = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Action[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("_id")), JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "name", Json$.MODULE$.fromString(name)), JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "owner", Json$.MODULE$.fromString(user.id()))}));
        return (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)actions, json);
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDataSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)uuid -> (Function1 & Serializable)_$1 -> this.explorerManager().get(user, uuid.value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                MapProvider provider = MapProvider$.MODULE$.get(Model.ProviderId$.MODULE$.apply((String)ExplorersModule$.MODULE$.Provider().getOption((Object)json).getOrElse(ExplorersModule::$anonfun$3)));
                Json merged = this.mergeJson(user, json, provider);
                return GravityResponse$.MODULE$.json(merged);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> postAdd(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$2 -> {
            Tuple3 tuple3;
            Option params = json.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)_$3 -> new Model.ExplorerName(Model.ExplorerName$.MODULE$.apply(_$3))).flatMap((Function1 & Serializable)name -> ExplorersModule.$anonfun$5(json, name == null ? null : ((Model.ExplorerName)name).value()));
            Option option = params;
            if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
                String name2 = tuple3._1() == null ? null : ((Model.ExplorerName)tuple3._1()).value();
                String copyFrom = tuple3._2() == null ? null : ((Model.ExplorerId)tuple3._2()).value();
                String providerId = tuple3._3() == null ? null : ((Model.ProviderId)tuple3._3()).value();
                return this.prepareNewExplorer(user, name2, copyFrom, providerId).flatMap((Function1 & Serializable)explorerJson -> this.docRouteForExplorers().save(user, explorerJson));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> ExplorersModule.postAdd$$anonfun$1$$anonfun$1$$anonfun$2(json), Line$.MODULE$.apply(146), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.postAdd"));
                return Gravity$.MODULE$.BadRequestResponseT();
            }
            throw new MatchError((Object)option);
        });
    }

    public Json mergeJson(UserDB.User user, Json json, MapProvider provider) {
        Json that = provider.blankExplorer(user, Model.ExplorerName$.MODULE$.apply(Model.ExplorerName$.MODULE$.$lessinit$greater$default$1()));
        return that.deepMerge(json);
    }

    public Function1<GravityRequest, Task<GravityResponse>> upload(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.formParameter("name").map((Function1 & Serializable)name -> {
            Gravity.FormItem formItem;
            String overwrite = (String)request.formParameter("overwrite").getOrElse(ExplorersModule::$anonfun$6);
            this.log().info(() -> ExplorersModule.upload$$anonfun$1$$anonfun$1$$anonfun$1(user, name, overwrite), Line$.MODULE$.apply(162), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.upload"));
            Option option = request.formItems().get("file");
            if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                return DataBytes$.MODULE$.toFullT((DataBytes)file.data()).flatMap((Function1 & Serializable)full -> this.handleUpload(user, (SyncDataBytes)full, (String)name, overwrite));
            }
            return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
        }).getOrElse(ExplorersModule::upload$$anonfun$1$$anonfun$2);
    }

    public Task<GravityResponse> handleUpload(UserDB.User user, SyncDataBytes bytes, String name, String overwrite) {
        Either either = package$.MODULE$.parse(new String(bytes.bytes(), Gravity$.MODULE$.UTF_8()));
        if (either instanceof Right) {
            Json explorerJson = (Json)((Right)either).value();
            String provider = Model.ProviderId$.MODULE$.apply((String)ExplorerMongoDB$.MODULE$.ProviderLens().getOption((Object)explorerJson).getOrElse(ExplorersModule::$anonfun$7));
            Either<DecodingFailure, Json> either2 = MapProvider$.MODULE$.get(provider).testUploadStructure(explorerJson);
            if (either2 instanceof Right) {
                Json testedJson = (Json)((Right)either2).value();
                String string = overwrite;
                String string2 = "true";
                Task fpreparation = !(string != null ? !string.equals(string2) : string2 != null) ? UploadHelper2$.MODULE$.handleDeleteBeforeUpload((UUIDDocumentManager2)this.explorerManager(), user, name) : Task$.MODULE$.now((Object)LogMessage.None$.MODULE$);
                return fpreparation.flatMap((Function1 & Serializable)x$12 -> {
                    LogMessage logMessage = x$12;
                    if (LogMessage.None$.MODULE$.equals(logMessage)) {
                        Json json = ExplorerManager$.MODULE$.updateLastModified(testedJson.mapObject((Function1 & Serializable)obj -> obj.add("name", Json$.MODULE$.fromString(name)).remove("ownerName")));
                        Document newDoc = Document$.MODULE$.apply(json.noSpaces());
                        return this.explorerManager().add(user, (BsonValue)BsonString$.MODULE$.apply(name), newDoc).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Right) {
                                return Gravity$.MODULE$.OkResponse();
                            }
                            if (either instanceof Left) {
                                LogMessage msg = (LogMessage)((Left)either).value();
                                this.log().apply(msg, Line$.MODULE$.apply(190), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.handleUpload"));
                                return Gravity$.MODULE$.BadRequestResponse("Add failed");
                            }
                            throw new MatchError((Object)either);
                        });
                    }
                    LogMessage msg = logMessage;
                    this.log().apply(msg, Line$.MODULE$.apply(194), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.handleUpload"));
                    return Gravity$.MODULE$.BadRequestResponseT("Overwrite removal failed");
                });
            }
            if (either2 instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either2).value();
                this.log().error(() -> ExplorersModule.handleUpload$$anonfun$2(err), Line$.MODULE$.apply(199), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.handleUpload"));
                return Gravity$.MODULE$.BadRequestResponseT("Decode gis-explorer failed");
            }
            throw new MatchError(either2);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            this.log().error(() -> ExplorersModule.handleUpload$$anonfun$3(err), Line$.MODULE$.apply(203), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.handleUpload"));
            return Gravity$.MODULE$.BadRequestResponseT("Decode json failed");
        }
        throw new MatchError((Object)either);
    }

    public Task<List<String>> datasets(UserDB.User user) {
        return this.datasets().getDatasets(user).map((Function1 & Serializable)_$6 -> _$6.map((Function1 & Serializable)_$7 -> _$7 == null ? null : ((Datasets.Name)_$7).value()));
    }

    private boolean isValidGroup(UserDB.User user) {
        return user.privileges().contains((Object)"mod-gis-explorers") || user.privileges().contains((Object)"mod-gis-explorers-edit");
    }

    private static final List $init$$$anonfun$1(ProjectConfig projectConfig$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(projectConfig$1.pc().getStringList("modules.gis-explorers.providers")).asScala().toList();
    }

    private static final List $init$$$anonfun$2() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Leaflet"}));
    }

    private static final Object prepareNewExplorer$$anonfun$1$$anonfun$1$$anonfun$1(String copyFrom$3) {
        return "Can't locate explorer " + new Model.ExplorerId(copyFrom$3) + ", using blank";
    }

    private final Json prepareNewExplorer$$anonfun$1$$anonfun$1(String copyFrom$2, MapProvider provider$2, UserDB.User user$4, String name$2) {
        this.log().warn(() -> ExplorersModule.prepareNewExplorer$$anonfun$1$$anonfun$1$$anonfun$1(copyFrom$2), Line$.MODULE$.apply(105), FullName$.MODULE$.apply("ambience.gis.explorers.ExplorersModule.prepareNewExplorer"));
        return provider$2.blankExplorer(user$4, name$2);
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final /* synthetic */ Option $anonfun$5$$anonfun$2(Json json$3, String name$3, String copyFrom) {
        return json$3.hcursor().downField("providerId").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)_$5 -> new Model.ProviderId(Model.ProviderId$.MODULE$.apply(_$5))).map((Function1 & Serializable)providerId -> Tuple3$.MODULE$.apply((Object)new Model.ExplorerName(name$3), (Object)new Model.ExplorerId(copyFrom), (Object)new Model.ProviderId(providerId == null ? null : ((Model.ProviderId)providerId).value())));
    }

    private static final /* synthetic */ Option $anonfun$5(Json json$2, String name) {
        return json$2.hcursor().downField("copyFrom").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)_$4 -> new Model.ExplorerId(Model.ExplorerId$.MODULE$.apply(_$4))).flatMap((Function1 & Serializable)copyFrom -> ExplorersModule.$anonfun$5$$anonfun$2(json$2, name, copyFrom == null ? null : ((Model.ExplorerId)copyFrom).value()));
    }

    private static final Object postAdd$$anonfun$1$$anonfun$1$$anonfun$2(Json json$4) {
        return "Unable to add - bad json: " + json$4.noSpaces();
    }

    private static final String $anonfun$6() {
        return "false";
    }

    private static final Object upload$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$13, String name$5, String overwrite$1) {
        return "upload by " + user$13.name() + " parameters: name=" + name$5 + ", overwrite=" + overwrite$1;
    }

    private static final Task upload$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing form item 'name'");
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final Object handleUpload$$anonfun$2(DecodingFailure err$1) {
        return "Cannot decode uploaded file as a gis explorer: " + err$1;
    }

    private static final Object handleUpload$$anonfun$3(ParsingFailure err$2) {
        return "Cannot decode uploaded file as json: " + err$2;
    }
}

