/*
 * Decompiled with CFR 0.152.
 */
package ambience.dataExplorer.validate;

import ambience.dataExplorer.DataColumn;
import ambience.dataExplorer.DataColumnValidations$;
import ambience.dataExplorer.validate.Measures;
import ambience.dataExplorer.validate.Measures$Count$;
import ambience.dataExplorer.validate.Measures$DT$;
import ambience.dataExplorer.validate.Measures$Max$;
import ambience.dataExplorer.validate.Measures$Min$;
import ambience.dataExplorer.validate.Measures$Missing$;
import ambience.dataExplorer.validate.Measures$Unique$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public final class Measures$
implements Mirror.Product,
Serializable {
    private static final Regex dateR;
    private static final Regex timeR;
    public static final Measures$DT$ DT;
    public static final Measures$Count$ Count;
    public static final Measures$Missing$ Missing;
    public static final Measures$Unique$ Unique;
    public static final Measures$Max$ Max;
    public static final Measures$Min$ Min;
    public static final Measures$ MODULE$;

    private Measures$() {
    }

    static {
        MODULE$ = new Measures$();
        dateR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{4}-\\d{2}-\\d{2})$"));
        timeR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{2}:\\d{2}:\\d{2})$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Measures$.class);
    }

    public Measures apply(Map<String, String> validations) {
        return new Measures(validations);
    }

    public Measures unapply(Measures x$1) {
        return x$1;
    }

    public Map<String, String> $lessinit$greater$default$1() {
        return DataColumnValidations$.MODULE$.empty();
    }

    public Function1<Map<String, String>, Map<String, String>> fn(Measures.Measure measure) {
        return (Function1 & Serializable)vs -> {
            String string;
            Try<String> try_ = measure.calculate();
            if (try_ instanceof Success) {
                String text;
                string = text = (String)((Success)try_).value();
            } else if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (throwable instanceof BsonInvalidOperationException) {
                    BsonInvalidOperationException ex = (BsonInvalidOperationException)throwable;
                    string = ex.getMessage().replace("Value expected to be of type", "Expected:").replace("is of unexpected type", "Actual:");
                } else {
                    Throwable exception = throwable;
                    string = exception.toString();
                }
            } else {
                throw new MatchError(try_);
            }
            String result = string;
            return (Map)vs.updated((Object)measure.name(), (Object)result);
        };
    }

    public String stringifyTimestamp(BsonTimestamp timestamp) {
        long ms = timestamp.getValue();
        Instant instant = Instant.ofEpochMilli(ms);
        LocalDateTime datetime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return datetime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public final Measures.DateTimeList DateTimeList(List<BsonValue> list) {
        return new Measures.DateTimeList(list);
    }

    public boolean ambience$dataExplorer$validate$Measures$$$isDate(String str) {
        return dateR.matches((CharSequence)str);
    }

    public boolean ambience$dataExplorer$validate$Measures$$$isDate(BsonString bs) {
        return this.ambience$dataExplorer$validate$Measures$$$isDate(bs.getValue());
    }

    public boolean ambience$dataExplorer$validate$Measures$$$isTime(String str) {
        return timeR.matches((CharSequence)str);
    }

    public boolean ambience$dataExplorer$validate$Measures$$$isTime(BsonString bs) {
        return this.ambience$dataExplorer$validate$Measures$$$isTime(bs.getValue());
    }

    public Function1<Map<String, String>, Map<String, String>> dt(DataColumn.ValidColumn valid) {
        return this.fn(Measures$DT$.MODULE$.apply(valid));
    }

    public Function1<Map<String, String>, Map<String, String>> count(DataColumn.ValidColumn valid) {
        return this.fn(Measures$Count$.MODULE$.apply(valid));
    }

    public Function1<Map<String, String>, Map<String, String>> missing(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Missing$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> unique(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Unique$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> maximumValue(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Max$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> minimumValue(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Min$.MODULE$.apply(vc));
    }

    public Measures fromProduct(Product x$0) {
        return new Measures((Map<String, String>)((Map)x$0.productElement(0)));
    }
}

