/*
 * Decompiled with CFR 0.152.
 */
package ambience.developer;

import ambience.developer.CreateIndexRequest;
import ambience.developer.DBUtils$;
import ambience.developer.IndexManagement;
import ambience.developer.IndexManagement$IndexCopy$;
import ambience.developer.IndexManagement$IndexDrop$;
import ambience.developer.IndexManagement$IndexRow$;
import ambience.developer.IndexStructure;
import ambience.developer.IndexStructure$;
import ambience.developer.Utils$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.mongodb.client.model.IndexOptions;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class IndexManagement$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(IndexManagement$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final IndexManagement$IndexRow$ IndexRow;
    public static final IndexManagement$IndexDrop$ IndexDrop;
    public static final IndexManagement$IndexCopy$ IndexCopy;
    private static final Scheduler scheduler;
    public static final IndexManagement$ MODULE$;

    private IndexManagement$() {
    }

    static {
        MODULE$ = new IndexManagement$();
        scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IndexManagement$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public Task<GravityResponse> copyIndex(IndexManagement.IndexCopy indexCopy) {
        return this.testIndexExist(indexCopy.newDBName(), indexCopy.newCltnName(), indexCopy.newIdxName()).flatMap((Function1 & Serializable)exist -> this.copyIndex$$anonfun$1(indexCopy, BoxesRunTime.unboxToBoolean((Object)exist)));
    }

    public Task<GravityResponse> editIndex(CreateIndexRequest newCI, CreateIndexRequest oldCI) {
        Task result = Task$.MODULE$.apply(() -> this.$anonfun$1(newCI)).flatMap((Function1 & Serializable)cltn -> this.dropIndex(IndexManagement$IndexDrop$.MODULE$.apply(oldCI.dbName(), oldCI.cltnName(), oldCI.name())).flatMap((Function1 & Serializable)x$1 -> {
            GravityResponse gravityResponse = x$1;
            return this.createIndex((MongoCollection<Document>)cltn, IndexStructure$.MODULE$.apply(newCI)).flatMap((Function1 & Serializable)ok -> this.$anonfun$2$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)ok)));
        }));
        return result.onErrorHandle((Function1 & Serializable)ex -> {
            this.restoreIndex(oldCI).runToFuture(this.scheduler());
            this.log().error(() -> this.editIndex$$anonfun$1$$anonfun$1(ex), Line$.MODULE$.apply(50), FullName$.MODULE$.apply("ambience.developer.IndexManagement.editIndex"));
            return Gravity$.MODULE$.BadRequestResponse(ex.getMessage().replaceAll("(.*)\"errmsg\": \"", "").replaceAll("\", \"(.*)", ""));
        });
    }

    public Task<BoxedUnit> restoreIndex(CreateIndexRequest oldCI) {
        return Task$.MODULE$.apply(() -> this.restoreIndex$$anonfun$1(oldCI)).flatMap((Function1 & Serializable)cltn -> this.createIndex((MongoCollection<Document>)cltn, IndexStructure$.MODULE$.apply(oldCI)).map((Function1 & Serializable)v1 -> {
            this.restoreIndex$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        }));
    }

    public Task<GravityResponse> createIndex(CreateIndexRequest ci) {
        Task result = Task$.MODULE$.apply(() -> this.$anonfun$3(ci)).flatMap((Function1 & Serializable)cltn -> this.createIndex((MongoCollection<Document>)cltn, IndexStructure$.MODULE$.apply(ci)).flatMap((Function1 & Serializable)ok -> this.$anonfun$4$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)ok))));
        return result.onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> this.createIndex$$anonfun$1$$anonfun$1(ex), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.developer.IndexManagement.createIndex"));
            return Gravity$.MODULE$.BadRequestResponse(ex.getMessage().replaceAll("(.*)\"errmsg\": \"", "").replaceAll("\", \"(.*)", ""));
        });
    }

    public Task<Object> createIndex(MongoCollection<Document> cltn, IndexStructure index) {
        IndexOptions options = this.buildIndexOptions(index);
        BsonDocument key = this.buildIndexKey(index);
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.createIndex$$anonfun$2(cltn, index);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.createIndex((Bson)key, options)).completedL().map((Function1 & Serializable)_$1 -> true).map((Function1 & Serializable)reply -> this.createIndex$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)reply)));
        });
    }

    public Task<Object> createIndexCopy(MongoCollection<Document> cltn, Document doc) {
        Tuple2 tuple2;
        Option optkey = this.extractIndexOptions(doc).flatMap((Function1 & Serializable)options -> this.extractIndexKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(options, key)));
        Option option = optkey;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            IndexOptions options2 = (IndexOptions)tuple2._1();
            BsonDocument key = (BsonDocument)tuple2._2();
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.createIndexCopy$$anonfun$1(cltn, options2);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.createIndex((Bson)key, options2)).completedL().map((Function1 & Serializable)_$2 -> true).map((Function1 & Serializable)reply -> this.createIndexCopy$$anonfun$2$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)reply)));
            });
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError((Object)option);
    }

    public Option<IndexOptions> extractIndexOptions(Document doc) {
        return doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).map((Function1 & Serializable)name -> {
            IndexOptions indexOptions;
            boolean background = doc.get("background", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$4 -> _$4.getValue());
            boolean sparse = doc.get("sparse", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$5 -> _$5.getValue());
            boolean unique = doc.get("unique", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$6 -> _$6.getValue());
            IndexOptions options = new IndexOptions().name(name).background(background).sparse(sparse).unique(unique);
            Option option = doc.get("default_language", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue());
            if (option instanceof Some) {
                String lang = (String)((Some)option).value();
                indexOptions = options.defaultLanguage(lang);
            } else if (None$.MODULE$.equals(option)) {
                indexOptions = options;
            } else {
                throw new MatchError((Object)option);
            }
            IndexOptions extraOptions = indexOptions;
            Option option2 = doc.get("expireAfterSeconds", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt64.class)).map((Function1 & Serializable)_$8 -> _$8.getValue());
            if (option2 instanceof Some) {
                long value = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                return extraOptions.expireAfter(Predef$.MODULE$.long2Long(value), scala.concurrent.duration.package$.MODULE$.SECONDS());
            }
            if (None$.MODULE$.equals(option2)) {
                return extraOptions;
            }
            throw new MatchError((Object)option2);
        });
    }

    public Option<BsonDocument> extractIndexKey(Document doc) {
        return doc.get("key", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class));
    }

    public IndexOptions buildIndexOptions(IndexStructure struct) {
        IndexOptions options = new IndexOptions().name(struct.name()).background(struct.background()).sparse(struct.sparse()).unique(struct.unique());
        IndexOptions options2 = (IndexOptions)struct.expireAfter().map((Function1 & Serializable)exp -> this.$anonfun$10(options, BoxesRunTime.unboxToInt((Object)exp))).getOrElse(() -> this.$anonfun$11(options));
        Option<String> option = Utils$.MODULE$.opts(struct.default_language());
        if (option instanceof Some) {
            String lang = (String)((Some)option).value();
            return options2.defaultLanguage(lang);
        }
        if (None$.MODULE$.equals(option)) {
            return options2;
        }
        throw new MatchError(option);
    }

    public BsonDocument buildIndexKey(IndexStructure struct) {
        return org.mongodb.scala.bson.package$.MODULE$.Document().apply(struct.key().noSpaces()).toBsonDocument();
    }

    public Task<GravityResponse> doCopyIndex(IndexManagement.IndexCopy indexCopy) {
        MongoCollection<Document> cltn = DBUtils$.MODULE$.getCollection(indexCopy.oldDBName(), indexCopy.oldCltnName());
        Task foundIndex = this.getIndexes(cltn).find((Function1 & Serializable)index -> index.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).contains((Object)indexCopy.oldIdxName())).firstOptionL();
        return foundIndex.flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document index = (Document)((Some)option).value();
                MongoCollection<Document> cltn = DBUtils$.MODULE$.getCollection(indexCopy.newDBName(), indexCopy.newCltnName());
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(indexCopy.newIdxName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                Task result = this.createIndexCopy(cltn, (Document)index.$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)ok -> this.$anonfun$13(BoxesRunTime.unboxToBoolean((Object)ok)));
                return result.onErrorHandle((Function1 & Serializable)ex -> {
                    this.log().error(() -> this.doCopyIndex$$anonfun$1$$anonfun$1$$anonfun$1(ex), Line$.MODULE$.apply(153), FullName$.MODULE$.apply("ambience.developer.IndexManagement.doCopyIndex"));
                    return Gravity$.MODULE$.BadRequestResponse(ex.getMessage().replaceAll("(.*)\"errmsg\": \"", "").replaceAll("\", \"(.*)", ""));
                });
            }
            if (None$.MODULE$.equals(option)) {
                String msg = "Did not find index " + indexCopy.oldIdxName() + " in " + indexCopy.oldDBName() + "/" + indexCopy.oldCltnName();
                return Gravity$.MODULE$.BadRequestResponseT(msg);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<GravityResponse> dropIndex(IndexManagement.IndexDrop indexDrop) {
        return this.dropIndex(DBUtils$.MODULE$.getCollection(indexDrop.dbName(), indexDrop.cltnName()), indexDrop.indexName()).map((Function1 & Serializable)_$10 -> Gravity$.MODULE$.OkResponse());
    }

    public Task<BoxedUnit> dropIndex(MongoCollection<Document> cltn, String indexName) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.dropIndex$$anonfun$2(cltn, indexName);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.dropIndex(indexName)).completedL().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    public Observable<Document> getIndexes(MongoCollection<Document> cltn) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.listIndexes(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
    }

    public Observable<String> getIndexNames(MongoCollection<Document> cltn) {
        return this.getIndexes(cltn).flatMap((Function1 & Serializable)index -> {
            Option option = index.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
            if (option instanceof Some) {
                BsonString name = (BsonString)((Some)option).value();
                return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name.asString().getValue()}));
            }
            if (None$.MODULE$.equals(option)) {
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Json> loadIndexes(String dbName, String cltnName) {
        MongoCollection<Document> cltn = DBUtils$.MODULE$.getCollection(dbName, cltnName);
        return this.loadIndexes(cltn);
    }

    public Task<Json> loadIndexes(MongoCollection<Document> cltn) {
        return this.getIndexes(cltn).flatMap((Function1 & Serializable)index -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(package$.MODULE$.parse(index.toJson()).toOption()))).toListL().map((Function1 & Serializable)values -> Json$.MODULE$.fromValues(values));
    }

    public Task<Object> testIndexExist(String dbName, String cltnName, String indexName) {
        MongoCollection<Document> cltn = DBUtils$.MODULE$.getCollection(dbName, cltnName);
        return this.getIndexNames(cltn).toListL().map((Function1 & Serializable)_$11 -> _$11.contains((Object)indexName));
    }

    private final /* synthetic */ Task copyIndex$$anonfun$1(IndexManagement.IndexCopy indexCopy$1, boolean exist) {
        if (!exist) {
            return this.doCopyIndex(indexCopy$1);
        }
        return Gravity$.MODULE$.BadRequestResponseT("Target index name already exists");
    }

    private final MongoCollection $anonfun$1(CreateIndexRequest newCI$1) {
        return DBUtils$.MODULE$.getCollection(newCI$1.dbName(), newCI$1.cltnName());
    }

    private final /* synthetic */ Task $anonfun$2$$anonfun$1$$anonfun$1(boolean ok) {
        return (ok ? Gravity$.MODULE$.OkResponseT() : Gravity$.MODULE$.BadRequestResponseT("Create Index failed")).map((Function1 & Serializable)reply -> reply);
    }

    private final Object editIndex$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Create index error: " + ex$1.getMessage();
    }

    private final MongoCollection restoreIndex$$anonfun$1(CreateIndexRequest oldCI$3) {
        return DBUtils$.MODULE$.getCollection(oldCI$3.dbName(), oldCI$3.cltnName());
    }

    private final /* synthetic */ void restoreIndex$$anonfun$2$$anonfun$1(boolean x$1) {
        boolean bl = x$1;
    }

    private final MongoCollection $anonfun$3(CreateIndexRequest ci$1) {
        return DBUtils$.MODULE$.getCollection(ci$1.dbName(), ci$1.cltnName());
    }

    private final /* synthetic */ Task $anonfun$4$$anonfun$1(boolean ok) {
        return (ok ? Gravity$.MODULE$.OkResponseT() : Gravity$.MODULE$.BadRequestResponseT("Create Index failed")).map((Function1 & Serializable)reply -> reply);
    }

    private final Object createIndex$$anonfun$1$$anonfun$1(Throwable ex$2) {
        return "Create index error: " + ex$2.getMessage();
    }

    private final Object createIndex$$anonfun$2$$anonfun$1(MongoCollection cltn$3, IndexStructure index$2) {
        return "Creating index from IndexStructure " + cltn$3.namespace() + ":" + index$2.name();
    }

    private final void createIndex$$anonfun$2(MongoCollection cltn$2, IndexStructure index$1) {
        this.log().info(() -> this.createIndex$$anonfun$2$$anonfun$1(cltn$2, index$1), Line$.MODULE$.apply(81), FullName$.MODULE$.apply("ambience.developer.IndexManagement.createIndex"));
    }

    private final /* synthetic */ boolean createIndex$$anonfun$3$$anonfun$2(boolean reply) {
        return reply;
    }

    private final Object createIndexCopy$$anonfun$1$$anonfun$1(MongoCollection cltn$6, IndexOptions options$4) {
        return "Creating index from Document " + cltn$6.namespace() + ":" + options$4.getName();
    }

    private final void createIndexCopy$$anonfun$1(MongoCollection cltn$5, IndexOptions options$3) {
        this.log().info(() -> this.createIndexCopy$$anonfun$1$$anonfun$1(cltn$5, options$3), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("ambience.developer.IndexManagement.createIndexCopy"));
    }

    private final /* synthetic */ boolean createIndexCopy$$anonfun$2$$anonfun$2(boolean reply) {
        return reply;
    }

    private final /* synthetic */ IndexOptions $anonfun$10(IndexOptions options$6, int exp) {
        return options$6.expireAfter(Predef$.MODULE$.long2Long((long)exp), scala.concurrent.duration.package$.MODULE$.SECONDS());
    }

    private final IndexOptions $anonfun$11(IndexOptions options$7) {
        return options$7;
    }

    private final /* synthetic */ GravityResponse $anonfun$13(boolean ok) {
        if (ok) {
            return Gravity$.MODULE$.OkResponse();
        }
        return Gravity$.MODULE$.BadRequestResponse("doCopyIndex failed");
    }

    private final Object doCopyIndex$$anonfun$1$$anonfun$1$$anonfun$1(Throwable ex$3) {
        return "Create index error: " + ex$3.getMessage();
    }

    private final Object dropIndex$$anonfun$2$$anonfun$1(MongoCollection cltn$9, String indexName$2) {
        return "Dropping index " + cltn$9.namespace() + ":" + indexName$2;
    }

    private final void dropIndex$$anonfun$2(MongoCollection cltn$8, String indexName$1) {
        this.log().info(() -> this.dropIndex$$anonfun$2$$anonfun$1(cltn$8, indexName$1), Line$.MODULE$.apply(168), FullName$.MODULE$.apply("ambience.developer.IndexManagement.dropIndex"));
    }
}

