/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl;

import ambience.api.Jobs;
import ambience.etl.ChainSetIdentifier;
import ambience.etl.ChainSetLoader$;
import ambience.etl.ETLChainSet;
import ambience.etl.OpusConstants;
import ambience.etl.Running;
import ambience.etl.Running$;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import ambience.panel.Panel;
import com.elixirtech.arch.Credentials;
import com.elixirtech.arch.Credentials$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Token$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Helpers$
implements Serializable {
    private static final Gravity.Header JsonGzType;
    private static final Gravity.Header BsonType;
    private static final GravityResponse JSONSuccess;
    public static final Helpers$ MODULE$;

    private Helpers$() {
    }

    static {
        MODULE$ = new Helpers$();
        JsonGzType = Gravity.Header$.MODULE$.ContentType("application/json+gzip");
        BsonType = Gravity.Header$.MODULE$.ContentType("application/bson");
        OpusConstants.Success$ success$ = (OpusConstants.Success$)io.circe.syntax.package$.MODULE$.EncoderOps((Object)OpusConstants.Success$.MODULE$);
        JSONSuccess = MODULE$.JSONResponse(package.EncoderOps$.MODULE$.asJson$extension((Object)success$, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, (List)package$.MODULE$.Nil(), Configuration$.MODULE$.default())))).noSpaces());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Helpers$.class);
    }

    public Credentials credentials(UserDB.User ui) {
        return Credentials$.MODULE$.apply(Token$.MODULE$.apply(ui.id()), ui.name(), ui.privileges(), Credentials.IsAdmin$.MODULE$.apply(false), Credentials.IsAnon$.MODULE$.apply(false), Credentials.ChangePassword$.MODULE$.apply(false));
    }

    public Task<Option<UserDB.User>> user(String userName) {
        return UserDB$.MODULE$.filterEnabled(((UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class))).getUserByName(userName));
    }

    public Running running(Jobs.JobDefinition jd) {
        return Running$.MODULE$.apply(jd.id(), jd.chainSetId(), jd.mode(), jd.started(), jd.stopped(), jd.owner(), jd.description(), jd.recordCount(), jd.status());
    }

    public Gravity.Header JsonGzType() {
        return JsonGzType;
    }

    public Gravity.Header BsonType() {
        return BsonType;
    }

    public GravityResponse TextResponse(String txt) {
        return GravityResponse$.MODULE$.text(txt);
    }

    public GravityResponse TextResponse(int code, String txt) {
        return GravityResponse$.MODULE$.text(code, txt);
    }

    public GravityResponse JSONResponse(String json) {
        return GravityResponse$.MODULE$.json(json);
    }

    public GravityResponse JSONResponse(int code, String json) {
        return GravityResponse$.MODULE$.apply(code, Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Json()})), DataBytes$.MODULE$.apply(json));
    }

    public GravityResponse JSONGZResponse(byte[] jsonBytes) {
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{this.JsonGzType()}));
        DataBytes dataBytes = DataBytes$.MODULE$.apply(jsonBytes);
        int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    public GravityResponse BSONResponse(byte[] bson) {
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{this.BsonType()}));
        DataBytes dataBytes = DataBytes$.MODULE$.apply(bson);
        int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    public GravityResponse BytesResponse(int code, byte[] bytes, String mimeType, Option<String> optFilename) {
        Gravity.Headers headers;
        Gravity.Header contentType = Gravity.Header$.MODULE$.ContentType(mimeType);
        Option<String> option = optFilename;
        if (option instanceof Some) {
            String filename = (String)((Some)option).value();
            headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType, GravityResponse.ContentDisposition$.MODULE$.inline(filename)}));
        } else if (None$.MODULE$.equals(option)) {
            headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType}));
        } else {
            throw new MatchError(option);
        }
        Gravity.Headers headers2 = headers;
        return GravityResponse$.MODULE$.apply(code, headers2, DataBytes$.MODULE$.apply(bytes));
    }

    public GravityResponse ErrorResponse(int code, String reason) {
        return GravityResponse$.MODULE$.text(Gravity.Status$.MODULE$.apply(code), reason);
    }

    public GravityResponse JSONSuccess() {
        return JSONSuccess;
    }

    public Task<List<Panel.SelectChoice>> getChainChoices(UserDB.User user, ChainSetIdentifier csId) {
        return ChainSetLoader$.MODULE$.getChainSet(user, csId).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ETLChainSet chainSet = (ETLChainSet)((Some)option).value();
                return this.toChoices((Set<String>)chainSet.chains().keySet());
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Nil();
            }
            throw new MatchError((Object)option);
        });
    }

    public List<Panel.SelectChoice> toChoices(Set<String> set) {
        return ((List)set.toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
    }

    public Task<Option<ETLChainSet>> getChainSet(UserDB.User user, ChainSetIdentifier csId) {
        return ChainSetLoader$.MODULE$.getChainSet(user, csId);
    }

    public GravityResponse withAttachmentFilename(GravityResponse response, String filename) {
        return response.withHeader(GravityResponse.ContentDisposition$.MODULE$.attachment(filename));
    }

    private final List $init$$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

