/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.endpoint;

import ambience.api.ChainRunner;
import ambience.api.Jobs;
import ambience.etl.BsonToJsonString$;
import ambience.etl.ChainSetId;
import ambience.etl.ChainSetId$;
import ambience.etl.ChainSetLoader$;
import ambience.etl.ChainSetManager;
import ambience.etl.ChainSetManager$BytesMode$;
import ambience.etl.ChainSetManager$JsonRecordMode$;
import ambience.etl.ChainSetManager$JsonStreamedMode$;
import ambience.etl.ChainSetManager$RedirectMode$;
import ambience.etl.ChainSetName;
import ambience.etl.ETLChain;
import ambience.etl.ETLChainSet;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Helpers$;
import ambience.etl.endpoint.EndpointHandler;
import ambience.etl.endpoint.EndpointHandler$ValidChain$;
import ambience.etl.endpoint.EndpointRequest;
import ambience.etl.package$;
import ambience.etl.result.HttpEndpoint;
import ambience.etl.result.HttpEndpoint$;
import ambience.etl.runtime.queue.QueueHelper$;
import ambience.module.UserDB;
import ambience.queue.QueueManager;
import ambience.queue.SystemQueueManager;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.webserver.I18N$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonObject;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class EndpointHandler$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(EndpointHandler$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(EndpointHandler$.class.getDeclaredField("jobsAPI$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(EndpointHandler$.class.getDeclaredField("scheduler$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object scheduler$lzy1;
    private volatile Object jobsAPI$lzy1;
    public static final EndpointHandler$ValidChain$ ValidChain;
    public static final EndpointHandler$ MODULE$;

    private EndpointHandler$() {
    }

    static {
        MODULE$ = new EndpointHandler$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EndpointHandler$.class);
    }

    public Scheduler scheduler() {
        Object object = this.scheduler$lzy1;
        if (object instanceof Scheduler) {
            return (Scheduler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Scheduler)this.scheduler$lzyINIT1();
    }

    private Object scheduler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.scheduler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Scheduler scheduler = null;
                    try {
                        scheduler = Scheduler$.MODULE$.global();
                        object2 = scheduler == null ? LazyVals.NullValue$.MODULE$ : scheduler;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scheduler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return scheduler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Jobs jobsAPI() {
        Object object = this.jobsAPI$lzy1;
        if (object instanceof Jobs) {
            return (Jobs)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Jobs)this.jobsAPI$lzyINIT1();
    }

    private Object jobsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jobsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Jobs jobs = null;
                    try {
                        jobs = (Jobs)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Jobs.class));
                        object2 = jobs == null ? LazyVals.NullValue$.MODULE$ : jobs;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jobsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jobs;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<GravityResponse> apply(EndpointRequest er) {
        return this.getValidChain(er).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                EndpointHandler.ValidChain validChain = (EndpointHandler.ValidChain)((Right)either).value();
                EndpointRequest aug = this.augmentStructure(er, validChain);
                ChainSetManager.EndpointMode endpointMode = er.mode();
                ChainSetManager$JsonStreamedMode$ chainSetManager$JsonStreamedMode$ = ChainSetManager$JsonStreamedMode$.MODULE$;
                if (!(endpointMode != null ? !endpointMode.equals(chainSetManager$JsonStreamedMode$) : chainSetManager$JsonStreamedMode$ != null)) {
                    return this.handleEndpointStream(aug, validChain.chainSetId());
                }
                return this.handleEndpointResponse(aug, validChain.chainSetId());
            }
            if (either instanceof Left) {
                GravityResponse response = (GravityResponse)((Left)either).value();
                return Task$.MODULE$.now((Object)response);
            }
            throw new MatchError((Object)either);
        });
    }

    public EndpointRequest augmentStructure(EndpointRequest er, EndpointHandler.ValidChain chain) {
        None$ none$;
        None$ a;
        HttpEndpoint.Info info = HttpEndpoint$.MODULE$.getInfo(chain.httpEndpoint());
        if (info.retainHeaders()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"headers");
            v0 = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.buildHeaders(er.request())));
        } else {
            v0 = a = None$.MODULE$;
        }
        if (info.acceptLanguage()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"i18nLanguage");
            none$ = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.buildAcceptLanguage(er.request())));
        } else {
            none$ = None$.MODULE$;
        }
        None$ b = none$;
        List extras = (List)((StrictOptimizedIterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{a, b}))).flatten(Predef$.MODULE$.$conforms());
        if (extras.nonEmpty()) {
            return er.mapInit((Function1<JsonObject, JsonObject>)(Function1 & Serializable)obj -> obj.add("request", Json$.MODULE$.fromFields((Iterable)extras)));
        }
        return er;
    }

    public Json buildHeaders(GravityRequest request) {
        return Json$.MODULE$.fromValues((Iterable)request.headers().items().map((Function1 & Serializable)h -> {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(h.name()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(h.value()));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }));
    }

    public Json buildAcceptLanguage(GravityRequest request) {
        return Json$.MODULE$.fromString(I18N$.MODULE$.getAcceptLanguage(request));
    }

    public Task<Either<GravityResponse, EndpointHandler.ValidChain>> getValidChain(EndpointRequest er) {
        return this.getChainSet(er.user(), er.chainSetName()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                ETLChainSet chainSet = (ETLChainSet)((Right)either).value();
                Option option = chainSet.chains().get((Object)er.chainName());
                if (option instanceof Some) {
                    ETLChain chain = (ETLChain)((Some)option).value();
                    Option option2 = chain.steps().find((Function1 & Serializable)_$1 -> {
                        String string = _$1.stepType();
                        String string2 = ETLStepType$.MODULE$.apply("result.HttpEndpoint");
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    });
                    if (option2 instanceof Some) {
                        ETLStep httpEndpoint = (ETLStep)((Some)option2).value();
                        return scala.package$.MODULE$.Right().apply((Object)EndpointHandler$ValidChain$.MODULE$.apply(ChainSetId$.MODULE$.apply(chainSet._id()), chain, httpEndpoint));
                    }
                    if (None$.MODULE$.equals(option2)) {
                        String msg = "Chain " + er.chainName() + " is not an HttpEndpoint";
                        this.log().warn(() -> this.getValidChain$$anonfun$1$$anonfun$2(msg), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.getValidChain"));
                        int n = Gravity.Status$.MODULE$.NotFound();
                        DataBytes dataBytes = DataBytes$.MODULE$.apply(msg);
                        Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
                        return scala.package$.MODULE$.Left().apply((Object)GravityResponse$.MODULE$.apply(n, headers, dataBytes));
                    }
                    throw new MatchError((Object)option2);
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> this.getValidChain$$anonfun$1$$anonfun$3(er), Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.getValidChain"));
                    int n = Gravity.Status$.MODULE$.NotFound();
                    DataBytes dataBytes = DataBytes$.MODULE$.apply("Chain " + er.chainName() + " not found");
                    Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
                    return scala.package$.MODULE$.Left().apply((Object)GravityResponse$.MODULE$.apply(n, headers, dataBytes));
                }
                throw new MatchError((Object)option);
            }
            if (either instanceof Left) {
                GravityResponse response = (GravityResponse)((Left)either).value();
                return scala.package$.MODULE$.Left().apply((Object)response);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<GravityResponse> handleEndpointResponse(EndpointRequest er, ChainSetId chainSetId) {
        return this.runQueueRequest(er.user(), chainSetId, er.chainSetName(), er.chainName(), er.initJson()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Jobs.JobDefinition jd = (Jobs.JobDefinition)((Right)either).value();
                return this.jobsAPI().getResults(jd.id(), 0, (Option)None$.MODULE$).toListL().map((Function1 & Serializable)docs -> {
                    ChainSetManager.EndpointMode endpointMode = er.mode();
                    ChainSetManager$BytesMode$ chainSetManager$BytesMode$ = ChainSetManager$BytesMode$.MODULE$;
                    if (!(endpointMode != null ? !endpointMode.equals(chainSetManager$BytesMode$) : chainSetManager$BytesMode$ != null)) {
                        return this.bytesModeResponse((List<Document>)docs);
                    }
                    ChainSetManager.EndpointMode endpointMode2 = er.mode();
                    ChainSetManager$RedirectMode$ chainSetManager$RedirectMode$ = ChainSetManager$RedirectMode$.MODULE$;
                    if (!(endpointMode2 != null ? !endpointMode2.equals(chainSetManager$RedirectMode$) : chainSetManager$RedirectMode$ != null)) {
                        return this.redirectModeResponse((List<Document>)docs);
                    }
                    ChainSetManager.EndpointMode endpointMode3 = er.mode();
                    ChainSetManager$JsonRecordMode$ chainSetManager$JsonRecordMode$ = ChainSetManager$JsonRecordMode$.MODULE$;
                    if (!(endpointMode3 != null ? !endpointMode3.equals(chainSetManager$JsonRecordMode$) : chainSetManager$JsonRecordMode$ != null)) {
                        Document ret = (Document)docs.headOption().getOrElse(this::$anonfun$1);
                        String json = this.bsonToJsonIndented((Document)ret.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStatusCode"})));
                        return Helpers$.MODULE$.JSONResponse(this.getStatus(ret), json);
                    }
                    List list = docs;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        Document head = (Document)colon2.head();
                        Nil$ nil$ = scala.package$.MODULE$.Nil();
                        List list3 = list2;
                        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                            String json = this.bsonToJsonIndented((Document)head.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStatusCode"})));
                            return Helpers$.MODULE$.JSONResponse(this.getStatus(head), "[" + json + "]");
                        }
                    }
                    return Helpers$.MODULE$.JSONResponse(docs.map((Function1 & Serializable)doc -> this.bsonToJsonIndented((Document)doc)).mkString("[", ",", "]"));
                });
            }
            if (either instanceof Left) {
                GravityResponse response = (GravityResponse)((Left)either).value();
                return Task$.MODULE$.now((Object)response);
            }
            throw new MatchError((Object)either);
        });
    }

    public GravityResponse bytesModeResponse(List<Document> docs) {
        Option option;
        this.log().info(() -> this.bytesModeResponse$$anonfun$1(docs), Line$.MODULE$.apply(112), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.bytesModeResponse"));
        if (docs.size() > 1) {
            this.log().warn(this::bytesModeResponse$$anonfun$2, Line$.MODULE$.apply(113), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.bytesModeResponse"));
        }
        if ((option = docs.headOption()) instanceof Some) {
            Document doc = (Document)((Some)option).value();
            int status = this.getStatus(doc);
            String mimeType = (String)doc.get("mimeType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).getOrElse(this::$anonfun$3);
            Option optFilename = doc.get("filename", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue());
            Option option2 = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option2 instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option2).value();
                if (bsonValue instanceof BsonBinary) {
                    BsonBinary bytes = (BsonBinary)bsonValue;
                    return Helpers$.MODULE$.BytesResponse(status, bytes.getData(), mimeType, (Option<String>)optFilename);
                }
                if (bsonValue instanceof BsonString) {
                    BsonString bytes = (BsonString)bsonValue;
                    return Helpers$.MODULE$.BytesResponse(status, bytes.getValue().getBytes(Gravity$.MODULE$.UTF_8()), mimeType, (Option<String>)optFilename);
                }
            }
            this.log().info(this::bytesModeResponse$$anonfun$3, Line$.MODULE$.apply(125), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.bytesModeResponse"));
            return Helpers$.MODULE$.BytesResponse(status, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)), mimeType, (Option<String>)None$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            return Helpers$.MODULE$.BytesResponse(Gravity.Status$.MODULE$.OK(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)), "application/octet-stream", (Option<String>)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public String bsonToJsonIndented(Document doc) {
        boolean stripId = doc.get("elxStripId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$4 -> _$4.getValue());
        if (stripId) {
            return BsonToJsonString$.MODULE$.apply((Document)((BaseDocument)((BaseDocument)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"}))).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStripId"}))).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_elxIdx"})));
        }
        return BsonToJsonString$.MODULE$.apply((Document)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStripId"})));
    }

    public String bsonToJsonNoSpaces(Document doc) {
        boolean stripId = doc.get("elxStripId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$5 -> _$5.getValue());
        if (stripId) {
            return BsonToJsonString$.MODULE$.noSpaces((Document)((BaseDocument)((BaseDocument)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"}))).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStripId"}))).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_elxIdx"})));
        }
        return BsonToJsonString$.MODULE$.noSpaces((Document)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxStripId"})));
    }

    public GravityResponse redirectModeResponse(List<Document> docs) {
        Option option;
        this.log().info(() -> this.redirectModeResponse$$anonfun$1(docs), Line$.MODULE$.apply(146), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.redirectModeResponse"));
        if (docs.size() > 1) {
            this.log().warn(this::redirectModeResponse$$anonfun$2, Line$.MODULE$.apply(147), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.redirectModeResponse"));
        }
        if ((option = docs.headOption()) instanceof Some) {
            Document doc = (Document)((Some)option).value();
            String location = (String)doc.get("location", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).orElse(() -> this.$anonfun$7(doc)).map((Function1 & Serializable)_$6 -> _$6.getValue()).getOrElse(this::$anonfun$9);
            int statusCode = BoxesRunTime.unboxToInt((Object)doc.get("statusCode", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).orElse(() -> this.$anonfun$10(doc)).map((Function1 & Serializable)_$7 -> _$7.getValue()).getOrElse(this::$anonfun$12));
            this.log().info(() -> this.redirectModeResponse$$anonfun$3(location, statusCode), Line$.MODULE$.apply(164), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.redirectModeResponse"));
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(location)}));
            return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(statusCode), headers, GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warn(this::redirectModeResponse$$anonfun$4, Line$.MODULE$.apply(168), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.redirectModeResponse"));
            return Gravity$.MODULE$.BadRequestResponse();
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<GravityResponse, ETLChainSet>> getChainSet(UserDB.User user, ChainSetName chainSetName) {
        return ChainSetLoader$.MODULE$.getRawChainSet(user, chainSetName).map((Function1 & Serializable)optCS -> optCS.toRight(() -> this.getChainSet$$anonfun$1$$anonfun$1(chainSetName)));
    }

    public Task<GravityResponse> handleEndpointStream(EndpointRequest er, ChainSetId chainSetId) {
        return Task$.MODULE$.apply(() -> this.handleEndpointStream$$anonfun$1(er)).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> this.handleEndpointStream$$anonfun$2$$anonfun$1(er, ex), Line$.MODULE$.apply(188), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.handleEndpointStream"));
            return Gravity$.MODULE$.BadRequestResponse("Error building endpoint stream");
        });
    }

    public Task<Either<GravityResponse, Jobs.JobDefinition>> runQueueRequest(UserDB.User user, ChainSetId chainSetId, ChainSetName chainSetName, String chainName, Json json) {
        this.log().info(() -> this.runQueueRequest$$anonfun$1(user, chainSetName, chainName), Line$.MODULE$.apply(199), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.runQueueRequest"));
        Document request = QueueHelper$.MODULE$.buildRequestDocument(user, chainSetId, chainSetName, chainName, json);
        return ((SystemQueueManager)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(SystemQueueManager.class))).run(request).map((Function1 & Serializable)doc -> QueueHelper$.MODULE$.buildQueueResult((Document)doc)).map((Function1 & Serializable)_$9 -> {
            Either either = implicits$.MODULE$.catsSyntaxEither(_$9);
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)msg -> this.httpError((String)msg));
        }).onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof QueueManager.JobException) {
                QueueManager.JobException ex = (QueueManager.JobException)throwable;
                this.log().info(() -> this.runQueueRequest$$anonfun$4$$anonfun$1(ex, user, chainSetId, chainName), Line$.MODULE$.apply(203), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.runQueueRequest"));
                return scala.package$.MODULE$.Left().apply((Object)this.httpError(ex.getMessage()));
            }
            Throwable ex = throwable;
            this.log().error(() -> this.runQueueRequest$$anonfun$4$$anonfun$2(ex), ex, Line$.MODULE$.apply(206), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.runQueueRequest"));
            return scala.package$.MODULE$.Left().apply((Object)this.httpError("Unexpected error: " + ex));
        });
    }

    public int getStatus(Document doc) {
        Object object = doc.get("elxStatusCode", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)i -> new Gravity.Status(this.getStatus$$anonfun$1((BsonInt32)i))).getOrElse((Function0 & Serializable)() -> new Gravity.Status(this.getStatus$$anonfun$2()));
        if (object == null) {
            return BoxesRunTime.unboxToInt(null);
        }
        return ((Gravity.Status)object).code();
    }

    public GravityResponse httpError(String msg) {
        return Gravity$.MODULE$.BadRequestResponse(msg);
    }

    private final Object getValidChain$$anonfun$1$$anonfun$2(String msg$1) {
        return msg$1;
    }

    private final Object getValidChain$$anonfun$1$$anonfun$3(EndpointRequest er$3) {
        return "Chainset " + er$3.chainSetName() + " chain " + er$3.chainName() + " not found";
    }

    private final Document $anonfun$1() {
        return org.mongodb.scala.package$.MODULE$.Document().apply();
    }

    private final Object bytesModeResponse$$anonfun$1(List docs$1) {
        return "Http endpoint bytes mode endpoint with " + docs$1.size() + " document(s)";
    }

    private final Object bytesModeResponse$$anonfun$2() {
        return "Only the first document bytes will be returned.";
    }

    private final String $anonfun$3() {
        return "application/octet-stream";
    }

    private final Object bytesModeResponse$$anonfun$3() {
        return "ETL chain returns no bytes";
    }

    private final Object redirectModeResponse$$anonfun$1(List docs$2) {
        return "Http endpoint redirect mode endpoint with " + docs$2.size() + " document(s)";
    }

    private final Object redirectModeResponse$$anonfun$2() {
        return "Only the first document bytes will be returned.";
    }

    private final Option $anonfun$7(Document doc$1) {
        return doc$1.get("elxLocation", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
    }

    private final String $anonfun$9() {
        return "Missing location";
    }

    private final Option $anonfun$10(Document doc$2) {
        return doc$2.get("elxStatusCode", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class));
    }

    private final int $anonfun$12() {
        return 303;
    }

    private final Object redirectModeResponse$$anonfun$3(String location$1, int statusCode$1) {
        return "Redirecting to " + location$1 + " with statusCode " + statusCode$1;
    }

    private final Object redirectModeResponse$$anonfun$4() {
        return "No record available for redirect endpoint";
    }

    private final GravityResponse getChainSet$$anonfun$1$$anonfun$1(ChainSetName chainSetName$2) {
        int n = Gravity.Status$.MODULE$.NotFound();
        DataBytes dataBytes = DataBytes$.MODULE$.apply("ChainSet " + chainSetName$2 + " not found");
        Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    private final Object handleEndpointStream$$anonfun$1$$anonfun$1(EndpointRequest er$7) {
        return "handleEndpointStream(" + er$7.user().name() + "," + er$7.chainSetName() + "," + er$7.chainName() + ")";
    }

    private final GravityResponse handleEndpointStream$$anonfun$1(EndpointRequest er$6) {
        this.log().info(() -> this.handleEndpointStream$$anonfun$1$$anonfun$1(er$6), Line$.MODULE$.apply(180), FullName$.MODULE$.apply("ambience.etl.endpoint.EndpointHandler.handleEndpointStream"));
        ChainRunner chainRunner = (ChainRunner)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ChainRunner.class));
        Document initDoc = package$.MODULE$.ETLRecord().apply(er$6.initJson().noSpaces());
        Observable oDocs = chainRunner.runChain(er$6.user(), (ChainRunner.ChainSpec)ChainRunner.ChainNameSpec$.MODULE$.apply(er$6.chainSetName().chainsetName(), er$6.chainName()), Observable$.MODULE$.now((Object)initDoc));
        Observable jsonLines = oDocs.map((Function1 & Serializable)doc -> this.bsonToJsonNoSpaces((Document)doc)).intersperse((Object)"", (Object)"\n", (Object)"").map((Function1 & Serializable)_$8 -> _$8.getBytes(Gravity$.MODULE$.UTF_8()));
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Json()}));
        DataBytes dataBytes = DataBytes$.MODULE$.apply(jsonLines);
        int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    private final Object handleEndpointStream$$anonfun$2$$anonfun$1(EndpointRequest er$9, Throwable ex$1) {
        return "handleEndpointStream(" + er$9.user().name() + "," + er$9.chainSetName() + "," + er$9.chainName() + ") error " + ex$1;
    }

    private final Object runQueueRequest$$anonfun$1(UserDB.User user$1, ChainSetName chainSetName$3, String chainName$1) {
        return "Running queue request " + user$1.name() + " " + chainSetName$3.chainsetName() + " " + chainName$1;
    }

    private final Object runQueueRequest$$anonfun$4$$anonfun$1(QueueManager.JobException ex$2, UserDB.User user$2, ChainSetId chainSetId$1, String chainName$2) {
        return ex$2 + " for " + user$2.name() + " " + chainSetId$1 + " " + chainName$2;
    }

    private final Object runQueueRequest$$anonfun$4$$anonfun$2(Throwable ex$3) {
        return "Unexpected error: " + ex$3;
    }

    private final /* synthetic */ int getStatus$$anonfun$1(BsonInt32 i) {
        return Gravity.Status$.MODULE$.apply(i.getValue());
    }

    private final int getStatus$$anonfun$2() {
        return Gravity.Status$.MODULE$.OK();
    }
}

