/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.json;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLException;
import ambience.etl.ETLException$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.package$;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Try$;

public final class LineDelimitedJsonReader$
implements Builder,
Serializable {
    private static final String stepType;
    public static final LineDelimitedJsonReader$ MODULE$;

    private LineDelimitedJsonReader$() {
    }

    static {
        MODULE$ = new LineDelimitedJsonReader$();
        stepType = ETLStepType$.MODULE$.apply("json.LineDelimitedJsonReader");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LineDelimitedJsonReader$.class);
    }

    @Override
    public String stepType() {
        return stepType;
    }

    @Override
    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        return Right$.MODULE$.apply((Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)doc -> this.toJson((Document)doc)));
    }

    public Observable<Document> toJson(Document doc) {
        Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$2 -> _$2.getData());
        if (option instanceof Some) {
            byte[] bytes = (byte[])((Some)option).value();
            String json = new String(bytes, "UTF-8");
            Either result = Try$.MODULE$.apply(() -> this.$anonfun$1(json)).toEither();
            Either either = result;
            if (either instanceof Left) {
                Throwable ex = (Throwable)((Left)either).value();
                return Observable$.MODULE$.raiseError(ex);
            }
            if (either instanceof Right) {
                Iterator recs = (Iterator)((Right)either).value();
                return Observable$.MODULE$.fromIterator(Task$.MODULE$.apply(() -> this.toJson$$anonfun$2(recs)));
            }
            throw new MatchError((Object)either);
        }
        if (None$.MODULE$.equals(option)) {
            return Observable$.MODULE$.now((Object)doc);
        }
        throw new MatchError((Object)option);
    }

    private final Iterator $anonfun$1(String json$1) {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(json$1)).map((Function1 & Serializable)line -> {
            Either either = io.circe.parser.package$.MODULE$.decode(line, Decoder$.MODULE$.decodeJson());
            if (either instanceof Right) {
                Json rec = (Json)((Right)either).value();
                return rec;
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                throw new ETLException("Can't parse Line Delimited Json: " + line + ": " + err, ETLException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)either);
        });
    }

    private final Iterator toJson$$anonfun$2(Iterator recs$1) {
        return recs$1.map((Function1 & Serializable)j -> package$.MODULE$.ETLRecord().apply(j.noSpaces()));
    }
}

