/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.runtime.queue;

import ambience.api.Jobs;
import ambience.api.ReportEngine;
import ambience.etl.BsonToJson$;
import ambience.etl.runtime.queue.QueueHelper;
import ambience.etl.runtime.queue.QueueHelper$;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import ambience.queue.JobRunner;
import cats.Applicative;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ETLJobRunner
implements JobRunner,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ETLJobRunner.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final UserDB users;
    private final Jobs jobs;

    public ETLJobRunner(UserDB users, Jobs jobs) {
        this.users = users;
        this.jobs = jobs;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Document> run(Document doc) {
        return QueueHelper$.MODULE$.buildQueueRequest(this.users, doc).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                QueueHelper.QueueRequest req = (QueueHelper.QueueRequest)((Right)either).value();
                Jobs.RunRequest runRequest = Jobs.RunRequest$.MODULE$.apply(req.chainSetId(), req.chainName(), req.json(), (Option)None$.MODULE$, "etl-web");
                return this.jobs.runBatch(req.user(), runRequest).map((Function1 & Serializable)jd -> QueueHelper$.MODULE$.buildResponseDocument((Jobs.JobDefinition)jd)).onErrorRecover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception ex = (Exception)throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception ex = (Exception)throwable;
                            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)("Job Failed: " + ex.getMessage())), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                            return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        }
                        return function1.apply((Object)x);
                    }
                });
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(err)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            throw new MatchError((Object)either);
        });
    }

    public OptionT<Task, UserDB.User> loadUser(Document req) {
        Option option = req.get("user", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
        if (option instanceof Some) {
            BsonString s = (BsonString)((Some)option).value();
            return OptionT$.MODULE$.apply((Object)UserDB$.MODULE$.filterEnabled(this.users.getUserById(s.getValue())));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionT$.MODULE$.none((Applicative)Task$.MODULE$.catsAsync());
        }
        throw new MatchError((Object)option);
    }

    public OptionT<Task, String> loadRML(Document req) {
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)req.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> new ReportEngine.TemplatePath(ReportEngine.TemplatePath$.MODULE$.apply(s.getValue())))));
    }

    public OptionT<Task, MimeType> loadMimeType(Document req) {
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)req.get("mimeType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> MimeType$.MODULE$.apply(s.getValue()))));
    }

    /*
     * Enabled aggressive block sorting
     */
    public OptionT<Task, Json> loadParams(Document req) {
        None$ none$;
        Option option = req.get("parameters", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonDocument) {
                BsonDocument doc = (BsonDocument)bsonValue;
                none$ = Some$.MODULE$.apply(BsonToJson$.MODULE$.apply(doc).getOrElse(ETLJobRunner::loadParams$$anonfun$1));
                return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)none$));
            }
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                none$ = Some$.MODULE$.apply(package$.MODULE$.parse(bs.getValue()).getOrElse(ETLJobRunner::loadParams$$anonfun$2));
                return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)none$));
            }
        }
        none$ = None$.MODULE$;
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)none$));
    }

    public OptionT<Task, Json> loadRenderDetails(Document req) {
        return OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)req.get("renderDetails", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).flatMap((Function1 & Serializable)_$1 -> BsonToJson$.MODULE$.apply((BsonDocument)_$1))));
    }

    private static final Json loadParams$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Json loadParams$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

